<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package 7up-framework
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="http://gmpg.org/xfn/11">
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
<?php wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php $page_wrap = sv_get_value_by_id('sv_page_container');
    if(empty($page_wrap)){
        $page_wrap = 'wrap-default-container';
    }
    $fixed_class = '';
    $menu_fixed = sv_get_option('sv_menu_fixed');
    if($menu_fixed == 'on') $fixed_class = 'box-header-fixed';
?>
<div class="<?php echo esc_attr($page_wrap);?>">
    <header id="header" class="site-header header-container <?php echo esc_attr($fixed_class)?>">
        <div class="header box-header-02">
            <div class="container">
                <?php
                $page_id = sv_get_value_by_id('sv_header_page');
                if(!empty($page_id)) sv_get_header_visual($page_id);
                else sv_get_header_default($page_id)?>
            </div>
        </div>
    </header>
<!--header Close-->


