<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
 
/******************************************Core Function******************************************/
//Get option
if(!function_exists('sv_get_option')){
    function sv_get_option($key,$default=NULL)
    {
        if(function_exists('ot_get_option'))
        {
            return ot_get_option($key,$default);
        }

        return $default;
    }
}
if(!function_exists('s7upf_add_html_attr')){   
    function s7upf_add_html_attr($value,$echo = false,$attr='style'){
        $output = '';
        if(!empty($attr)){
            $output = $attr.'="'.$value.'"';
        }
        if($echo) echo apply_filters('s7upf_output_content',$output);
        else return $output;
    }
}
if(!function_exists('s7upf_add_style_tag')){   
    function s7upf_add_style_tag($value,$echo = false,$tag='style'){
        $output = '';
        if(!empty($tag)){
            $output = '<'.$tag.'>'.$value.'</style>';
        }
        if($echo) echo apply_filters('s7upf_output_content',$output);
        else return $output;
    }
}

//Autoload folder
if(!function_exists('sv_load_files')){
    function sv_load_files($folder)
    {
        //Auto load widget
        $files=glob(get_template_directory()."/"."7upframe/".$folder."/*.php");

        // Auto load all file
        if(!empty($files)){
            foreach ($files as $filename)
            {
                load_template($filename);
            }
        }

    }
}

//Get list header page
if(!function_exists('sv_list_header_page'))
{
    function sv_list_header_page()
    {
        global $post;
        $page_list = array();
        $page_list[] = array(
            'value' => '',
            'label' => esc_html__('-- Choose One --','theone')
        );
        $args= array(
        'post_type' => 'page',
        'posts_per_page' => -1, 
        );
        $query = new WP_Query($args);
        if($query->have_posts()): while ($query->have_posts()):$query->the_post();
            if (strpos($post->post_content, '[sv_logo') ||  strpos($post->post_content, '[sv_menu')) {
                $page_list[] = array(
                    'value' => $post->ID,
                    'label' => $post->post_title
                );
            }
            endwhile;
        endif;
        wp_reset_postdata();
        return $page_list;
    }
}

//Get list sidebar
if(!function_exists('sv_get_sidebar_ids'))
{
    function sv_get_sidebar_ids($for_optiontree=false)
    {
        global $wp_registered_sidebars;
        $r=array();
        $r[]=esc_html__('--Select--','theone');
        if(!empty($wp_registered_sidebars)){
            foreach($wp_registered_sidebars as $key=>$value)
            {

                if($for_optiontree){
                    $r[]=array(
                        'value'=>$value['id'],
                        'label'=>$value['name']
                    );
                }else{
                    $r[$value['id']]=$value['name'];
                }
            }
        }
        return $r;
    }
}

//Get order list
if(!function_exists('sv_get_order_list'))
{
    function sv_get_order_list($current=false,$extra=array(),$return='array',$type='')
    {
        $default = array(
            esc_html__('None','theone')               => 'none',
            esc_html__('Post ID','theone')            => 'ID',
            esc_html__('Author','theone')             => 'author',
            esc_html__('Post Title','theone')         => 'title',
            esc_html__('Post Name','theone')          => 'name',
            esc_html__('Post Date','theone')          => 'date',
            esc_html__('Last Modified Date','theone') => 'modified',
            esc_html__('Post Parent','theone')        => 'parent',
            esc_html__('Random','theone')             => 'rand',
            esc_html__('Comment Count','theone')      => 'comment_count',
            esc_html__('View Post','theone')          => 'post_views',
            esc_html__('Like Post','theone')          => '_post_like_count',
            esc_html__('Custom Modified Date','theone')=> 'time_update',            
        );
        if(!empty($type)){
            $default = array(
                'none'              => esc_html__('None','theone'),
                'ID'                => esc_html__('Post ID','theone'),
                'author'            => esc_html__('Author','theone'),
                'title'             => esc_html__('Post Title','theone'),
                'name'              => esc_html__('Post Name','theone'),
                'date'              => esc_html__('Post Date','theone'),
                'modified'          => esc_html__('Last Modified Date','theone'),
                'parent'            => esc_html__('Post Parent','theone'),
                'rand'              => esc_html__('Random','theone'),
                'comment_count'     => esc_html__('Comment Count','theone'),
                'post_views'        => esc_html__('View Post','theone'),
                '_post_like_count'  => esc_html__('Like Post','theone'),
                'time_update'       => esc_html__('Custom Modified Date','theone'),
            );
        }

        if(!empty($extra) and is_array($extra))
        {
            $default=array_merge($default,$extra);
        }

        if($return=="array")
        {
            return $default;
        }elseif($return=='option')
        {
            $html='';
            if(!empty($default)){
                foreach($default as $key=>$value){
                    $selected=selected($key,$current,false);
                    $html.="<option {$selected} value='{$key}'>{$value}</option>";
                }
            }
            return $html;
        }
    }
}

// Get sidebar
if(!function_exists('sv_get_sidebar'))
{
    function sv_get_sidebar()
    {
        $default=array(
            'position'=>'right',
            'id'      =>'blog-sidebar'
        );

        return apply_filters('sv_get_sidebar',$default);
    }
}

//Favicon
if(!function_exists('sv_load_favicon') )
{
    function sv_load_favicon()
    {
        $value = sv_get_option('favicon');
        $favicon = (isset($value) && !empty($value))?$value:false;
        if($favicon)
            echo '<link rel="Shortcut Icon" href="' . esc_url( $favicon ) . '" type="image/x-icon" />' . "\n";
    }
}
if(!function_exists( 'wp_site_icon' ) ){
    add_action( 'wp_head','sv_load_favicon');
    add_action('login_head', 'sv_load_favicon');
    add_action('admin_head', 'sv_load_favicon');
}

//Add header style
if (!function_exists('sv_add_head_style')) {
    function sv_add_head_style($style) {
        $content ='<script type="text/javascript">
                    (function($) {
                        "use strict";
                        $("head").append('."'".'<style id="sv_add_footer_css">'.$style.'</style>'."'".');
                    })(jQuery);
                    </script>';
        return $content;
    }
}

//Fill css background
if(!function_exists('sv_fill_css_background'))
{
    function sv_fill_css_background($data)
    {
        $string = '';
        if(!empty($data['background-color'])) $string .= 'background-color:'.$data['background-color'].';'."\n";
        if(!empty($data['background-repeat'])) $string .= 'background-repeat:'.$data['background-repeat'].';'."\n";
        if(!empty($data['background-attachment'])) $string .= 'background-attachment:'.$data['background-attachment'].';'."\n";
        if(!empty($data['background-position'])) $string .= 'background-position:'.$data['background-position'].';'."\n";
        if(!empty($data['background-size'])) $string .= 'background-size:'.$data['background-size'].';'."\n";
        if(!empty($data['background-image'])) $string .= 'background-image:url("'.$data['background-image'].'");'."\n";
        if(!empty($string)) return SV_Assets::build_css($string);
        else return false;
    }
}

// Get list menu
if(!function_exists('sv_list_menu_name'))
{
    function sv_list_menu_name()
    {
        $menu_nav = wp_get_nav_menus();
        $menu_list = array('Default' => '');
        if(is_array($menu_nav) && !empty($menu_nav))
        {
            foreach($menu_nav as $item)
            { 
                if(is_object($item))
                {
                    $menu_list[$item->name] = $item->slug;
                }
            }
        }
        return $menu_list;
    }
}

//Display BreadCrumb
if(!function_exists('sv_display_breadcrumb'))
{
    function sv_display_breadcrumb()
    {
        $breadcrumb = sv_get_value_by_id('sv_show_breadrumb');
        if($breadcrumb == 'on'){ 
            $b_class = sv_fill_css_background(sv_get_option('sv_bg_breadcrumb'));
            ?>
            <div class="container">
                <div class="row">                        
                    <div class="breadcrumbs <?php echo esc_attr($b_class)?>">
                        <?php 
                            if(function_exists('bcn_display')) bcn_display();
                            else sv_breadcrumb();
                        ?>
                    </div>
                </div>
            </div>
        <?php }
    }
}

//Custom BreadCrumb
if(!function_exists('sv_breadcrumb'))
{
    function sv_breadcrumb() {
        global $post;
        echo '<ul id="breadcrumbs">';
        if (!is_home()) {
            echo '<li><a href="';
            echo esc_url(home_url('/'));
            echo '">';
            echo esc_html__('Home','theone');
            echo '</a></li><li class="separator">'.' / '.'</li>';
            if (is_category() || is_single()) {
                echo '<li>';
                the_category(' </li><li class="separator"> / </li><li> ');
                if (is_single()) {
                    echo '</li><li class="separator"> / </li><li>';
                    the_title();
                    echo '</li>';
                }
            } elseif (is_page()) {
                if($post->post_parent){
                    $anc = get_post_ancestors( get_the_ID() );
                    $title = get_the_title();
                    foreach ( $anc as $ancestor ) {
                        $output = '<li><a href="'.get_permalink($ancestor).'" title="'.get_the_title($ancestor).'">'.get_the_title($ancestor).'</a></li> <li class="separator">/</li>';
                    }
                    echo balanceTags($output);
                    echo '<strong title="'.$title.'"> '.$title.'</strong>';
                } else {
                    echo '<li><strong> '.get_the_title().'</strong></li>';
                }
            }
        }
        elseif (is_tag()) {single_tag_title();}
        elseif (is_day()) {echo"<li>".esc_html__("Archive for ","theone"); echo get_the_time('F jS, Y'); echo'</li>';}
        elseif (is_month()) {echo"<li>".esc_html__("Archive for ","theone"); echo get_the_time('F, Y'); echo'</li>';}
        elseif (is_year()) {echo"<li>".esc_html__("Archive for ","theone"); echo get_the_time('Y'); echo'</li>';}
        elseif (is_author()) {echo"<li>".esc_html__("Author Archive ","theone"); echo'</li>';}
        elseif (isset($_GET['paged']) && !empty($_GET['paged'])) {echo "<li>".esc_html__("Blog Archives","theone"); echo'</li>';}
        elseif (is_search()) {echo"<li>".esc_html__("Search Results","theone"); echo'</li>';}
        echo '</ul>';
    }
}

//Get page value by ID
if(!function_exists('sv_get_value_by_id'))
{   
    function sv_get_value_by_id($key)
    {
        if(!empty($key)){
            $id = get_the_ID();
            if(is_front_page()) $id = (int)get_option('page_on_front');
            if(is_front_page() && is_home()) $id = (int)get_option( 'page_on_front' );
            if(!is_front_page() && is_home()) $id = (int)get_option( 'page_for_posts' );
            if (class_exists('woocommerce')) {
                if(is_shop()) $id = (int)get_option('woocommerce_shop_page_id');
                if(is_cart()) $id = (int)get_option('woocommerce_cart_page_id');
                if(is_checkout()) $id = (int)get_option('woocommerce_checkout_page_id');
                if(is_account_page()) $id = (int)get_option('woocommerce_myaccount_page_id');
            }
            if(is_archive() || is_search()) $id = 0;
            $value = get_post_meta($id,$key,true);
            if(empty($value)) $value = sv_get_option($key);
            return $value;
        }
        else return 'Missing a variable of this funtion';
    }
}

//Check woocommerce page
if (!function_exists('sv_is_woocommerce_page')) {
    function sv_is_woocommerce_page() {
        if(  function_exists ( "is_woocommerce" ) && is_woocommerce()){
                return true;
        }
        $woocommerce_keys   =   array ( "woocommerce_shop_page_id" ,
                                        "woocommerce_terms_page_id" ,
                                        "woocommerce_cart_page_id" ,
                                        "woocommerce_checkout_page_id" ,
                                        "woocommerce_pay_page_id" ,
                                        "woocommerce_thanks_page_id" ,
                                        "woocommerce_myaccount_page_id" ,
                                        "woocommerce_edit_address_page_id" ,
                                        "woocommerce_view_order_page_id" ,
                                        "woocommerce_change_password_page_id" ,
                                        "woocommerce_logout_page_id" ,
                                        "woocommerce_lost_password_page_id" ) ;
        foreach ( $woocommerce_keys as $wc_page_id ) {
                if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
                        return true ;
                }
        }
        return false;
    }
}

//navigation
if(!function_exists('sv_paging_nav'))
{
    function sv_paging_nav()
    {
        // Don't print empty markup if there's only one page.
        if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
            return;
        }

        $paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
        $pagenum_link = html_entity_decode( get_pagenum_link() );
        $query_args   = array();
        $url_parts    = explode( '?', $pagenum_link );

        if ( isset( $url_parts[1] ) ) {
            wp_parse_str( $url_parts[1], $query_args );
        }

        $pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
        $pagenum_link = trailingslashit( $pagenum_link ) . '%_%';

        $format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
        $format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';

        // Set up paginated links.
        $links = paginate_links( array(
            'base'     => $pagenum_link,
            'format'   => $format,
            'total'    => $GLOBALS['wp_query']->max_num_pages,
            'current'  => $paged,
            'mid_size' => 1,
            'type'     => 'list',
            'add_args' => array_map( 'urlencode', $query_args ),
            'prev_text' => '<i class="fa fa-angle-left"></i>',
            'next_text' => '<i class="fa fa-angle-right"></i>',
        ) );

        if ($links) : ?>
            <div class="pages">
                <strong><?php echo esc_html__("Pages","theone").' '.$paged.' '.esc_html__("of","theone").' '.$GLOBALS['wp_query']->max_num_pages?></strong>
                <?php echo balanceTags($links); ?>
            </div>
        <?php endif;
    }
}

//Set post view
if(!function_exists('sv_set_post_view'))
{
    function sv_set_post_view($postID=false)
    {
        if(!$postID) $postID = get_the_ID();

        $user_ip = $_SERVER['REMOTE_ADDR']; //retrieve the current IP address of the visitor
        $key = $user_ip . 'x' . $postID; //combine post ID & IP to form unique key
        $value = array($user_ip, $postID); // store post ID & IP as separate values (see note)
        $visited = get_transient($key); //get transient and store in variable

        //check to see if the Post ID/IP ($key) address is currently stored as a transient
        if ( false === ( $visited ) ) {

            //store the unique key, Post ID & IP address for 12 hours if it does not exist
            set_transient( $key, $value, 60*60*12 );

            // now run post views function
            $count_key = 'post_views';
            $count = get_post_meta($postID, $count_key, true);
            if($count==''){
                $count = 0;
                delete_post_meta($postID, $count_key);
                add_post_meta($postID, $count_key, '0');
            }else{
                $count++;
                update_post_meta($postID, $count_key, $count);
            }
        }
    }
}

//Get post view
if(!function_exists('sv_get_post_view'))
{
    function sv_get_post_view($post_id=false)
    {
        if(!$post_id) $post_id=get_the_ID();

        return (int)get_post_meta($post_id,'post_views',true);
    }
}

//remove attr embed
if(!function_exists('sv_remove_w3c')){
    function sv_remove_w3c($embed_code){
        $embed_code=str_replace('webkitallowfullscreen','',$embed_code);
        $embed_code=str_replace('mozallowfullscreen','',$embed_code);
        $embed_code=str_replace('frameborder="0"','',$embed_code);
        $embed_code=str_replace('frameborder="no"','',$embed_code);
        $embed_code=str_replace('scrolling="no"','',$embed_code);
        $embed_code=str_replace('&','&amp;',$embed_code);
        $embed_code=str_replace('" width','?byline=0&amp;portrait=0&amp;title=0" width',$embed_code);
        return $embed_code;
    }
}

// MetaBox
if(!function_exists('sv_display_metabox'))
{
    function sv_display_metabox($type ='') {?>
        <div class="meta-box">
            <!-- <span class="meta-item"><i class="fa fa-calendar"></i><?php //echo get_the_date('M j Y'); ?></span> -->
            <a class="meta-item" href="<?php echo get_author_posts_url(get_the_author_meta('ID')); ?>"><i class="fa fa-user"></i><?php echo get_the_author(); ?></a>
            <span class="meta-item"><i class="fa fa-folder-open"></i>
                <?php $cats = get_the_category_list(', ');?>
                <?php if($cats) echo balanceTags($cats); else esc_html_e("Sin categoria",'theone');?>
            </span>
            <span class="meta-item"><i class="fa fa-tags"></i>
                <?php $tags = get_the_tag_list('',', ','');?>
                <?php if($tags) echo balanceTags($tags); else esc_html_e("Sin etiqueta",'theone');?>
            </span>

            <a class="meta-item-end" href="<?php echo get_comments_link()?>"><i class="fa fa-comments"></i><?php echo get_comments_number(); ?> <?php echo (get_comments_number()>1) ? esc_html__('Comments','theone') :  esc_html__('Comment','theone')?> </a>
            
        </div>
    <?php }
}
/***************************************END Core Function***************************************/


/***************************************Add Theme Function***************************************/
if(!function_exists('sv_vc_list_taxonomy'))
{
    function sv_vc_list_taxonomy($taxonomy,$show_all = true)
    {
        if($show_all) $list = array('--Select--' => '');
        else $list = array();
        if(!isset($taxonomy) || empty($taxonomy)) $taxonomy = 'category';
        $tags = get_terms($taxonomy);
        foreach ($tags as $tag) {
            $list[$tag->name] = $tag->slug;
        }
        return $list;
    }
}
if(!function_exists('sv_meta_post'))
{
    function sv_meta_post()
    {
        $cats = get_the_category_list('<span>, </span>');
        $tags = get_the_tag_list('','<span>, </span>','');
        if($cats){
            $cats_html = balanceTags($cats); 
        }
        else{
            $cats_html = '<span>'.esc_html__(" No Category",'theone').'</span>';
        }
        if($tags){
            $tags_html = balanceTags($tags);
        }
        else{
            $tags_html = '<span>'.esc_html__(" No Tag",'theone').'<span>';
        }
        //<a class="meta-item post-view" href="'.get_the_permalink().'"><i class="fa fa-eye"></i>'.sv_get_post_view().'</a>
        $html = '<div class="trending-meta">
                    <span class="post-date"><i class="fa fa-calendar-o"></i>  <a href="'.get_the_permalink().'">'.get_the_time('d. M Y').'</a></span>
                    <a class="meta-item" href="'.get_author_posts_url(get_the_author_meta('ID')).'"><i class="fa fa-user"></i>'.get_the_author().'</a>
                    <div class="meta-item"><i class="fa fa-folder-open"></i>'.$cats_html.'</div>
                    <div class="meta-item last"><i class="fa fa-tags"></i>'.$tags_html.'</div> 
                    <span class="post-comment"><i class="fa  fa-comment-o"></i>  '.get_comments_number().'</span>
                </div>';
        return $html;
    }
}
if(!function_exists('sv_meta_post_widget'))
{
    function sv_meta_post_widget()
    {
        
        $html =     '<div class="trending-meta">
                        <span class="post-date"><i class="fa fa-calendar-o"></i>  '.get_the_time('d. M Y').'</span>
                        <span class="post-comment"><i class="fa  fa-comment-o"></i>  '.get_comments_number().'</span>
                    </div>';
        return $html;
    }
}
if(!function_exists('sv_header_image'))
{
    function sv_header_image()
    {
        $header_show = sv_get_value_by_id('sv_header_show');
        $header_image = sv_get_value_by_id('sv_header_image');
        $header_link = sv_get_value_by_id('sv_header_link');
        if(!empty($header_image) && $header_show == 'on'):
        ?>
            <div class="container">
                <div class="row">
                    <div class="position-01">
                        <a class="product-image" href="<?php echo esc_url($header_link);?>">
                            <img src="<?php echo esc_url($header_image);?>" alt="">
                        </a>
                    </div>
                </div>
            </div>
        <?php
        endif;
    }
}
if(!function_exists('sv_header_main_blog'))
{
    function sv_header_main_blog()
    {        
        $id = get_the_ID();
        if(is_front_page() && is_home()) $id = (int)get_option( 'page_on_front' );
        if(!is_front_page() && is_home()) $id = (int)get_option( 'page_for_posts' );
        $title = get_the_title($id);
        if(is_front_page() && is_home()) $title = esc_html__( 'Blog ', 'theone' );
        if(is_archive()) $title = get_the_archive_title();
        if(is_search()) $title = esc_html__( 'Search Results for: ', 'theone' ).'<span>' . get_search_query() . '</span>';
        ?>
            <div class="tittle-general">
                <h2><?php echo balanceTags($title);?></h2>
                <div class="box-latest">
                    <a class="text-01" href="#"><?php esc_html_e("Categorias","theone")?></a>
                    <div class="block-latest">
                        <ul>
                            <?php wp_list_categories(array('title_li' => ''));?>
                        </ul>
                    </div>
                </div>
            </div>
        <?php
    }
}
if(!function_exists('sv_display_sharebox'))
{
    function sv_display_sharebox()
    { 
        global $post;?>
        <div class="box-left">
            <h3><?php esc_html_e("compartir","theone");?></h3>
            <ul>
                <li>
                    <a class="social-share" href="http://www.facebook.com/sharer.php?u=<?php echo get_the_permalink();?>">
                        <i class="fa fa-facebook"></i>
                        <div class="wrap-text">
                            <span class="text-01"><?php esc_html_e("compartir","theone");?></span>
                            <span class="text-02"><?php echo get_post_meta(get_the_ID(),'facebook_share_count',true);?></span>
                        </div>
                    </a>
                </li>
                <li>
                    <a class="social-share" href="http://twitthis.com/twit?url=<?php echo get_the_permalink();?>">
                        <i class="fa fa-twitter"></i>
                        <div class="wrap-text">
                            <span class="text-01"><?php esc_html_e("tweet","theone");?></span>
                            <span class="text-02"><?php echo get_post_meta(get_the_ID(),'twitter_share_count',true);?></span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="mailto:?subject=<?php echo esc_attr($post->post_name); ?>&amp;body=<?php the_permalink(); ?>">
                        <i class="fa fa-envelope"></i>
                        <div class="wrap-text">
                            <span class="text-01"><?php esc_html_e("enviar","theone");?></span>
                            <span class="text-02"><?php echo get_post_meta(get_the_ID(),'mail_count',true);?></span>
                        </div>
                    </a>
                </li>
                <li>
                    <a href="<?php echo esc_url( get_comments_link() ); ?>">
                        <i class="fa fa-commenting-o"></i>
                        <div class="wrap-text">
                            <span class="text-01"><?php esc_html_e("comentar","theone");?></span>
                            <span class="text-02"><?php echo get_comments_number();?></span>
                        </div>
                    </a>
                </li>
            </ul>
        </div>
    <?php }
}
if(!function_exists('sv_single_related_post'))
{
    function sv_single_related_post()
    { 
        $sidebar=sv_get_sidebar();
        $sidebar_pos=$sidebar['position'];
        $item = 2;
        if(sv_get_value_by_id('sv_page_container') == 'wrap-default-container' && $sidebar_pos != 'no'){
            $item = 2;
        }
        else{
            $item = 3;
        }
    ?>
        <div class="position-04 box-style-15px style-top-6px">
            <div class="tab-item">
                <ul>
                   <li class="active"><a href="#item_tab50" data-toggle="tab"><?php esc_html_e("ARTICULOS RELACIONADOS","theone");?></a></li>
                   <li><a href="#item_tab51" data-toggle="tab"><?php esc_html_e("MÁS DEL AUTOR","theone");?></a></li>
                </ul>
            </div>
            <div class="tab-content">
                <div id="item_tab50" class="tab-pane active">
                    <div id="vt_slider_50" class="vt_slider">
                        <div class="navslider">
                            <a href="#" class="prev"><?php esc_html_e("Ant.","theone");?></a>
                            <a href="#" class="next"><?php esc_html_e("Sig.","theone");?></a>
                        </div>
                        <div class="slider-inner">
                            <div class="container-slider">
                                <div class="wrap-item-products sv-custom-slider" data-num="<?php echo esc_attr($item);?>" data-speed="" data-itemres="1,2,<?php echo esc_attr($item);?>">
                                    <?php
                                        $categories = get_the_category(get_the_ID());
                                        $category_ids = array();
                                        foreach($categories as $individual_category){
                                            $category_ids[] = $individual_category->term_id;
                                        }
                                        $args=array(
                                            'category__in' => $category_ids,
                                            'post__not_in' => array(get_the_ID()),
                                            'posts_per_page'=>5
                                            );                                        
                                        $query = new wp_query($args);
                                        if( $query->have_posts() ) {
                                            while ($query->have_posts()) {
                                                $query->the_post();
                                            echo '<div class="item">
                                                    <a class="product-image zoom-image time3s" href="'.get_the_permalink().'">
                                                        '.get_the_post_thumbnail(get_the_ID(),array(286,286)).'
                                                    </a>
                                                    <p><a class="post-title" href="'.get_the_permalink().'">'.get_the_title().'</a></p>
                                                </div>';
                                            }
                                        }
                                        wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>                    
                </div>
                <div id="item_tab51" class="tab-pane">
                    <div id="vt_slider_51" class="vt_slider">
                        <div class="navslider">
                            <a href="#" class="prev"><?php esc_html_e("Ant.","theone");?></a>
                            <a href="#" class="next"><?php esc_html_e("Sig.","theone");?></a>
                        </div>
                        <div class="slider-inner">
                            <div class="container-slider">
                                <div class="wrap-item-products sv-custom-slider" data-num="<?php echo esc_attr($item);?>" data-speed="" data-itemres="1,2,<?php echo esc_attr($item);?>">
                                    <?php
                                        $args = array(
                                            'author'            => get_the_author_meta('ID'),
                                            'post__not_in'      => array(get_the_ID()),
                                            'posts_per_page'    =>5
                                        );                                       
                                        $query = new wp_query($args);
                                        if( $query->have_posts() ) {
                                            while ($query->have_posts()) {
                                                $query->the_post();
                                            echo '<div class="item">
                                                    <a class="product-image zoom-image time3s" href="'.get_the_permalink().'">
                                                        '.get_the_post_thumbnail(get_the_ID(),array(286,286)).'
                                                    </a>
                                                    <p>'.get_the_title().'</p>
                                                </div>';
                                            }
                                        }
                                        wp_reset_postdata();
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>                    
                </div>
            </div>
        </div>
    <?php }
}
if(!function_exists('sv_author_box'))
{
    function sv_author_box()
    { 
        $des = get_the_author_meta('description');
        if(!empty($des)){
        ?>
        <div class="about-author box-style-2 style-top-6px">
            <div class="tittle-general">
                <h2><?php esc_html_e("ACERCA DEL AUTOR ","theone");echo '<span> / '.get_bloginfo('name', 'display').'</span>';?></h2>
            </div>            
            <a class="product-image" href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ); ?>">
                <?php echo get_avatar(get_the_author_meta('email','97')); ?>
            </a>
            <div class="infor">
                <p><?php echo get_the_author_meta('description'); ?></p>
                <ul class="block-social">
                    <?php
                        global $post;
                        $sl=array(
                            'googleplus'    =>  "fa fa-google-plus",
                            'facebook'      =>  "fa fa-facebook",
                            'twitter'       =>  "fa fa-twitter",
                            'linkedin'      =>  "fa fa-linkedin",
                            'github'        =>  'fa fa-github',
                            'tumblr'        =>  'fa fa-tumblr',
                            'youtube'       =>  'fa fa-youtube',
                            'instagram'     =>  'fa fa-instagram',
                            'vimeo'         =>  'fa fa-vimeo'
                        );
                        if(isset($post->post_author)){
                            foreach($sl as $type=>$class){
                                $url  = get_user_option( $type, $post->post_author );
                                if($url==true){?>
                                    <li><a href="<?php echo esc_url($url);?>"><i class="<?php echo esc_attr($class);?>"></i></a></li>
                                <?php }
                            }
                        }
                        ?>
                 </ul>
            </div>
        </div>
    <?php }
    }
}

//Search Product By Category
if(!function_exists('sv_search_product')){
    function sv_search_product(){?>
    <form id="search_mini_form" method="get" class="woocommerce-product-search" action="<?php echo esc_url( home_url( '/'  ) ); ?>">
        <div class="dropdown-cate">
            <span class="cat-search"><?php esc_html_e("Todas las categorias",'theone');?></span>
            <div class="wrap-scrollbar">
                <div class="slimScrollDiv">
                    <div class="scrollbar">
                        <ul>
                            <li><?php esc_html_e("Todas las categorias",'theone');?> </li>
                            <?php 
                                $product_cat_list = get_terms('product_cat');
                                if(is_array($product_cat_list) && !empty($product_cat_list)){
                                    foreach ($product_cat_list as $cat) {
                                        echo '<li data-filter=".'.$cat->slug.'">'.$cat->name.'</li>';
                                    }
                                }
                            ?>
                        </ul>
                    </div>
                    <div class="slimScrollBar"></div>
                    <div class="slimScrollRail"></div>
                </div>
            </div>
        </div>
        <div class="form-search">    
            <input id="search" type="search" class="input-text" placeholder="<?php echo esc_html__( 'Enter Key Search ...', 'theone' ); ?>" value="<?php echo get_search_query(); ?>" name="s"/>
            <input type="hidden" name="post_type" value="product" />
            <input class="cat-value" type="hidden" name="product_cat" value="" />
            <button type="submit" class="button form-button"><span><?php echo esc_html__( 'Search', 'theone' ); ?></span></button>
        </div>
    </form>

    <?php }
}
//Get list post
if(!function_exists('sv_get_post_list'))
{
    function sv_get_post_list()
    {  
        $post_list = array(esc_html__("-- Select --","theone") => '');
        $args= array(
            'post_type' => 'post',
            'posts_per_page' => 100, 
        );
        $query = new WP_Query($args);
        if($query->have_posts()): while ($query->have_posts()):
            $query->the_post();
            $post_list['(ID='.get_the_ID().') -'.get_the_title()] = get_the_ID();
            endwhile;
        endif;
        wp_reset_postdata();
        return $post_list;
    }
}
if(!function_exists('sv_getBrowser')){
    function sv_getBrowser() 
    { 
        $u_agent = $_SERVER['HTTP_USER_AGENT'];
        $bname = 'Unknown';
        $platform = 'Unknown';
        $version= "";

        //First get the platform?
        if (preg_match('/linux/i', $u_agent)) {
            $platform = 'linux';
        }
        elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
            $platform = 'mac';
        }
        elseif (preg_match('/windows|win32/i', $u_agent)) {
            $platform = 'windows';
        }
        
        // Next get the name of the useragent yes seperately and for good reason
        if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Internet Explorer'; 
            $ub = "MSIE"; 
        } 
        elseif(preg_match('/Firefox/i',$u_agent)) 
        { 
            $bname = 'Mozilla Firefox'; 
            $ub = "Firefox"; 
        } 
        elseif(preg_match('/Chrome/i',$u_agent)) 
        { 
            $bname = 'Google Chrome'; 
            $ub = "Chrome"; 
        } 
        elseif(preg_match('/Safari/i',$u_agent)) 
        { 
            $bname = 'Apple Safari'; 
            $ub = "Safari"; 
        } 
        elseif(preg_match('/Opera/i',$u_agent)) 
        { 
            $bname = 'Opera'; 
            $ub = "Opera"; 
        } 
        elseif(preg_match('/Netscape/i',$u_agent)) 
        { 
            $bname = 'Netscape'; 
            $ub = "Netscape"; 
        } 
        
        // finally get the correct version number
        $known = array('Version', $ub, 'other');
        $pattern = '#(?<browser>' . join('|', $known) .
        ')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
        if (!preg_match_all($pattern, $u_agent, $matches)) {
            // we have no matching number just continue
        }
        
        // see how many we have
        $i = count($matches['browser']);
        if ($i != 1) {
            //we will have two since we are not using 'other' argument yet
            //see if version is before or after the name
            if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
                $version= $matches['version'][0];
            }
            else {
                $version= $matches['version'][1];
            }
        }
        else {
            $version= $matches['version'][0];
        }
        
        // check if we have a number
        if ($version==null || $version=="") {$version="?";}
        
        return array(
            'userAgent' => $u_agent,
            'name'      => $bname,
            'version'   => $version,
            'platform'  => $platform,
            'pattern'    => $pattern
        );
    }
}
//Compare URL
if(!function_exists('sv_compare_url')){
    function sv_compare_url($echo = false, $ajax = false){
        global $yith_woocompare;
        $browser = sv_getBrowser();
        if(strpos($browser['name'],'Safari')) $safari = false;
        else $safari = true;
        if(class_exists('YITH_Woocompare_Frontend') && $safari){            
            if($echo){
                if($ajax){
                    $compare = new YITH_Woocompare_Frontend();
                    echo '<a href="'.$compare->add_product_url( get_the_ID()).'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.esc_html__('Compare','theone').'</a>';
                }
                else echo '<a href="'.$yith_woocompare->obj->add_product_url( get_the_ID()).'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.esc_html__('Compare','theone').'</a>';
            }
            else{
                if($ajax){
                    $compare = new YITH_Woocompare_Frontend();
                    $html = '<a href="'.$compare->add_product_url( get_the_ID()).'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.esc_html__('Compare','theone').'</a>';
                }
                else $html = '<a href="'.$yith_woocompare->obj->add_product_url( get_the_ID()).'" class="compare link-compare" data-product_id="'.get_the_ID().'">'.esc_html__('Compare','theone').'</a>';
                return $html;
            }
        }
    }
}

if(!function_exists('sv_get_list_animation'))
{
    function sv_get_list_animation() {
        $list = array(
            'None'              => '',
            'fadeIn'            => 'fadeIn',
            'fadeInUp'          => 'fadeInUp',
            'fadeInDown'        => 'fadeInDown',
            'fadeInLeft'        => 'fadeInLeft',
            'fadeInRight'       => 'fadeInRight',
            'fadeInUpLarge'     => 'fadeInUpLarge',
            'fadeInDownLarge'   => 'fadeInDownLarge',
            'fadeInLeftLarge'   => 'fadeInLeftLarge',
            'fadeInRightLarge'  => 'fadeInRightLarge',
            'fadeOut'           => 'fadeOut',
            'fadeOutUp'         => 'fadeOutUp',
            'fadeOutDown'       => 'fadeOutDown',
            'fadeOutLeft'       => 'fadeOutLeft',
            'fadeOutRight'      => 'fadeOutRight',
            'fadeOutUpLarge'    => 'fadeOutUpLarge',
            'fadeOutDownLarge'  => 'fadeOutDownLarge',
            'fadeOutLeftLarge'  => 'fadeOutLeftLarge',
            'fadeOutRightLarge' => 'fadeOutRightLarge',
            'zoomIn'            => 'zoomIn',
            'zoomInUp'          => 'zoomInUp',
            'zoomInDown'        => 'zoomInDown',
            'zoomInLeft'        => 'zoomInLeft',
            'zoomInRight'       => 'zoomInRight',
            'zoomInUpLarge'     => 'zoomInUpLarge',
            'zoomInDownLarge'   => 'zoomInDownLarge',
            'zoomInLeftLarge'   => 'zoomInLeftLarge',
            'zoomInRightLarge'  => 'zoomInRightLarge',
            'zoomOut'           => 'zoomOut',
            'zoomOutUp'         => 'zoomOutUp',
            'zoomOutDown'       => 'zoomOutDown',
            'zoomOutLeft'       => 'zoomOutLeft',
            'zoomOutRight'      => 'zoomOutRight',
            'zoomOutUpLarge'    => 'zoomOutUpLarge',
            'zoomOutDownLarge'  => 'zoomOutDownLarge',
            'zoomOutLeftLarge'  => 'zoomOutLeftLarge',
            'zoomOutRightLarge' => 'zoomOutRightLarge',
            'bounce'            => 'bounce',
            'bounceIn'          => 'bounceIn',
            'bounceInUp'        => 'bounceInUp',
            'bounceInDown'      => 'bounceInDown',
            'bounceInLeft'      => 'bounceInLeft',
            'bounceInRight'     => 'bounceInRight',
            'bounceOut'         => 'bounceOut',
            'bounceOutUp'       => 'bounceOutUp',
            'bounceOutDown'     => 'bounceOutDown',
            'bounceOutLeft'     => 'bounceOutLeft',
            'bounceOutRight'    => 'bounceOutRight',
            'spinLeft'          => 'spinLeft',
            'spinRight'         => 'spinRight',
            'flash'             => 'flash',
            'strobe'            => 'strobe',
            'shake'             => 'shake',
            'tada'              => 'tada',
            'wave'              => 'wave',
            'spin'              => 'spin',
            'pullback'          => 'pullback',
            'wobble'            => 'wobble',
            'pulse'             => 'pulse',
            'pulsate'           => 'pulsate',
            'heartbeat'         => 'heartbeat',
            'panic'             => 'panic',
            'explode'           => 'explode',
            );
        return $list;
    }
}
if(!function_exists('sv_get_header_default')){
    function sv_get_header_default(){
        ?>
            <div class="row">
                <div class="navbar-header">
                    <a class="logo" href="<?php echo esc_url(home_url('/'));?>" title="<?php esc_attr_e("logo","theone") ?>">
                        <?php $sv_logo=sv_get_option('logo');?>
                        <?php if($sv_logo!=''){
                            echo '<img src="' . esc_url($sv_logo) . '" alt="">';
                        }   else { echo '<h1>'.get_bloginfo('name', 'display').'</h1>'; }
                        ?>
                    </a>
                </div>
                <div class="magemenu-menu nav-exploded navbar vt-magemenu horizontal-menu">
                    <?php if ( has_nav_menu( 'primary' ) ) {
                         wp_nav_menu( array(
                                 'theme_location' => 'primary',
                                 'container'=>false,
                                 'walker'=>new SV_Walker_Nav_Menu(),
                                 'menu_class'=>'explodedmenu',
                             )
                         );
                    } ?>
                </div>
            </div>
        <?php
    }
}
if(!function_exists('sv_get_footer_default')){
    function sv_get_footer_default(){
        ?>
        <div id="tiny-footer" class="tiny-footer">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <p class="copyright-ct"><?php printf(esc_html__('&copy; 7up %s   |   Privacy policy','theone'),get_bloginfo('title'))?></p>
                    </div>

                </div>
            </div>
        </div>
        <?php
    }
}
if(!function_exists('sv_get_footer_visual')){
    function sv_get_footer_visual($page_id){
        ?>
        <footer id="colophon" class="site-footer">
            <div class="container">
                <div class="block-footer-general">
                    <?php 
                    if(function_exists('is_bbpress')){
                        if(is_bbpress()) echo do_shortcode(SV_Template::get_vc_pagecontent($page_id));
                        else echo SV_Template::get_vc_pagecontent($page_id);
                    }
                    else echo SV_Template::get_vc_pagecontent($page_id);
                    ?>
                </div>
            </div>
        </footer>
        <?php
    }
}
if(!function_exists('sv_get_header_visual')){
    function sv_get_header_visual($page_id){
        if(function_exists('is_bbpress')){
            if(is_bbpress()) echo do_shortcode(SV_Template::get_vc_pagecontent($page_id));
            else echo SV_Template::get_vc_pagecontent($page_id);
        }
        else echo SV_Template::get_vc_pagecontent($page_id);
    }
}
/***************************************END Theme Function***************************************/
