if (!Math.sign) {
  Math.sign = function(x) {
    // If x is NaN, the result is NaN.
    // If x is -0, the result is -0.
    // If x is +0, the result is +0.
    // If x is negative and not -0, the result is -1.
    // If x is positive and not +0, the result is +1.
    return ((x > 0) - (x < 0)) || +x;
    // A more aesthetic pseudo-representation:
    //
    // ( (x > 0) ? 1 : 0 )  // if x is positive, then positive one
    //          +           // else (because you can't be both - and +)
    // ( (x < 0) ? -1 : 0 ) // if x is negative, then negative one
    //         ||           // if x is 0, -0, or NaN, or not a number,
    //         +x           // then the result will be x, (or) if x is
    //                      // not a number, then x converts to number
  };
}
(function(e){if(typeof exports==="object"&&typeof module!=="undefined"){module.exports=e()}else if(typeof define==="function"&&define.amd){define([],e)}else{var t;if(typeof window!=="undefined"){t=window}else if(typeof global!=="undefined"){t=global}else if(typeof self!=="undefined"){t=self}else{t=this}t.algebra=e()}})(function(){var e,t,r;return function n(e,t,r){function i(o,a){if(!t[o]){if(!e[o]){var u=typeof require=="function"&&require;if(!a&&u)return u(o,!0);if(s)return s(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=t[o]={exports:{}};e[o][0].call(l.exports,function(t){var r=e[o][1][t];return i(r?r:t)},l,l.exports,n,e,t,r)}return t[o].exports}var s=typeof require=="function"&&require;for(var o=0;o<r.length;o++)i(r[o]);return i}({1:[function(e,t,r){var n=e("./src/fractions");var i=e("./src/expressions").Expression;var s=e("./src/equations");var o=e("./src/parser");var a=function(e){var t=new o;var r=t.parse(e);return r};var u=function(e){if(e instanceof n||e instanceof i||e instanceof s){return e.toTex()}else if(e instanceof Array){return e.map(function(e){if(e instanceof n){return e.toTex()}else{return e.toString()}}).join()}else{return e.toString()}};t.exports={Fraction:n,Expression:i,Equation:s,parse:a,toTex:u}},{"./src/equations":2,"./src/expressions":3,"./src/fractions":4,"./src/parser":7}],2:[function(e,t,r){var n=e("./expressions").Expression;var i=e("./expressions").Variable;var s=e("./expressions").Term;var o=e("./fractions");var a=e("./helper").isInt;var u=function(e,t){if(e instanceof n){this.lhs=e;if(t instanceof n){this.rhs=t}else if(t instanceof o||a(t)){this.rhs=new n(t)}else{throw new TypeError("Invalid Argument ("+t.toString()+"): Right-hand side must be of type Expression, Fraction or Integer.")}}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Left-hand side must be of type Expression.")}};u.prototype.solveFor=function(e){if(!this.lhs._hasVariable(e)&&!this.rhs._hasVariable(e)){throw new TypeError("Invalid Argument ("+e.toString()+"): Variable does not exist in the equation.")}if(this._isLinear()||this._variableCanBeIsolated(e)){var t=new s(new i(e));var r=new n;var a=new n;for(var u=0;u<this.rhs.terms.length;u++){var f=this.rhs.terms[u];if(f.canBeCombinedWith(t)){r=r.subtract(f)}else{a=a.add(f)}}for(var u=0;u<this.lhs.terms.length;u++){var f=this.lhs.terms[u];if(f.canBeCombinedWith(t)){r=r.add(f)}else{a=a.subtract(f)}}a=a.subtract(this.lhs.constant());a=a.add(this.rhs.constant());if(r.terms.length===0){if(r.constant().equalTo(a.constant())){return new o(1,1)}else{throw new EvalError("No Solution")}}a=a.divide(r.terms[0].coefficient());if(a.terms.length===0){return a.constant().reduce()}a._sort();return a}else{var r=this.lhs.copy();r=r.subtract(this.rhs);if(r.terms.length===0){if(r.constant().valueOf()===0){return[new o(1,1)]}else{throw new EvalError("No Solution")}}else if(this._isQuadratic(e)){var l=r._quadraticCoefficients();var c=l.a;var p=l.b;var h=l.c;var v=p.pow(2).subtract(c.multiply(h).multiply(4));if(v.valueOf()>=0){if(v.valueOf()===0){return[p.multiply(-1).divide(c.multiply(2)).reduce()]}else{var m;if(v._squareRootIsRational()){m=v.pow(.5);var d=p.multiply(-1).subtract(m).divide(c.multiply(2));var y=p.multiply(-1).add(m).divide(c.multiply(2));return[d.reduce(),y.reduce()]}else{m=Math.sqrt(v.valueOf());c=c.valueOf();p=p.valueOf();var d=(-p-m)/(2*c);var y=(-p+m)/(2*c);return[d,y]}}}else{return[]}}else if(this._isCubic(e)){var l=r._cubicCoefficients();var c=l.a;var p=l.b;var h=l.c;var g=l.d;var b=c.multiply(p).multiply(h).multiply(g).multiply(18);b=b.subtract(p.pow(3).multiply(g).multiply(4));b=b.add(p.pow(2).multiply(h.pow(2)));b=b.subtract(c.multiply(h.pow(3)).multiply(4));b=b.subtract(c.pow(2).multiply(g.pow(2)).multiply(27));var w=p.pow(2).subtract(c.multiply(h).multiply(3));if(b.valueOf()===0){if(w.valueOf()===0){var d=p.multiply(-1).divide(c.multiply(3));return[d.reduce()]}else{var d=c.multiply(p).multiply(h).multiply(4);d=d.subtract(c.pow(2).multiply(g).multiply(9));d=d.subtract(p.pow(3));d=d.divide(c.multiply(w));var y=c.multiply(g).multiply(9).subtract(p.multiply(h)).divide(w.multiply(2));return[d.reduce(),y.reduce()]}}else{var _=(3*(h/c)-Math.pow(p,2)/Math.pow(c,2))/3;var T=2*Math.pow(p,3)/Math.pow(c,3);T=T-9*p*h/Math.pow(c,2);T=T+27*g/c;T=T/27;var E=Math.pow(T,2)/4+Math.pow(_,3)/27;if(E>0){var x=-(T/2)+Math.sqrt(E);var S=Math.cbrt(x);var I=-(T/2)-Math.sqrt(E);var M=Math.cbrt(I);var d=S+M-p/(3*c);if(d<0){var R=Math.floor(d);if(d-R<1e-15)d=R}else if(d>0){var R=Math.ceil(d);if(R-d<1e-15)d=R}return[d]}else{var u=Math.sqrt(Math.pow(T,2)/4-E);var A=Math.cbrt(u);var O=Math.acos(-(T/(2*u)));var D=-A;var k=Math.cos(O/3);var P=Math.sqrt(3)*Math.sin(O/3);var V=-(p/(3*c));var d=2*A*Math.cos(O/3)-p/(3*c);var y=D*(k+P)+V;var C=D*(k-P)+V;if(d<0){var R=Math.floor(d);if(d-R<1e-15)d=R}else if(d>0){var R=Math.ceil(d);if(R-d<1e-15)d=R}if(y<0){var F=Math.floor(y);if(y-F<1e-15)y=F}else if(y>0){var F=Math.ceil(y);if(F-y<1e-15)y=F}if(d<0){var q=Math.floor(C);if(C-q<1e-15)C=q}else if(C>0){var q=Math.ceil(C);if(q-C<1e-15)C=q}var N=[d,y,C];N.sort(function(e,t){return e-t});return[N[0],N[1],N[2]]}}}}};u.prototype.eval=function(e){return new u(this.lhs.eval(e),this.rhs.eval(e))};u.prototype.toString=function(){return this.lhs.toString()+" = "+this.rhs.toString()};u.prototype.toTex=function(){return this.lhs.toTex()+" = "+this.rhs.toTex()};u.prototype._maxDegree=function(){var e=this.lhs._maxDegree();var t=this.rhs._maxDegree();return Math.max(e,t)};u.prototype._maxDegreeOfVariable=function(e){return Math.max(this.lhs._maxDegreeOfVariable(e),this.rhs._maxDegreeOfVariable(e))};u.prototype._variableCanBeIsolated=function(e){return this._maxDegreeOfVariable(e)===1&&this._noCrossProductsWithVariable(e)};u.prototype._noCrossProductsWithVariable=function(e){return this.lhs._noCrossProductsWithVariable(e)&&this.rhs._noCrossProductsWithVariable(e)};u.prototype._noCrossProducts=function(){return this.lhs._noCrossProducts()&&this.rhs._noCrossProducts()};u.prototype._onlyHasVariable=function(e){return this.lhs._onlyHasVariable(e)&&this.rhs._onlyHasVariable(e)};u.prototype._isLinear=function(){return this._maxDegree()===1&&this._noCrossProducts()};u.prototype._isQuadratic=function(e){return this._maxDegree()===2&&this._onlyHasVariable(e)};u.prototype._isCubic=function(e){return this._maxDegree()===3&&this._onlyHasVariable(e)};t.exports=u},{"./expressions":3,"./fractions":4,"./helper":5}],3:[function(e,t,r){var n=e("./fractions");var i=e("./helper").isInt;var s=e("./helper").GREEK_LETTERS;var o=function(e){this.constants=[];if(typeof e==="string"){var t=new a(e);var r=new Term(t);this.terms=[r]}else if(i(e)){this.constants=[new n(e,1)];this.terms=[]}else if(e instanceof n){this.constants=[e];this.terms=[]}else if(e instanceof Term){this.terms=[e]}else if(typeof e==="undefined"){this.terms=[]}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Argument must be of type String, Integer, Fraction or Term.")}};o.prototype.constant=function(){return this.constants.reduce(function(e,t){return e.add(t)},new n(0,1))};o.prototype.simplify=function(){var e=this.copy();e.terms=e.terms.map(function(e){return e.simplify()});e._sort();e._combineLikeTerms();e._moveTermsWithDegreeZeroToConstants();e._removeTermsWithCoefficientZero();e.constants=e.constant().valueOf()===0?[]:[e.constant()];return e};o.prototype.copy=function(){var e=new o;e.constants=this.constants.map(function(e){return e.copy()});e.terms=this.terms.map(function(e){return e.copy()});return e};o.prototype.add=function(e,t){var r=this.copy();if(typeof e==="string"||e instanceof Term||i(e)||e instanceof n){var s=new o(e);return r.add(s,t)}else if(e instanceof o){var a=e.copy().terms;r.terms=r.terms.concat(a);r.constants=r.constants.concat(e.constants);r._sort()}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Summand must be of type String, Expression, Term, Fraction or Integer.")}return t||t===undefined?r.simplify():r};o.prototype.subtract=function(e,t){var r=e instanceof o?e.multiply(-1):new o(e).multiply(-1);return this.add(r,t)};o.prototype.multiply=function(e,t){var r=this.copy();if(typeof e==="string"||e instanceof Term||i(e)||e instanceof n){var s=new o(e);return r.multiply(s,t)}else if(e instanceof o){var a=e.copy();var u=[];for(var f=0;f<r.terms.length;f++){var l=r.terms[f];for(var c=0;c<a.terms.length;c++){var p=a.terms[c];u.push(l.multiply(p,t))}for(var c=0;c<a.constants.length;c++){u.push(l.multiply(a.constants[c],t))}}for(var f=0;f<a.terms.length;f++){var p=a.terms[f];for(var c=0;c<r.constants.length;c++){u.push(p.multiply(r.constants[c],t))}}var h=[];for(var f=0;f<r.constants.length;f++){var v=r.constants[f];for(var c=0;c<a.constants.length;c++){var m=a.constants[c];var d=new Term;d=d.multiply(m,false);d=d.multiply(v,false);u.push(d)}}r.constants=h;r.terms=u;r._sort()}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Multiplicand must be of type String, Expression, Term, Fraction or Integer.")}return t||t===undefined?r.simplify():r};o.prototype.divide=function(e,t){if(e instanceof n||i(e)){if(e.valueOf()===0){throw new EvalError("Divide By Zero")}var r=this.copy();for(var s=0;s<r.terms.length;s++){var o=r.terms[s];for(var a=0;a<o.coefficients.length;a++){o.coefficients[a]=o.coefficients[a].divide(e,t)}}r.constants=r.constants.map(function(r){return r.divide(e,t)});return r}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Divisor must be of type Fraction or Integer.")}};o.prototype.pow=function(e,t){if(i(e)){var r=this.copy();if(e===0){return(new o).add(1)}else{for(var n=1;n<e;n++){r=r.multiply(this,t)}r._sort()}return t||t===undefined?r.simplify():r}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Exponent must be of type Integer.")}};o.prototype.eval=function(e,t){var r=new o;r.constants=t?[this.constant()]:this.constants.slice();r=this.terms.reduce(function(r,n){return r.add(n.eval(e,t),t)},r);return r};o.prototype.summation=function(e,t,r,n){var i=this.copy();var s=new o;for(var a=t;a<r+1;a++){var u={};u[e]=a;s=s.add(i.eval(u,n),n)}return s};o.prototype.toString=function(){var e="";for(var t=0;t<this.terms.length;t++){var r=this.terms[t];e+=(r.coefficients[0].valueOf()<0?" - ":" + ")+r.toString()}for(var t=0;t<this.constants.length;t++){var n=this.constants[t];e+=(n.valueOf()<0?" - ":" + ")+n.abs().toString()}if(e.substring(0,3)===" - "){return"-"+e.substring(3,e.length)}else if(e.substring(0,3)===" + "){return e.substring(3,e.length)}else{return"0"}};o.prototype.toTex=function(e){var t="";for(var r=0;r<this.terms.length;r++){var n=this.terms[r];t+=(n.coefficients[0].valueOf()<0?" - ":" + ")+n.toTex(e)}for(var r=0;r<this.constants.length;r++){var i=this.constants[r];t+=(i.valueOf()<0?" - ":" + ")+i.abs().toTex()}if(t.substring(0,3)===" - "){return"-"+t.substring(3,t.length)}else if(t.substring(0,3)===" + "){return t.substring(3,t.length)}else{return"0"}};o.prototype._removeTermsWithCoefficientZero=function(){this.terms=this.terms.filter(function(e){return e.coefficient().reduce().numer!==0});return this};o.prototype._combineLikeTerms=function(){function e(e,t){for(var r=0;r<t.length;r++){if(e.canBeCombinedWith(t[r])){return true}}return false}var t=[];var r=[];for(var n=0;n<this.terms.length;n++){var i=this.terms[n];if(e(i,r)){continue}else{for(var s=n+1;s<this.terms.length;s++){var o=this.terms[s];if(i.canBeCombinedWith(o)){i=i.add(o)}}t.push(i);r.push(i)}}this.terms=t;return this};o.prototype._moveTermsWithDegreeZeroToConstants=function(){var e=[];var t=new n(0,1);for(var r=0;r<this.terms.length;r++){var i=this.terms[r];if(i.variables.length===0){t=t.add(i.coefficient())}else{e.push(i)}}this.constants.push(t);this.terms=e;return this};o.prototype._sort=function(){function e(e,t){var r=e.maxDegree();var n=t.maxDegree();if(r===n){var i=e.variables.length;var s=t.variables.length;return s-i}else{return n-r}}this.terms=this.terms.sort(e);return this};o.prototype._hasVariable=function(e){for(var t=0;t<this.terms.length;t++){if(this.terms[t].hasVariable(e)){return true}}return false};o.prototype._onlyHasVariable=function(e){for(var t=0;t<this.terms.length;t++){if(!this.terms[t].onlyHasVariable(e)){return false}}return true};o.prototype._noCrossProductsWithVariable=function(e){for(var t=0;t<this.terms.length;t++){var r=this.terms[t];if(r.hasVariable(e)&&!r.onlyHasVariable(e)){return false}}return true};o.prototype._noCrossProducts=function(){for(var e=0;e<this.terms.length;e++){var t=this.terms[e];if(t.variables.length>1){return false}}return true};o.prototype._maxDegree=function(){return this.terms.reduce(function(e,t){return Math.max(e,t.maxDegree())},1)};o.prototype._maxDegreeOfVariable=function(e){return this.terms.reduce(function(t,r){return Math.max(t,r.maxDegreeOfVariable(e))},1)};o.prototype._quadraticCoefficients=function(){var e;var t=new n(0,1);for(var r=0;r<this.terms.length;r++){var i=this.terms[r];e=i.maxDegree()===2?i.coefficient().copy():e;t=i.maxDegree()===1?i.coefficient().copy():t}var s=this.constant();return{a:e,b:t,c:s}};o.prototype._cubicCoefficients=function(){var e;var t=new n(0,1);var r=new n(0,1);for(var i=0;i<this.terms.length;i++){var s=this.terms[i];e=s.maxDegree()===3?s.coefficient().copy():e;t=s.maxDegree()===2?s.coefficient().copy():t;r=s.maxDegree()===1?s.coefficient().copy():r}var o=this.constant();return{a:e,b:t,c:r,d:o}};Term=function(e){if(e instanceof a){this.variables=[e.copy()]}else if(typeof e==="undefined"){this.variables=[]}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Term initializer must be of type Variable.")}this.coefficients=[new n(1,1)]};Term.prototype.coefficient=function(){return this.coefficients.reduce(function(e,t){return e.multiply(t)},new n(1,1))};Term.prototype.simplify=function(){var e=this.copy();e.coefficients=[this.coefficient()];e.combineVars();return e.sort()};Term.prototype.combineVars=function(){var e={};for(var t=0;t<this.variables.length;t++){var r=this.variables[t];if(r.variable in e){e[r.variable]+=r.degree}else{e[r.variable]=r.degree}}var n=[];for(var i in e){var s=new a(i);s.degree=e[i];n.push(s)}this.variables=n;return this};Term.prototype.copy=function(){var e=new Term;e.coefficients=this.coefficients.map(function(e){return e.copy()});e.variables=this.variables.map(function(e){return e.copy()});return e};Term.prototype.add=function(e){if(e instanceof Term&&this.canBeCombinedWith(e)){var t=this.copy();t.coefficients=[t.coefficient().add(e.coefficient())];return t}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Summand must be of type String, Expression, Term, Fraction or Integer.")}};Term.prototype.subtract=function(e){if(e instanceof Term&&this.canBeCombinedWith(e)){var t=this.copy();t.coefficients=[t.coefficient().subtract(e.coefficient())];return t}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Subtrahend must be of type String, Expression, Term, Fraction or Integer.")}};Term.prototype.multiply=function(e,t){var r=this.copy();if(e instanceof Term){r.variables=r.variables.concat(e.variables);r.coefficients=e.coefficients.concat(r.coefficients)}else if(i(e)||e instanceof n){var s=i(e)?new n(e,1):e;if(r.variables.length===0){r.coefficients.push(s)}else{r.coefficients.unshift(s)}}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Multiplicand must be of type String, Expression, Term, Fraction or Integer.")}return t||t===undefined?r.simplify():r};Term.prototype.divide=function(e,t){if(i(e)||e instanceof n){var r=this.copy();r.coefficients=r.coefficients.map(function(r){return r.divide(e,t)});return r}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Argument must be of type Fraction or Integer.")}};Term.prototype.eval=function(e,t){var r=this.copy();var s=Object.keys(e);var a=r.coefficients.reduce(function(e,r){return e.multiply(r,t)},new o(1));for(var u=0;u<r.variables.length;u++){var f=r.variables[u];var l;if(f.variable in e){var c=e[f.variable];if(c instanceof n||c instanceof o){l=c.pow(f.degree)}else if(i(c)){l=Math.pow(c,f.degree)}else{throw new TypeError("Invalid Argument ("+c+"): Can only evaluate Expressions or Fractions.")}}else{l=new o(f.variable).pow(f.degree)}a=a.multiply(l,t)}return a};Term.prototype.hasVariable=function(e){for(var t=0;t<this.variables.length;t++){if(this.variables[t].variable===e){return true}}return false};Term.prototype.maxDegree=function(){return this.variables.reduce(function(e,t){return Math.max(e,t.degree)},1)};Term.prototype.maxDegreeOfVariable=function(e){return this.variables.reduce(function(t,r){return r.variable===e?Math.max(t,r.degree):t},1)};Term.prototype.canBeCombinedWith=function(e){var t=this.variables;var r=e.variables;if(t.length!=r.length){return false}var n=0;for(var i=0;i<t.length;i++){for(var s=0;s<r.length;s++){if(t[i].variable===r[s].variable&&t[i].degree===r[s].degree){n+=1}}}return n===t.length};Term.prototype.onlyHasVariable=function(e){for(var t=0;t<this.variables.length;t++){if(this.variables[t].variable!=e){return false}}return true};Term.prototype.sort=function(){function e(e,t){return t.degree-e.degree}this.variables=this.variables.sort(e);return this};Term.prototype.toString=function(){var e="";for(var t=0;t<this.coefficients.length;t++){var r=this.coefficients[t];if(r.abs().numer!==1||r.abs().denom!==1){e+=" * "+r.toString()}}e=this.variables.reduce(function(e,t){return e.concat(t.toString())},e);e=e.substring(0,3)===" * "?e.substring(3,e.length):e;e=e.substring(0,1)==="-"?e.substring(1,e.length):e;return e};Term.prototype.toTex=function(e){var e=e===undefined?{}:e;e.multiplication=!("multiplication"in e)?"cdot":e.multiplication;var t=" \\"+e.multiplication+" ";var r="";for(var n=0;n<this.coefficients.length;n++){var i=this.coefficients[n];if(i.abs().numer!==1||i.abs().denom!==1){r+=t+i.toTex()}}r=this.variables.reduce(function(e,t){return e.concat(t.toTex())},r);r=r.substring(0,t.length)===t?r.substring(t.length,r.length):r;r=r.substring(0,1)==="-"?r.substring(1,r.length):r;r=r.substring(0,7)==="\\frac{-"?"\\frac{"+r.substring(7,r.length):r;return r};var a=function(e){if(typeof e==="string"){this.variable=e;this.degree=1}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Variable initalizer must be of type String.")}};a.prototype.copy=function(){var e=new a(this.variable);e.degree=this.degree;return e};a.prototype.toString=function(){var e=this.degree;var t=this.variable;if(e===0){return""}else if(e===1){return t}else{return t+"^"+e}};a.prototype.toTex=function(){var e=this.degree;var t=this.variable;if(s.indexOf(t)>-1){t="\\"+t}if(e===0){return""}else if(e===1){return t}else{return t+"^{"+e+"}"}};t.exports={Expression:o,Term:Term,Variable:a}},{"./fractions":4,"./helper":5}],4:[function(e,t,r){var n=e("./helper").isInt;var i=e("./helper").gcd;var s=e("./helper").lcm;var o=function(e,t){if(t===0){throw new EvalError("Divide By Zero")}else if(n(e)&&n(t)){this.numer=e;this.denom=t}else{throw new TypeError("Invalid Argument ("+e.toString()+","+t.toString()+"): Divisor and dividend must be of type Integer.")}};o.prototype.copy=function(){return new o(this.numer,this.denom)};o.prototype.reduce=function(){var e=this.copy();var t=i(e.numer,e.denom);e.numer=e.numer/t;e.denom=e.denom/t;if(Math.sign(e.denom)==-1&&Math.sign(e.numer)==1){e.numer*=-1;e.denom*=-1}return e};o.prototype.equalTo=function(e){if(e instanceof o){var t=this.reduce();var r=e.reduce();return t.numer===r.numer&&t.denom===r.denom}else{return false}};o.prototype.add=function(e,t){t=t===undefined?true:t;var r,i;if(e instanceof o){r=e.numer;i=e.denom}else if(n(e)){r=e;i=1}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Summand must be of type Fraction or Integer.")}var a=this.copy();if(this.denom==i){a.numer+=r}else{var u=s(a.denom,i);var f=u/a.denom;var l=u/i;a.numer*=f;a.denom*=f;r*=l;a.numer+=r}return t?a.reduce():a};o.prototype.subtract=function(e,t){t=t===undefined?true:t;var r=this.copy();if(e instanceof o){return r.add(new o(-e.numer,e.denom),t)}else if(n(e)){return r.add(new o(-e,1),t)}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Subtrahend must be of type Fraction or Integer.")}};o.prototype.multiply=function(e,t){t=t===undefined?true:t;var r,i;if(e instanceof o){r=e.numer;i=e.denom}else if(n(e)&&e){r=e;i=1}else if(e===0){r=0;i=1}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Multiplicand must be of type Fraction or Integer.")}var s=this.copy();s.numer*=r;s.denom*=i;return t?s.reduce():s};o.prototype.divide=function(e,t){t=t===undefined?true:t;if(e.valueOf()===0){throw new EvalError("Divide By Zero")}var r=this.copy();if(e instanceof o){return r.multiply(new o(e.denom,e.numer),t)}else if(n(e)){return r.multiply(new o(1,e),t)}else{throw new TypeError("Invalid Argument ("+e.toString()+"): Divisor must be of type Fraction or Integer.")}};o.prototype.pow=function(e,t){t=t===undefined?true:t;var r=this.copy();r.numer=Math.pow(r.numer,e);r.denom=Math.pow(r.denom,e);return t?r.reduce():r};o.prototype.abs=function(){var e=this.copy();e.numer=Math.abs(e.numer);e.denom=Math.abs(e.denom);return e};o.prototype.valueOf=function(){return this.numer/this.denom};o.prototype.toString=function(){if(this.numer===0){return"0"}else if(this.denom===1){return this.numer.toString()}else if(this.denom===-1){return(-this.numer).toString()}else{return this.numer+"/"+this.denom}};o.prototype.toTex=function(){if(this.numer===0){return"0"}else if(this.denom===1){return this.numer.toString()}else if(this.denom===-1){return(-this.numer).toString()}else{return"\\frac{"+this.numer+"}{"+this.denom+"}"}};o.prototype._squareRootIsRational=function(){if(this.valueOf()===0){return true}var e=Math.sqrt(this.numer);var t=Math.sqrt(this.denom);return n(e)&&n(t)};o.prototype._cubeRootIsRational=function(){if(this.valueOf()===0){return true}var e=Math.cbrt(this.numer);var t=Math.cbrt(this.denom);return n(e)&&n(t)};t.exports=o},{"./helper":5}],5:[function(e,t,r){function n(e,t){while(t){var r=e;e=t;t=r%t}return e}function i(e,t){return e*t/n(e,t)}function s(e){return typeof e=="number"&&e%1===0}function o(e,t){t=typeof t==="undefined"?2:t;var r=Math.pow(10,t);return Math.round(parseFloat(e)*r)/r}var a=["alpha","beta","gamma","Gamma","delta","Delta","epsilon","varepsilon","zeta","eta","theta","vartheta","Theta","iota","kappa","lambda","Lambda","mu","nu","xi","Xi","pi","Pi","rho","varrho","sigma","Sigma","tau","upsilon","Upsilon","phi","varphi","Phi","chi","psi","Psi","omega","Omega"];r.gcd=n;r.lcm=i;r.isInt=s;r.round=o;r.GREEK_LETTERS=a},{}],6:[function(e,t,r){"use strict";var n=function(){this.pos=0;this.buf=null;this.buflen=0;this.optable={"+":"PLUS","-":"MINUS","*":"MULTIPLY","/":"DIVIDE","^":"POWER","(":"L_PAREN",")":"R_PAREN","=":"EQUALS"}};n.prototype.input=function(e){this.pos=0;this.buf=e;this.buflen=e.length};n.prototype.token=function(){this._skipnontokens();if(this.pos>=this.buflen){return null}var e=this.buf.charAt(this.pos);var t=this.optable[e];if(t!==undefined){if(t==="L_PAREN"||t==="R_PAREN"){return{type:"PAREN",value:t,pos:this.pos++}}else{return{type:"OPERATOR",value:t,pos:this.pos++}}}else{if(n._isalpha(e)){return this._process_identifier()}else if(n._isdigit(e)){return this._process_number()}else{throw new SyntaxError("Token error at character "+e+" at position "+this.pos)}}};n._isdigit=function(e){return e>="0"&&e<="9"};n._isalpha=function(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"};n._isalphanum=function(e){return e>="a"&&e<="z"||e>="A"&&e<="Z"||e>="0"&&e<="9"};n.prototype._process_digits=function(e){var t=e;while(t<this.buflen&&n._isdigit(this.buf.charAt(t))){t++}return t};n.prototype._process_number=function(){var e=this._process_digits(this.pos);if(this.buf.charAt(e)==="."){e=this._process_digits(e+1)}if(this.buf.charAt(e-1)==="."){throw new SyntaxError("Decimal point without decimal digits at position "+(e-1))}var t={type:"NUMBER",value:this.buf.substring(this.pos,e),pos:this.pos};this.pos=e;return t};n.prototype._process_identifier=function(){var e=this.pos+1;while(e<this.buflen&&n._isalphanum(this.buf.charAt(e))){e++}var t={type:"IDENTIFIER",value:this.buf.substring(this.pos,e),pos:this.pos};this.pos=e;return t};n.prototype._skipnontokens=function(){while(this.pos<this.buflen){var e=this.buf.charAt(this.pos);if(e==" "||e=="	"||e=="\r"||e=="\n"){this.pos++}else{break}}};t.exports=n},{}],7:[function(e,t,r){"use strict";var n=e("./lexer"),i=e("./expressions").Expression,s=e("./fractions"),o=e("./equations");var a=function(){this.lexer=new n;this.current_token=null};a.prototype.update=function(){this.current_token=this.lexer.token()};a.prototype.match=function(e){if(this.current_token===null)return e==="epsilon";switch(e){case"plus":return this.current_token.type==="OPERATOR"&&this.current_token.value==="PLUS";case"minus":return this.current_token.type==="OPERATOR"&&this.current_token.value==="MINUS";case"multiply":return this.current_token.type==="OPERATOR"&&this.current_token.value==="MULTIPLY";case"power":return this.current_token.type==="OPERATOR"&&this.current_token.value==="POWER";case"divide":return this.current_token.type==="OPERATOR"&&this.current_token.value==="DIVIDE";case"equal":return this.current_token.type==="OPERATOR"&&this.current_token.value==="EQUALS";case"lparen":return this.current_token.type==="PAREN"&&this.current_token.value==="L_PAREN";case"rparen":return this.current_token.type==="PAREN"&&this.current_token.value==="R_PAREN";case"num":return this.current_token.type==="NUMBER";case"id":return this.current_token.type==="IDENTIFIER";default:return false}};a.prototype.parse=function(e){this.lexer.input(e);this.update();return this.parseEqn()};a.prototype.parseEqn=function(){var e=this.parseExpr();if(this.match("equal")){this.update();var t=this.parseExpr();return new o(e,t)}else if(this.match("epsilon")){return e}else{throw new SyntaxError("Unbalanced Parenthesis")}};a.prototype.parseExpr=function(){var e=this.parseTerm();return this.parseExprRest(e)};a.prototype.parseExprRest=function(e){if(this.match("plus")){this.update();var t=this.parseTerm();if(e===undefined||t===undefined)throw new SyntaxError("Missing operand");return this.parseExprRest(e.add(t))}else if(this.match("minus")){this.update();var r=this.parseTerm();if(e===undefined){return this.parseExprRest(r.multiply(-1))}else{return this.parseExprRest(e.subtract(r))}}else{return e}};a.prototype.parseTerm=function(){var e=this.parseFactor();return this.parseTermRest(e)};a.prototype.parseTermRest=function(e){if(this.match("multiply")){this.update();var t=this.parseFactor();return e.multiply(this.parseTermRest(t))}else if(this.match("power")){this.update();var r=this.parseFactor();return this.parseTermRest(e.pow(parseInt(r.toString())))}else if(this.match("divide")){this.update();var n=this.parseFactor();return this.parseTermRest(e.divide(this.convertToFraction(n)))}else if(this.match("epsilon")){return e}else{var i=this.parseFactor();if(i===undefined){return e}else{return e.multiply(this.parseTermRest(i))}}};a.prototype.convertToFraction=function(e){if(e.terms.length>0){throw new TypeError("Invalid Argument ("+e.toString()+"): Divisor must be of type Integer or Fraction.")}else{var t=e.constants[0];return new s(t.numer,t.denom)}};a.prototype.parseFactor=function(){if(this.match("num")){var e=this.parseNumber();this.update();return e}else if(this.match("id")){var t=new i(this.current_token.value);this.update();return t}else if(this.match("lparen")){this.update();var r=this.parseExpr();if(this.match("rparen")){this.update();return r}else{throw new SyntaxError("Unbalanced Parenthesis")}}else{return undefined}};a.prototype.parseNumber=function(){if(parseInt(this.current_token.value)==this.current_token.value){return new i(parseInt(this.current_token.value))}else{var e=this.current_token.value.split(".");var t=e[1].length;var r=Math.pow(10,t);var n=parseFloat(this.current_token.value);return new i(parseInt(n*r)).divide(r)}};t.exports=a},{"./equations":2,"./expressions":3,"./fractions":4,"./lexer":6}]},{},[1])(1)});
