(function($){
    "use strict";
    $(document).ready(function() {

        /// Woocommerce Ajax
        $(".add_to_cart_button").on("click",function(e){
            e.preventDefault();
            var product_id = $(this).attr("data-product_id");
            $.ajax({
                type : "post",
                url : ajax_process.ajaxurl,
                crossDomain: true,
                data: {
                    action: "add_to_cart",
                    product_id: product_id
                },
                success: function(data){
                    var cart_content = data.fragments['div.widget_shopping_cart_content'];
                    // console.log(data.fragments['div.widget_shopping_cart_content']);
                    $('.block-cart .block-content .inner').html(cart_content);
                    var count_item = cart_content.split("<li").length;
                    $('.cart-icon .total-item').html(count_item-1);
                },
                error: function(MLHttpRequest, textStatus, errorThrown){  
                    console.log(errorThrown);  
                }
            });          
        });

        $('body').on('click', '.btn-remove', function(e){
            e.preventDefault();
            var cart_item_key = $(this).parent().attr("data-key");
            console.log(cart_item_key);
            var element = $(this).parent();
            var currency = ["د.إ","лв.","kr.","Kr.","Rs.","руб."];
            var decimal = $("#num-decimal").val();
            function get_currency(pricehtml){
                var check,index,price,i;
                for(i = 0;i<6;i++){
                    if(pricehtml.search(currency[i]) != -1)  {
                        check = true;
                        index = i;
                    }
                }
                if(check) price =  pricehtml.replace(currency[index],"");
                else price = pricehtml.replace(/[^0-9\.]+/g,"");
                return price;
            }
            $.ajax({
                type: 'POST',
                url: ajax_process.ajaxurl,                
                crossDomain: true,
                data: { 
                    action: 'product_remove',
                    cart_item_key: cart_item_key
                },
                success: function(data){
                    console.log(data);
                    var price_html = element.find('span.amount').html();
                    var price = get_currency(price_html);
                    var qty = element.find('strong').html();
                    var price_remove = price*qty;
                    var current_total_html = $(".block-cart .subtotal span.amount").html();
                    var current_total = get_currency(current_total_html);
                    var new_total = current_total-price_remove;
                    new_total = parseFloat(new_total).toFixed(decimal);
                    current_total_html = current_total_html.replace(',','');
                    var new_total_html = current_total_html.replace(current_total,new_total);
                    element.slideUp().remove();
                    // console.log(current_total);
                    // console.log(new_total);
                    // console.log(new_total_html);
                    $(".block-cart .subtotal span.amount").html(new_total_html);
                    var current_html = $('.cart-icon .total-item').html();
                    $('.cart-icon .total-item').html(current_html-1);
                },
                error: function(MLHttpRequest, textStatus, errorThrown){  
                    console.log(errorThrown);  
                }
            });
            return false;
        });

        $('body').on('click','.vt_quickview_handler', function(e){            
            $.fancybox.showLoading();
            var product_id = $(this).attr('data-product-id');
            $.ajax({
                type: 'POST',
                url: ajax_process.ajaxurl,                
                crossDomain: true,
                data: { 
                    action: 'product_popup_content',
                    product_id: product_id
                },
                success: function(res){
                    if(res[res.length-1] == '0' ){
                        res = res.split('');
                        res[res.length-1] = '';
                        res = res.join('');
                    }
                    $.fancybox.hideLoading();
                    console.log(res);
                    $.fancybox(res, {
                        fitToView: false,
                        width: 905,
                        height: 505,
                        autoSize: false,
                        openEffect: 'fade',
                        closeEffect: 'fade',
                        onStart: function(opener) { 
                            if ($(opener).attr('id') == 'login') {
                                $.get('/hicommon/authenticated', function(res) { 
                                    if ('yes' == res) {
                                      console.log('this user must have already authenticated in another browser tab, SO I want to avoid opening the fancybox.');
                                      return false;
                                    } else {
                                      console.log('the user is not authenticated');
                                      return true;
                                    }
                                }); 
                            }
                        },
                    });
                    $(".zoom_product-image").elevateZoom({tint:true, tintColour:'#F90', tintOpacity:0.5});
                    // $(".jCarouselLite").each(function(){
                    //     var num = $(this).attr('data-num');
                    //         if(num < 5) num = num;
                    //         else num = 5;
                    //     $(this).jCarouselLite({
                    //         btnNext: ".more-views .next",
                    //         btnPrev: ".more-views .prev",
                    //         visible: Number(num),
                    //         start: 0,
                    //         circular: true,
                    //         speed: 300,
                    //         vertical: true,
                    //     }); 
                    // });
                
                    $("a.click-view").on('click',function(event) {
                        event.preventDefault();
                        $(".product-image-gallery .attachment-shop_single").attr("src", $(this).attr("href"));
                        $(".product-image-gallery .attachment-shop_single").attr("data-zoom-image",$(this).attr("href"));
                        $(".zoomLens img").attr("src", $(this).attr("href"));
                        $(".zoomWindow").css("background-image",'url("'+$(this).attr("href")+'")');
                        // return true;
                    });
                    $("a[data-rel^='prettyPhoto']").prettyPhoto({
                        hook: 'data-rel',
                        social_tools: false,
                        theme: 'pp_woocommerce',
                        horizontal_padding: 20,
                        opacity: 0.8,
                        deeplinking: false
                    });
                    $(".add-to-cart").find(".plus").on("click",function(){
                        var min = $(this).prev().attr("min");
                        var max = $(this).prev().attr("max");
                        var step = $(this).prev().attr("step");
                        // console.log($(this).prev().val());
                        // console.log(max);
                        // console.log($(this).prev().val() < max);
                        if(max !==undefined && Number($(this).prev().val())< Number(max) || max === undefined){ 
                            if(step!='') $(this).prev().val(Number($(this).prev().val())+Number(step));
                        }
                    })
                    $(".add-to-cart").find(".minus").on("click",function(){
                        var min = $(this).next().attr("min");
                        var max = $(this).next().attr("max");
                        var step = $(this).next().attr("step");
                        if(min !==undefined && $(this).next().val()>min || min === undefined){
                            if(step!='') $(this).next().val(Number($(this).next().val())-Number(step));
                        }
                    })
                    $("input.qty").on("keyup change",function(){
                        var max = $(this).attr('max');
                        if( Number($(this).val()) > Number(max) ) $(this).val(max);
                    })
                },
                error: function(MLHttpRequest, textStatus, errorThrown){  
                    console.log(errorThrown);  
                }
            });
            return false;
        })
        //LOAD MORE POST
        $(".load-more-ajax").on("click",function(e){
            e.preventDefault();
            var seff = $(this);
            seff.addClass('loading');
            seff.append('<i class="fa fa-spinner fa-spin"></i>');
            var paged = seff.attr('data-currentpage');
            var type_post = seff.attr('data-type_post');
            var post_formats = seff.attr('data-postformat');
            var cats = seff.attr('data-cats');
            var order_by = seff.attr('data-order_by');
            var order = seff.attr('data-order');
            var number = seff.attr('data-number');
            var maxpage = seff.attr('data-maxpage');
            if( paged == maxpage ){
                seff.css('display','none');
            }
            // console.log(paged);
            // console.log(type_post);
            // console.log(post_formats);
            // console.log(cats);
            // console.log(order_by);
            // console.log(order);
            // console.log(maxpage);
            $.ajax({
                type : "post",
                url : ajax_process.ajaxurl,
                crossDomain: true,
                data: {
                    action: "load_more_post",
                    paged: paged,
                    type_post: type_post,
                    post_formats: post_formats,
                    cats: cats,
                    order_by: order_by,
                    order: order,
                    number: number,
                },
                success: function(data){
                    // console.log(data);
                    seff.removeClass('loading');
                    seff.find('.fa-spinner').remove();
                    seff.parent().find('.latest-news').append(data);
                    var p = parseInt(paged) + 1;
                    seff.attr("data-currentpage",p);
                    if(p == parseInt( maxpage ) ){
                        seff.css('display','none');
                    }
                },
                error: function(MLHttpRequest, textStatus, errorThrown){  
                    console.log(errorThrown);
                }
            });          
        });    
    });

})(jQuery);