<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 22/10/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_post'))
{
    function sv_vc_post($attr)
    {
        $html = $post_id = '';
        extract(shortcode_atts(array(
            'type'              => 'select',
            'post_dropdown'     => '',
            'post_text'         => '',
            'style'             => ''
        ),$attr));
        if($type == 'select'){ $post_id = $post_dropdown; }
        else{ $post_id = $post_text; }
        if(!empty($post_id)){
            $args= array(
                'post_type' => 'post',
                'post__in' => array((int)$post_id)
            );
            $data_post = '';
            $query = new WP_Query($args);
            if($query->have_posts()): while ($query->have_posts()):
                $query->the_post();                
                if($style == 'featured'){
                    switch (get_post_format(get_the_ID())) {
                        case 'video':
                            $data_post .=   '<div class="video-thumb">';
                            $data_post .=   '<a href="'.get_the_permalink().'" class="zoom-image time3s">'.get_the_post_thumbnail(get_the_ID(),array(442,240)).'</a>';
                            $data_post .=   '</div>';
                            break;
                        case 'gallery':
                            $gallery = get_post_meta(get_the_ID(), 'format_gallery', true);
                            if (!empty($gallery)){
                                $array = explode(',', $gallery);
                                if(is_array($array) && !empty($array)){
                                    
                                    $data_post .= '<div class="post-gallery product-image-banner"><div class="sv-custom-slider" data-num="1" data-speed="4000" data-itemres="1,1,1">';
                                    foreach ($array as $key => $item) {
                                        $thumbnail_url = wp_get_attachment_url($item);
                                        $data_post .='<div class="image-slider">';
                                        $data_post .= '<img src="' . esc_url($thumbnail_url) . '" alt="">';           
                                        $data_post .= '</div>';
                                    }
                                    $data_post .='</div></div>';
                                }
                            }
                            break;

                        case 'audio':
                            if (get_post_meta(get_the_ID(), 'format_media', true)) {
                                $media_url = get_post_meta(get_the_ID(), 'format_media', true);
                                $data_post .= '<div class="audio product-image-banner">' . sv_remove_w3c(wp_oembed_get($media_url, array('height' => '176'))) . '</div>';
                            }
                            break;

                        default:
                            if (has_post_thumbnail()) {
                                $data_post .= '<div class="post-thumbnail product-image-banner">
                                            <a href="'.get_the_permalink().'" class="zoom-image time3s">'.get_the_post_thumbnail(get_the_ID(),'full',array('class'=>'blog-image')).'</a>             
                                        </div>';
                            };
                            break;
                    }
                    $html .=    '<div class="content-left-menu-02">
                                    '.$data_post.'
                                    <a href="'.get_the_permalink().'" class="text-01">'.get_the_title().'</a>
                                    '.sv_meta_post_widget().'
                                </div>';
                }
                else{
                    if (has_post_thumbnail()) {
                        $data_post .= '<div class="post-thumbnail product-image-banner">
                                    <a href="'.get_the_permalink().'" class="product-image zoom-image time3s">'.get_the_post_thumbnail(get_the_ID(),array(214,214)).'</a>
                                </div>';
                    };
                    $html .=    '<div class="inner-menu-01">
                                    '.$data_post.'
                                    <a href="'.get_the_permalink().'" class="text-01">'.get_the_title().'</a>
                                    '.sv_meta_post_widget().'
                                </div>';
                }
                endwhile;
            endif;
            wp_reset_postdata();
        }
        return $html;
    }
}

stp_reg_shortcode('sv_post','sv_vc_post');

vc_map( array(
    "name"      => esc_html__("SV Post", 'theone'),
    "base"      => "sv_post",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Choose type get post ID",'theone'),
            "param_name" => "type",
            "value" => array(
                esc_html__("Select option","theone")  => 'select',
                esc_html__("Enter ID","theone")       => 'text'
                )
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Choose post ID",'theone'),
            "param_name" => "post_dropdown",
            "value" => sv_get_post_list(),
            "dependency"    => array(
                "element"   => 'type',
                "value"   => 'select'
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Enter post ID",'theone'),
            "param_name" => "post_text",
            "dependency"    => array(
                "element"   => 'type',
                "value"   => 'text'
                )
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Choose style display",'theone'),
            "param_name" => "style",
            "value" => array(
                esc_html__("Normal","theone")     => '',
                esc_html__("Featured","theone")   => 'featured'
                ),
        )
    )
));