<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 18/08/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_menu_box'))
{
    function sv_vc_menu_box($attr)
    {
        $html = '';
        extract(shortcode_atts(array(
            'button_text'       => 'menu',
            'show_account'      => 'yes',
            'account_content'   => '',
            'show_search'       => 'yes',
            'search_text'       => 'Search',
            'show_cart'         => 'yes',
        ),$attr));
        $html .='<div class="box-header-01"><div class="box-right">';        
        if($show_search == 'yes'){
        $html .=    '<div class="box-search box">
                        <span class="box-search-icon style-icon">'.esc_html__("search","theone").'</span>
                        <div class="advanced-search box-inner">
                            <div class="inner-box">
                                <span class="btn-search-mobile"></span>
                                <span class="search-lbl">'.$search_text.'</span>';
                                ob_start();
                                sv_search_product();
                                $html .= @ob_get_clean();
        $html .=            '</div>
                        </div>
                    </div>';
        }
        if($show_account == 'yes'){
            $lang_class = '';
            if(defined('ICL_LANGUAGE_CODE')) $lang_class = 'lang-active';
        $html .=    '<div class="box-account-lc box">
                        <span class="account-lc-icon style-icon">'.esc_html__("icon account","theone").'</span>
                        <div class="box-inner '.$lang_class.'">
                            <div class="inner">
                                <ul class="links '.$lang_class.'">';
                                parse_str(urldecode($account_content), $account_list);
                                foreach ($account_list as $value) {
                                    $icon_html = '';
                                    if(!empty($value['icon'])) $icon_html = '<i class="fa '.$value['icon'].'"></i>';
                                    $html .='<li><a title="'.$value['text'].'" href="'.esc_url($value['link']).'">'.$icon_html.' '.$value['text'].'</a></li>';
                                }
        $html .=                '</ul>';
        if(!empty($lang_class)){
            $html .=            '<div class="block block-language">
                                    <div class="lg-cur">
                                        <span>Language</span>
                                    </div>
                                    <ul>';
                                    $wpml_lang = icl_get_languages('skip_missing=0&orderby=custom');                               
                                    foreach ($wpml_lang as $lang) {
                                        if($lang['active']) $l_class = 'selected';
                                        else $l_class = 'no-select';
                                        $html .= '<li>
                                                    <a href="'.esc_url($lang['url']).'" class="'.$l_class.'">                    
                                                    <img alt="" src="'.esc_url($lang['country_flag_url']).'">
                                                    <span>'.$lang['native_name'].'</span>
                                                    </a>
                                                </li>';
                                    }
                                        
            $html .=                '</ul>
                                </div>';
        }
        $html .=            '</div>
                        </div>
                    </div>';
        }
        if($show_cart == 'yes' && class_exists("woocommerce")){
            global $woocommerce;            
        $html .=    '<div class="block-cart box">
                        <span class="cart-icon style-icon">
                            <a class="total-item" href="#">0</a>
                        </span>
                        <div class="block-content box-inner">
                        <input id="num-decimal" type="hidden" value="'.get_option("woocommerce_price_num_decimals").'">
                        <input id="currency" type="hidden" value=".'.get_option("woocommerce_currency").'">
                            <div class="inner">
                                <p class="block-subtitle">'.esc_html__("Recently added item(s)","theone").'</p>
                                <ol class="mini-products-list" id="cart-sidebar">';
                                $count_item = 0;                                
                                foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                    $count_item++;
                                    $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                    $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
                                    $product_quantity = woocommerce_quantity_input( array(
                                        'input_name'  => "cart[{$cart_item_key}][qty]",
                                        'input_value' => $cart_item['quantity'],
                                        'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                                        'min_value'   => '0'
                                    ), $_product, false );
                                    ob_start();
                                    $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                                    if ( ! $_product->is_visible() ) {
                                        echo balanceTags($thumbnail);
                                    } else {
                                        printf( '<a class="product-image" href="%s">%s</a>', esc_url( $_product->get_permalink( $cart_item ) ), $thumbnail );
                                    }
                                    $html .='<li class="item odd id_'.$product_id.'" data-key="'.$cart_item_key.'">
                                                '.@ob_get_clean().'
                                                '.apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                                                    '<a href="%s" class="btn-remove remove" title="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
                                                    esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
                                                    'X',
                                                    esc_attr( $product_id ),
                                                    esc_attr( $_product->get_sku() )
                                                ), $cart_item_key ).'
                                                <div class="product-details">
                                                    <p class="product-name">
                                                        <a href="'.esc_url( $_product->get_permalink( $cart_item )).'">'.$_product->get_title().'</a>                                                        
                                                    </p>
                                                    <span class="price">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ).'</span>          
                                                    <label>QTY:</label> <strong>'.$cart_item['quantity'].'</strong> 
                                                </div>
                                            </li>';
                                }
        $html .=                '</ol><input id="count-cart-item" type="hidden" value="'.$count_item.'">
                                <div class="summary">
                                    <p class="subtotal">
                                        <span class="label">'.esc_html__('Subtotal:','theone').'</span> 
                                        '.$woocommerce->cart->get_cart_total().'                                                                        
                                    </p>
                                </div>
                                <div class="actions">
                                    <div class="a-inner">
                                        <a href="'.esc_url(wc_get_cart_url()).'" class="btn-mycart">'.esc_html__('view cart','theone').'</a>
                                        <a class="btn-checkout" href="'.esc_url(wc_get_checkout_url()).'">'.esc_html__('Checkout','theone').'</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>';
        }
        $html .= '</div></div>';
        
        return $html;
    }
}

stp_reg_shortcode('sv_menu_box','sv_vc_menu_box');

vc_map( array(
    "name"      => esc_html__("SV Menu Box", 'theone'),
    "base"      => "sv_menu_box",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Show Account Icon', 'theone' ),
            'param_name' => 'show_account',
            'value' => array(
                esc_html__("Yes",'theone') => 'yes',
                esc_html__("No",'theone') => 'no'
                ), 
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Show Search Icon', 'theone' ),
            'param_name' => 'show_search',
            'value' => array(
                esc_html__("Yes",'theone') => 'yes',
                esc_html__("No",'theone') => 'no'
                ), 
        ),
        array(
            'type' => 'dropdown',
            'heading' => esc_html__( 'Show Cart Icon', 'theone' ),
            'param_name' => 'show_cart',
            'value' => array(
                esc_html__("Yes",'theone') => 'yes',
                esc_html__("No",'theone') => 'no'
                ), 
        ),        
        array(
            "type" => "add_linkicon",
            "heading" => esc_html__("Account Links",'theone'),
            "param_name" => "account_content",
        ),
    )
));