<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(class_exists("woocommerce")){
	add_action( 'wp_ajax_add_to_cart', 'sv_minicart_ajax' );
	add_action( 'wp_ajax_nopriv_add_to_cart', 'sv_minicart_ajax' );
	if(!function_exists('sv_minicart_ajax')){
		function sv_minicart_ajax() {
			
			$product_id = apply_filters( 'woocommerce_add_to_cart_product_id', absint( $_POST['product_id'] ) );
			$quantity = empty( $_POST['quantity'] ) ? 1 : apply_filters( 'woocommerce_stock_amount', $_POST['quantity'] );
			$passed_validation = apply_filters( 'woocommerce_add_to_cart_validation', true, $product_id, $quantity );

			if ( $passed_validation && WC()->cart->add_to_cart( $product_id, $quantity ) ) {
				do_action( 'woocommerce_ajax_added_to_cart', $product_id );
				WC_AJAX::get_refreshed_fragments();
			} else {
				$this->json_headers();

				// If there was an error adding to the cart, redirect to the product page to show any errors
				$data = array(
					'error' => true,
					'product_url' => apply_filters( 'woocommerce_cart_redirect_after_error', get_permalink( $product_id ), $product_id )
					);
				echo json_encode( $data );
			}
			die();
		}
	}
	/*********************************** END ADD TO CART AJAX ****************************************/

	/********************************** REMOVE ITEM MINICART AJAX ************************************/

	add_action( 'wp_ajax_product_remove', 'sv_product_remove' );
	add_action( 'wp_ajax_nopriv_product_remove', 'sv_product_remove' );
	if(!function_exists('sv_product_remove')){
		function sv_product_remove() {
		    global $wpdb, $woocommerce;
		    $cart_item_key = $_POST['cart_item_key'];
		    if ( $woocommerce->cart->get_cart_item( $cart_item_key ) ) {
				$woocommerce->cart->remove_cart_item( $cart_item_key );
			}
		    exit();
		}
	}
}
/********************************* END REMOVE ITEM MINICART AJAX *********************************/
if(class_exists( 'WooCommerce' )){
    //remove woo breadcrumbs
    add_action( 'init','_remove_wc_breadcrumbs' );

    // remove action wrap main content
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10);
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10);

    // Custom wrap main content
    add_action('woocommerce_before_main_content', '_add_before_main_content', 10);
    add_action('woocommerce_after_main_content', '_add_after_main_content', 10);

    // Remove page title
    add_filter( 'woocommerce_show_page_title', '_remove_page_title');

    // Remove Thumbnail
    remove_action( 'woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10, 2 );

    // Custom html thumbnail
    add_action('woocommerce_before_shop_loop_item_title', '_template_loop_product_thumbnail', 10, 2);

    //Custom woo shop column
    add_filter( 'loop_shop_columns', '_woo_shop_columns', 1, 10 );

    // Remove relate product
    // remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products',20);
    // remove_action( 'woocommerce_after_single_product', 'woocommerce_output_related_products',10);

    // Custom relate product
    // add_action( 'woocommerce_after_single_product_summary', '_output_related_products', 20);


    //FUNCTION
    function _remove_page_title() {
        return false;
    }

    function _add_before_main_content() {
        $sidebar = sv_get_sidebar();
		$sidebar_pos = $sidebar['position'];
		$main_class = 'col-lg-12';
		if($sidebar_pos != 'no') $main_class = 'col-lg-8 col-md-8 col-sm-12 col-xs-12';
        $col_class = 'shop-width-'.sv_get_option('woo_shop_column',4);
        ?>
        <?php sv_header_image();?>
        <div id="main-content" class="<?php echo esc_attr($col_class);?>">
            <div class="container">
				<?php if(sv_get_value_by_id('sv_show_breadrumb') == 'on'){
                    $args = array(
                            'delimiter' => ' / ',
                            'before' => '<span class="breadcrumb-title">',
                            'after' => '</span>',
                    );
                    woocommerce_breadcrumb( $args ); 
                }
                ?>
                <?php if($sidebar_pos=='left'){ get_sidebar(); }?>
                <div class="product-main box-style-3 style-top-6px <?php echo esc_attr($main_class); ?>">
        <?php
    }

    function _add_after_main_content() {
        $sidebar = sv_get_sidebar();
        $sidebar_pos=$sidebar['position'];
        ?>
                    <div class="clearfix"></div>
                </div>
                <?php if($sidebar_pos=='right'){ get_sidebar(); }?>
            </div>
        </div>
        <?php
    }

    function _remove_wc_breadcrumbs()
    {
        remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0 );
    }

    function _template_loop_product_thumbnail($content)
    {
        echo '<div class="zoom-image time3s" href="'.get_the_permalink().'">'.woocommerce_get_product_thumbnail().'</div>';
        
    }

    function _output_related_products() {
        $output = null;
        ob_start();
        woocommerce_related_products(array('posts_per_page' => 4,'columns'  => 4),true,false); 
        $content = ob_get_clean();
        if($content) { $output .= $content; }

        echo '<div class="clear"></div>' . $output;
    }

    function _woo_shop_columns( $number_columns ) {
        $col = sv_get_option('woo_shop_column',4);
        return $col;
    }
}