<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 13/08/15
 * Time: 10:20 AM
 */
global $config;
$config['theme-option'] = array(
    'sections' => array(
        array(
            'id' => 'option_general',
            'title' => '<i class="fa fa-cog"></i>'.esc_html__(' General Settings', 'theone')
        ),
        array(
            'id' => 'option_logo',
            'title' => '<i class="fa fa-image"></i>'.esc_html__(' Logo Settings', 'theone')
        ),
        array(
            'id' => 'option_menu',
            'title' => '<i class="fa fa-align-justify"></i>'.esc_html__(' Menu Settings', 'theone')
        ),
        array(
            'id' => 'option_blog',
            'title' => '<i class="fa fa-bold"></i>'.esc_html__(' Blog Settings', 'theone')
        ),
        array(
            'id' => 'option_layout',
            'title' => '<i class="fa fa-columns"></i>'.esc_html__(' Layout Settings', 'theone')
        ),
        array(
            'id' => 'option_typography',
            'title' => '<i class="fa fa-font"></i>'.esc_html__(' Typography', 'theone')
        )
    ),
    'settings' => array(
         /*----------------Begin General --------------------*/
        array(
            'id'          => 'sv_page_container',
            'label'       => esc_html__( 'Choose container width', 'theone' ),
            'desc'        => esc_html__( 'Choose container width', 'theone' ),
            'type'        => 'select',
            'section'     => 'option_general',
            'choices'     => array(
                array(
                    'label'=>esc_html__('930px','theone'),
                    'value'=>'wrap-small-container',
                ),
                array(
                    'label'=>esc_html__('1170px','theone'),
                    'value'=>'wrap-default-container'
                )
            )
        ),
        array(
            'id'          => 'sv_header_page',
            'label'       => esc_html__( 'Header Page', 'theone' ),
            'desc'        => esc_html__( 'Include page to Header', 'theone' ),
            'type'        => 'select',
            'section'     => 'option_general',
            'choices'     => sv_list_header_page()
        ),
        array(
            'id'          => 'sv_footer_page',
            'label'       => esc_html__( 'Footer Page', 'theone' ),
            'desc'        => esc_html__( 'Include page to Footer', 'theone' ),
            'type'        => 'page-select',
            'section'     => 'option_general'
        ),
        array(
            'id'          => 'sv_404_page',
            'label'       => esc_html__( '404 Page', 'theone' ),
            'desc'        => esc_html__( 'Include page to 404 page', 'theone' ),
            'type'        => 'page-select',
            'section'     => 'option_general'
        ),
        array(
            'id' => 'sv_header_show',
            'label' => esc_html__('Show Header Image', 'theone'),
            'desc' => esc_html__('This allow you to show or hide Header Image', 'theone'),
            'type' => 'on-off',
            'section' => 'option_general',
            'std' => 'on'
        ),
        array(
            'id' => 'sv_header_image',
            'label' => esc_html__('Header Image', 'theone'),
            'desc' => esc_html__('Upload header image from media.', 'theone'),
            'type' => 'upload',
            'section' => 'option_general',
            'condition'   => 'sv_header_show:is(on)',
        ),
        array(
            'id' => 'sv_header_link',
            'label' => esc_html__('Header Link', 'theone'),
            'desc' => esc_html__('Link header image.', 'theone'),
            'type' => 'text',
            'section' => 'option_general',
            'condition'   => 'sv_header_show:is(on)',
        ),
        array(
            'id' => 'sv_show_breadrumb',
            'label' => esc_html__('Show BreadCrumb', 'theone'),
            'desc' => esc_html__('This allow you to show or hide BreadCrumb', 'theone'),
            'type' => 'on-off',
            'section' => 'option_general',
            'std' => 'on'
        ),
        array(
            'id'          => 'sv_bg_breadcrumb',
            'label'       => esc_html__('Background Breadcrumb','theone'),
            'type'        => 'background',
            'section'     => 'option_general',
            'condition'   => 'sv_show_breadrumb:is(on)',
        ),
        array(
            'id'          => 'main_color',
            'label'       => esc_html__('Main color','theone'),
            'type'        => 'colorpicker',
            'section'     => 'option_general',
        ),
        array(
            'id'          => 'border_color',
            'label'       => esc_html__('Border Section color','theone'),
            'type'        => 'colorpicker',
            'section'     => 'option_general',
        ),
        array(
            'id'          => 'custom_css',
            'label'       => esc_html__('Custom CSS','theone'),
            'type'        => 'textarea-simple',
            'section'     => 'option_general',
        ),
        /*----------------End General ----------------------*/

        /*----------------Begin Logo --------------------*/
        array(
            'id' => 'logo',
            'label' => esc_html__('Logo', 'theone'),
            'desc' => esc_html__('This allow you to change logo', 'theone'),
            'type' => 'upload',
            'section' => 'option_logo',
        ),        
        array(
            'id' => 'favicon',
            'label' => esc_html__('Favicon', 'theone'),
            'desc' => esc_html__('This allow you to change favicon of your website', 'theone'),
            'type' => 'upload',
            'section' => 'option_logo'
        ),
        /*----------------End Logo ----------------------*/

        /*----------------Begin Menu --------------------*/
        array(
            'id'          => 'sv_menu_fixed',
            'label'       => esc_html__('Menu Fixed','theone'),
            'desc'        => 'Menu change to fixed when scroll',
            'type'        => 'on-off',
            'section'     => 'option_menu',
            'std'         => 'on',
        ),
        array(
            'id'          => 'sv_menu_color',
            'label'       => esc_html__('Menu style','theone'),
            'type'        => 'typography',
            'section'     => 'option_menu',
        ),
        array(
            'id'          => 'sv_menu_color_hover',
            'label'       => esc_html__('Hover color','theone'),
            'desc'        => esc_html__('Choose color','theone'),
            'type'        => 'colorpicker',
            'section'     => 'option_menu',
        ),
        array(
            'id'          => 'sv_menu_color_active',
            'label'       => esc_html__('Active color','theone'),
            'desc'        => esc_html__('Choose color','theone'),
            'type'        => 'colorpicker',
            'section'     => 'option_menu',
        ),
        /*----------------End Menu ----------------------*/
        
        /*----------------Begin Blog --------------------*/

        array(
            'id'          => 'sv_sidebar_position_blog',
            'label'       => esc_html__('Sidebar Blog','theone'),
            'type'        => 'select',
            'section'     => 'option_blog',
            'desc'=>esc_html__('Left, or Right, or Center','theone'),
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','theone'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','theone'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','theone'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_blog',
            'label'       => esc_html__('Sidebar select display in blog','theone'),
            'type'        => 'sidebar-select',
            'section'     => 'option_blog',
            'condition'   => 'sv_sidebar_position_blog:not(no)',
        ),
        array(
            'id'          => 'sv_blog_style_thumb',
            'label'       => esc_html__('Blog style thumbnail','theone'),
            'type'        => 'select',
            'section'     => 'option_blog',
            'desc'        =>esc_html__('Choose style to display','theone'),
            'choices'     => array(
                array(
                    'value'=>'small-thumb',
                    'label'=>esc_html__('Small Thumbnail','theone'),
                ),
                array(
                    'value'=>'big-thumb',
                    'label'=>esc_html__('Big Thumbnail','theone'),
                )
            )
        ),
        array(
            'id'          => 'sv_blog_col',
            'label'       => esc_html__('Blog Column','theone'),
            'type'        => 'select',
            'section'     => 'option_blog',
            'desc'        =>esc_html__('Choose style to display','theone'),
            'choices'     => array(
                array(
                    'value'=>'',
                    'label'=>esc_html__('1 Column','theone'),
                ),
                array(
                    'value'=>'blog-two-col',
                    'label'=>esc_html__('2 Column','theone'),
                )
            )
        ),

        /*----------------End Blog ----------------------*/

        /*----------------Begin Layout --------------------*/
        
        array(
            'id'          => 'sv_sidebar_position_page',
            'label'       => esc_html__('Sidebar Page','theone'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'desc'        =>esc_html__('Left, or Right, or Center','theone'),
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','theone'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','theone'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','theone'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_page',
            'label'       => esc_html__('Sidebar select display in page','theone'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_page:not(no)',
        ),
        /****end page****/
        array(
            'id'          => 'sv_sidebar_position_page_archive',
            'label'       => esc_html__('Sidebar Position on Page Archives:','theone'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'desc'=>esc_html__('Left, or Right, or Center','theone'),
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','theone'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','theone'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','theone'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_page_archive',
            'label'       => esc_html__('Sidebar select display in page Archives','theone'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_page_archive:not(no)',
        ),
        // END
        array(
            'id'          => 'sv_sidebar_position_post',
            'label'       => esc_html__('Sidebar Single Post','theone'),
            'type'        => 'select',
            'section'     => 'option_layout',
            'desc'=>esc_html__('Left, or Right, or Center','theone'),
            'choices'     => array(
                array(
                    'value'=>'no',
                    'label'=>esc_html__('No Sidebar','theone'),
                ),
                array(
                    'value'=>'left',
                    'label'=>esc_html__('Left','theone'),
                ),
                array(
                    'value'=>'right',
                    'label'=>esc_html__('Right','theone'),
                )
            )
        ),
        array(
            'id'          => 'sv_sidebar_post',
            'label'       => esc_html__('Sidebar select display in single post','theone'),
            'type'        => 'sidebar-select',
            'section'     => 'option_layout',
            'condition'   => 'sv_sidebar_position_post:not(no)',
        ),
        array(
            'id'          => 'sv_add_sidebar',
            'label'       => esc_html__('Add SideBar','theone'),
            'type'        => 'list-item',
            'section'     => 'option_layout',
            'std'         => '',
            'settings'    => array( 
                array(
                    'id'          => 'widget_title_heading',
                    'label'       => esc_html__('Choose heading title widget','theone'),
                    'type'        => 'select',
                    'std'        => 'h3',
                    'choices'     => array(
                        array(
                            'value'=>'h1',
                            'label'=>esc_html__('H1','theone'),
                        ),
                        array(
                            'value'=>'h2',
                            'label'=>esc_html__('H2','theone'),
                        ),
                        array(
                            'value'=>'h3',
                            'label'=>esc_html__('H3','theone'),
                        ),
                        array(
                            'value'=>'h4',
                            'label'=>esc_html__('H4','theone'),
                        ),
                        array(
                            'value'=>'h5',
                            'label'=>esc_html__('H5','theone'),
                        ),
                        array(
                            'value'=>'h6',
                            'label'=>esc_html__('H6','theone'),
                        ),
                    )
                ),
            ),
        ),
        /*----------------End Layout ----------------------*/

        /*----------------Begin Blog ----------------------*/       
        

        /*----------------End BLOG----------------------*/

        /*----------------Begin Typography ----------------------*/
        array(
            'id'          => 'sv_custom_typography',
            'label'       => esc_html__('Add Settings','theone'),
            'type'        => 'list-item',
            'section'     => 'option_typography',
            'std'         => '',
            'settings'    => array(
                array(
                    'id'          => 'typo_area',
                    'label'       => esc_html__('Choose Area to style','theone'),
                    'type'        => 'select',
                    'std'        => 'main',
                    'choices'     => array(
                        array(
                            'value'=>'header',
                            'label'=>esc_html__('Header','theone'),
                        ),
                        array(
                            'value'=>'main',
                            'label'=>esc_html__('Main Content','theone'),
                        ),
                        array(
                            'value'=>'widget',
                            'label'=>esc_html__('Widget','theone'),
                        ),
                        array(
                            'value'=>'footer',
                            'label'=>esc_html__('Footer','theone'),
                        ),
                    )
                ),
                array(
                    'id'          => 'typo_heading',
                    'label'       => esc_html__('Choose heading Area','theone'),
                    'type'        => 'select',
                    'std'        => 'h3',
                    'choices'     => array(
                        array(
                            'value'=>'h1',
                            'label'=>esc_html__('H1','theone'),
                        ),
                        array(
                            'value'=>'h2',
                            'label'=>esc_html__('H2','theone'),
                        ),
                        array(
                            'value'=>'h3',
                            'label'=>esc_html__('H3','theone'),
                        ),
                        array(
                            'value'=>'h4',
                            'label'=>esc_html__('H4','theone'),
                        ),
                        array(
                            'value'=>'h5',
                            'label'=>esc_html__('H5','theone'),
                        ),
                        array(
                            'value'=>'h6',
                            'label'=>esc_html__('H6','theone'),
                        ),
                        array(
                            'value'=>'a',
                            'label'=>esc_html__('a','theone'),
                        ),
                        array(
                            'value'=>'p',
                            'label'=>esc_html__('p','theone'),
                        ),
                    )
                ),
                array(
                    'id'          => 'typography_style',
                    'label'       => esc_html__('Add Style','theone'),
                    'type'        => 'typography',
                    'section'     => 'option_typography',
                ),
            ),
        ),        
        array(
            'id'          => 'google_fonts',
            'label'       => esc_html__('Add Google Fonts','theone'),
            'type'        => 'google-fonts',
            'section'     => 'option_typography',
        ),
        /*----------------End Typography ----------------------*/
    )
);
if(class_exists( 'WooCommerce' )){
    array_push($config['theme-option']['sections'], array(
                                                'id' => 'option_woo',
                                                'title' => '<i class="fa fa-shopping-cart"></i>'.esc_html__(' Shop Settings', 'theone')
                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_position_woo',
                                                'label'       => esc_html__('Sidebar Position WooCommerce page','theone'),
                                                'type'        => 'select',
                                                'section'     => 'option_woo',
                                                'desc'=>esc_html__('Left, or Right, or Center','theone'),
                                                'choices'     => array(
                                                    array(
                                                        'value'=>'no',
                                                        'label'=>esc_html__('No Sidebar','theone'),
                                                    ),
                                                    array(
                                                        'value'=>'left',
                                                        'label'=>esc_html__('Left','theone'),
                                                    ),
                                                    array(
                                                        'value'=>'right',
                                                        'label'=>esc_html__('Right','theone'),
                                                    )
                                                )
                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'sv_sidebar_woo',
                                                'label'       => esc_html__('Sidebar select WooCommerce page','theone'),
                                                'type'        => 'sidebar-select',
                                                'section'     => 'option_woo',
                                                'condition'   => 'sv_sidebar_position_woo:not(no)',
                                                'desc'        => esc_html__('Choose one style of sidebar for WooCommerce page','theone'),

                                            ));
    array_push($config['theme-option']['settings'],array(
                                                'id'          => 'woo_shop_column',
                                                'label'       => esc_html__('Choose shop column','theone'),
                                                'type'        => 'select',
                                                'section'     => 'option_woo',
                                                'choices'     => array(                                                    
                                                    array(
                                                        'value'=> 1,
                                                        'label'=> 1,
                                                    ),
                                                    array(
                                                        'value'=> 2,
                                                        'label'=> 2,
                                                    ),
                                                    array(
                                                        'value'=> 3,
                                                        'label'=> 3,
                                                    ),
                                                    array(
                                                        'value'=> 4,
                                                        'label'=> 4,
                                                    ),
                                                )
                                            ));
}