<?php
/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
  * @version 3.7.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

?>

<?php do_action( 'woocommerce_before_mini_cart' ); ?>
<p class="block-subtitle"><?php esc_html_e("Recently added item(s)","theone")?></p>
<ol id="cart-sidebar" class="mini-products-list <?php echo esc_attr($args['list_class']); ?>">

	<?php if ( ! WC()->cart->is_empty() ) : ?>

		<?php
			$count_item = 0; $html = '';
			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
            $count_item++;
            $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
            $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );
            $product_quantity = woocommerce_quantity_input( array(
                'input_name'  => "cart[{$cart_item_key}][qty]",
                'input_value' => $cart_item['quantity'],
                'max_value'   => $_product->backorders_allowed() ? '' : $_product->get_stock_quantity(),
                'min_value'   => '0'
            ), $_product, false );
            ob_start();
            $thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
            if ( ! $_product->is_visible() ) {
                echo balanceTags($thumbnail);
            } else {
                printf( '<a class="product-image" href="%s">%s</a>', esc_url( $_product->get_permalink( $cart_item ) ), $thumbnail );
            }
            $html .='<li class="item odd id_'.$product_id.'" data-key="'.$cart_item_key.'">
                        '.@ob_get_clean().'
                        '.apply_filters( 'woocommerce_cart_item_remove_link', sprintf(
                            '<a href="%s" class="btn-remove remove" title="%s" data-product_id="%s" data-product_sku="%s">&times;</a>',
                            esc_url( WC()->cart->get_remove_url( $cart_item_key ) ),
                            'X',
                            esc_attr( $product_id ),
                            esc_attr( $_product->get_sku() )
                        ), $cart_item_key ).'
                        <div class="product-details">
                            <p class="product-name">
                                <a href="'.esc_url( $_product->get_permalink( $cart_item )).'">'.$_product->get_title().'</a>                                                        
                            </p>
                            <span class="price">'.apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key ).'</span>          
                            <label>'.esc_html__("QTY:","theone").'</label> <strong>'.$cart_item['quantity'].'</strong> 
                        </div>
                    </li>';
        }
        echo balanceTags($html);
		?>

	<?php else : ?>

		<li class="empty"><?php esc_html_e( 'No products in the cart.', 'theone' ); ?></li>

	<?php endif; ?>

</ol><!-- end product list -->

<?php if ( ! WC()->cart->is_empty() ) : 

	$html_sub = '<input id="count-cart-item" type="hidden" value="'.$count_item.'">
				<div class="summary">
                    <p class="subtotal">
                        <span class="label">'.esc_html__('Subtotal:','theone').'</span> 
                        '.WC()->cart->get_cart_total().'                                                                        
                    </p>
                </div>
                <div class="actions">
                    <div class="a-inner">
                        <a href="'.wc_get_cart_url().'" class="btn-mycart">'.esc_html__('view cart','theone').'</a>
                        <a class="btn-checkout" href="'.WC()->cart->get_checkout_url().'">'.esc_html__('Checkout','theone').'</a>
                    </div>
                </div>';
    echo balanceTags($html_sub);

endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' ); ?>
