<?php
/**
 * The template for displaying all single posts.
 *
 * @package 7up-framework
 */

$sidebar=sv_get_sidebar();
$sidebar_pos=$sidebar['position'];
$main_class = 'col-lg-12';
if($sidebar_pos != 'no') $main_class = 'col-lg-10 col-md-10 col-sm-12 col-xs-12';
if(empty($sidebar_pos)) $sidebar_pos = $st_sidebar_position;
get_header();
?>
<?php sv_header_image();?>
<?php sv_display_breadcrumb();?>
    <div id="main-content" class="main-default">
        <div class="container">
            <div class="row">
                <?php if($sidebar_pos=='left'){ get_sidebar(); }?>
                <div class="page-main <?php echo esc_attr($main_class); ?>">                    
                    <?php
                    while ( have_posts() ) : the_post();

                        /*
                        * Include the post format-specific template for the content. If you want to
                        * use this in a child theme, then include a file called called content-___.php
                        * (where ___ is the post format) and that will be used instead.
                        */
                        ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                <div class="entry-content clearfix">
                                    <h2 class="df-page-title"><?php the_title()?></h2>
                                    <?php the_content(); ?>
                                    <?php
                                        wp_link_pages( array(
                                            'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'theone' ),
                                            'after'  => '</div>',
                                        ) );
                                    ?>
                                </div><!-- .entry-content -->
                            </article><!-- #post-## -->
                        <?php

                        // If comments are open or we have at least one comment, load up the comment template.
                        if ( comments_open() || get_comments_number()) :
                            comments_template();
                        endif;



                        // End the loop.
                    endwhile; ?>
                </div>
                <?php if($sidebar_pos=='right'){ get_sidebar(); }?>
            </div>

        </div>

    </div>
<?php
get_footer();
