<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */
if(!class_exists('SV_ListPostsWidget'))
{
    class SV_ListPostsWidget extends WP_Widget {


        protected $default=array();

        static function _init()
        {
            add_action( 'widgets_init', array(__CLASS__,'_add_widget') );
        }

        static function _add_widget()
        {
            register_widget( 'SV_ListPostsWidget' );
        }

        function __construct() {
            // Instantiate the parent object
            parent::__construct( false, esc_html__('List Posts','theone'),
                array( 'description' => esc_html__( 'Lists Posts', 'theone' ), ));

            $this->default=array(
                'title'=>esc_html__('List Posts','theone'),
                'posts_per_page'=>6,
                'category'=>'',
                'order'=>'desc',
                'order_by'=>'ID',
            );
        }



        function widget( $args, $instance ) {
            // Widget output
           echo balancetags($args['before_widget']);
            if ( ! empty( $instance['title'] ) ) {
               echo balancetags($args['before_title']) . apply_filters( 'widget_title', $instance['title'] ). $args['after_title'];
            }

            $instance=wp_parse_args($instance,$this->default);
            $q_args=array(
                'post_type'         => 'post',
                'posts_per_page'    => $instance['posts_per_page'],
                'orderby'           => $instance['order_by'],
                'order'             => $instance['order'],
                'paged'             => 1
            );
            if($instance['order_by'] == 'post_views'){
                $q_args['orderby'] = 'meta_value_num';
                $q_args['meta_key'] = 'post_views';
            }
            if($instance['order_by'] == '_post_like_count'){
                $q_args['orderby'] = 'meta_value_num';
                $q_args['meta_key'] = '_post_like_count';
            }
            if($instance['category']) {
                $q_args['tax_query']['relation'] = 'AND';
                $q_args['tax_query'][]=array(
                    'taxonomy'  => 'category',
                    'field'     => 'slug',
                    'terms'     => array($instance['category'])
                );
            }
            $query = new WP_Query($q_args);
            $html =    '<div class="box-content-left-02"><div class="latest-news">';
            if($query->have_posts()) {
                while($query->have_posts()) {
                    $query->the_post();
                    $terms = wp_get_post_terms( get_the_id(), 'category');
                    $term_html = '';
                    if(is_array($terms) && !empty($terms)){
                        $term_name = $terms[0]->name;
                        $term_link = get_term_link( $terms[0]->term_id, 'category' );
                        $term_html = '<a href="'.esc_url($term_link).'"><span class="post-category">'.$term_name.'</span></a>';
                    }
                    $html .=    '<div class="item">';
                    $html .=        '<a class="product-image zoom-image time3s" href="'.get_the_permalink().'">
                                        '.get_the_post_thumbnail(get_the_ID(),array(100,100)).'
                                    </a>';
                    $html .=        '<div class="infor">
                                        '.$term_html.'
                                        <h3><a href="'.get_the_permalink().'" class="text-02">'.get_the_title().'</a></h3>
                                        '.sv_meta_post_widget().'
                                    </div>';
                    $html .=    '</div>';
                }
            }
            $html .=    '</div>';
            $html .=        '<a href="#" class="see-more load-more-ajax" data-type_post="" data-postformat="" data-cats="'.$instance['category'].'" data-order_by="'.$instance['order_by'].'" data-order="'.$instance['order'].'" data-number="'.$instance['posts_per_page'].'" data-currentpage="1" data-maxpage="'.$query ->max_num_pages.'">'.esc_html__('ver más','theone').'</a>';
            $html .= '</div>';
            wp_reset_postdata();
            echo balancetags($html);
            echo balancetags($args['after_widget']);
        }

        function update( $new_instance, $old_instance ) {

            // Save widget options
            $instance=array();
            $instance=wp_parse_args($instance,$this->default);
            $new_instance=wp_parse_args($new_instance,$instance);

            return $new_instance;
        }

        function form( $instance ) {
            // Output admin widget options form

            $instance=wp_parse_args($instance,$this->default);

            extract($instance);

            ?>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php esc_html_e( 'Title:' ,'theone'); ?></label>
                <input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_attr( $title ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>"><?php esc_html_e( 'Post Number:' ,'theone'); ?></label>
                <input class="" id="<?php echo esc_attr($this->get_field_id( 'posts_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'posts_per_page' )); ?>" type="text" value="<?php echo esc_attr( $posts_per_page ); ?>">
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'order_by' )); ?>"><?php esc_html_e( 'Order By:' ,'theone'); ?></label>

                <select id="<?php echo esc_attr($this->get_field_id( 'order_by' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order_by' )); ?>">
                    <?php echo sv_get_order_list($order_by,array(),'option','style');?>
                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php esc_html_e( 'Order:' ,'theone'); ?></label>

                <select id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>">
                    <option <?php selected('asc',$order) ?> value="asc"><?php esc_html_e("ASC","theone");?></option>
                    <option <?php selected('desc',$order) ?> value="desc"><?php esc_html_e("DESC","theone");?></option>

                </select>
            </p>
            <p>
                <label for="<?php echo esc_attr($this->get_field_id( 'category' )); ?>"><?php esc_html_e( 'Category:' ,'theone'); ?></label>

                <?php wp_dropdown_categories(array(
                    'selected'=>$category,
                    'show_option_all'=>esc_html__('--- Select ---','theone'),
                    'name'  =>$this->get_field_name( 'category' ),
                    'value_field'        => 'slug',
                )); ?>
            </p>


        <?php
        }
    }

    SV_ListPostsWidget::_init();

}
