<?php
/**
 * Created by Sublime text 2.
 * User: thanhhiep992
 * Date: 15/10/15
 * Time: 10:00 AM
 */

if(!function_exists('sv_vc_letter_box'))
{
    function sv_vc_letter_box($attr , $content = false)
    {
        $html = '';
        extract(shortcode_atts(array(
            'type'       => 'custom-link',
            'mail_id'    => '',
            'title1'     => '',
            'label'      => '',
            'link'       => '',
            'image'      => '',
            'border'     => ''
        ),$attr));
        if(!empty($image)){
            $img = wp_get_attachment_image_src( $image ,"full");
        }
        $border_class = '';
        if($border == 'left'){
            $border_class = SV_Assets::build_css('border-left: 1px solid #ccc;');
        }
        if($border == 'right'){
            $border_class = SV_Assets::build_css('border-right: 1px solid #ccc;');
        }
        if($border == 'left-right'){
            $border_class = SV_Assets::build_css('border-left: 1px solid #ccc;border-right: 1px solid #ccc;');
        }
        $html .=    '<div class="box-content-right-left-09 '.$type.'">
                        <div class="tittle">
                            <span class="text-01">'.$title1.'</span>
                        </div>
                        <div class="item '.$border_class.'">
                            <div class="inner">';
        $html .=                '<div class="letter-content">'.wpb_js_remove_wpautop($content, true).'</div>';
        if($type == 'mailchimp'){
            $html .= '<div class="clearfix"></div>'.do_shortcode('[mc4wp_form id="'.$mail_id.'"]');
        }
        if(!empty($image) && $type != 'mailchimp'){
            $html .=            '<div class="product-image">
                                    <img src="'.esc_url($img[0]).'" alt="">
                                </div>';
        }
        $html .=            '</div>';
        if(!empty($link) && !empty($label) && $type != 'mailchimp'){
            $html .=        '<a href="'.esc_url($link).'" class="see-more">'.$label.'</a>';
        }
        $html .=        '</div>
                    </div>';
        
        return $html;
    }
}

stp_reg_shortcode('sv_letter_box','sv_vc_letter_box');

vc_map( array(
    "name"      => esc_html__("SV Letter Box", 'theone'),
    "base"      => "sv_letter_box",
    "icon"      => "icon-st",
    "category"  => '7Up-theme',
    "params"    => array(
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Select type",'theone'),
            "param_name" => "type",
            "value"    => array(
                esc_html__("Custom link","theone") => 'custom-link',
                esc_html__("Mailchimp form","theone") => 'mailchimp',
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Mailchimp ID",'theone'),
            "param_name" => "mail_id",
            'dependency'  => array(
                        'element'   => 'type',
                        'value'   => 'mailchimp',
                        )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Title",'theone'),
            "param_name" => "title1"
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Label Link",'theone'),
            "param_name" => "label",
            "dependency"    => array(
                "element"   => 'type',
                "value"     => 'custom-link'
                )
        ),
        array(
            "type" => "textfield",
            "heading" => esc_html__("Link Url",'theone'),
            "param_name" => "link",
            "dependency"    => array(
                "element"   => 'type',
                "value"     => 'custom-link'
                )
        ),
        array(
            "type" => "attach_image",
            "heading" => esc_html__("Upload Image",'theone'),
            "param_name" => "image"
        ),
        array(
            "type" => "textarea_html",
            "heading" => esc_html__("Content",'theone'),
            "param_name" => "content"
        ),
        array(
            "type" => "dropdown",
            "heading" => esc_html__("Border",'theone'),
            "param_name" => "border",
            "value"    => array(
                esc_html__("None","theone") => '',
                esc_html__("Left","theone") => 'left',
                esc_html__("Right","theone") => 'right',
                esc_html__("Left + Right","theone") => 'left-right',
                )
        )
    )
));