<?php
/**
 * Created by Sublime Text 2.
 * User: thanhhiep992
 * Date: 12/08/15
 * Time: 10:20 AM
 */

add_action('admin_init', 'sv_custom_meta_boxes');
if(!function_exists('sv_custom_meta_boxes')){
    function sv_custom_meta_boxes(){
        //Format content
        $format_metabox = array(
            'id' => 'block_format_content',
            'title' => esc_html__('Format Settings', 'theone'),
            'desc' => '',
            'pages' => array('post'),
            'context' => 'normal',
            'priority' => 'high',
            'fields' => array(                
                array(
                    'id' => 'format_image',
                    'label' => esc_html__('Upload Image', 'theone'),
                    'type' => 'upload',
                ),
                array(
                    'id' => 'format_gallery',
                    'label' => esc_html__('Add Gallery', 'theone'),
                    'type' => 'Gallery',
                ),
                array(
                    'id' => 'format_media',
                    'label' => esc_html__('Link Media', 'theone'),
                    'type' => 'text',
                )
            ),
        );
        // SideBar
        $sidebar_metabox_default = array(
            'id'        => 'sv_sidebar_option',
            'title'     => 'Advanced Settings',
            'desc'      => '',
            'pages'     => array( 'page','post','product'),
            'context'   => 'side',
            'priority'  => 'low',
            'fields'    => array(
                array(
                    'id'          => 'sv_sidebar_position',
                    'label'       => esc_html__('Sidebar position ','theone'),
                    'type'        => 'select',
                    'std' => '',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','theone'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('No Sidebar','theone'),
                            'value'=>'no'
                        ),
                        array(
                            'label'=>esc_html__('Left sidebar','theone'),
                            'value'=>'left'
                        ),
                        array(
                            'label'=>esc_html__('Right sidebar','theone'),
                            'value'=>'right'
                        ),
                    ),

                ),
                array(
                    'id'        =>'sv_select_sidebar',
                    'label'     =>esc_html__('Selects sidebar','theone'),
                    'type'      =>'sidebar-select',
                    'condition' => 'sv_sidebar_position:not(no),sv_sidebar_position:not()',
                ),
                array(
                    'id'          => 'sv_show_breadrumb',
                    'label'       => esc_html__('Show Breadcrumb','theone'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','theone'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('Yes','theone'),
                            'value'=>'on'
                        ),
                        array(
                            'label'=>esc_html__('No','theone'),
                            'value'=>'off'
                        )
                    )
                ),
                array(
                    'id'          => 'sv_header_show',
                    'label'       => esc_html__('Show Header Image','theone'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('--Select--','theone'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('Yes','theone'),
                            'value'=>'on'
                        ),
                        array(
                            'label'=>esc_html__('No','theone'),
                            'value'=>'off'
                        )
                    )
                ),
                array(
                    'id' => 'sv_header_image',
                    'label' => esc_html__('Header Image', 'theone'),
                    'desc' => esc_html__('Upload header image from media.', 'theone'),
                    'type' => 'upload',
                    'section' => 'option_general',
                    'condition'   => 'sv_header_show:is(on)',
                ),
                array(
                    'id' => 'sv_header_link',
                    'label' => esc_html__('Header Link', 'theone'),
                    'desc' => esc_html__('Link header image.', 'theone'),
                    'type' => 'text',
                    'section' => 'option_general',
                    'condition'   => 'sv_header_show:is(on)',
                ),
                array(
                    'id'          => 'sv_header_page',
                    'label'       => esc_html__('Choose page header','theone'),
                    'type'        => 'select',
                    'choices'     => sv_list_header_page()
                ),
                array(
                    'id'          => 'sv_footer_page',
                    'label'       => esc_html__('Choose page footer','theone'),
                    'type'        => 'page-select'
                ),
                array(
                    'id'          => 'sv_page_container',
                    'label'       => esc_html__('Choose container width','theone'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('Theme Option','theone'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('930px','theone'),
                            'value'=>'wrap-small-container',
                        ),
                        array(
                            'label'=>esc_html__('1170px','theone'),
                            'value'=>'wrap-default-container'
                        )
                    )
                )
            )
        );

        // Magazine metabox
        $blog_metabox = array(
            'id'        => 'sv_magazine_post',
            'title'     => 'Set type post',
            'pages'     => array( 'page' ),
            'context'   => 'side',
            'priority'  => 'low',
            'fields'    => array(                
                array(
                    'id'          => 'sv_blog_style_thumb',
                    'label'       => esc_html__('Blog Style Thumbnail','theone'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('Small Thumbnail','theone'),
                            'value'=>'small-thumb',
                        ),
                        array(
                            'label'=>esc_html__('Big Thumbnail','theone'),
                            'value'=>'big-thumb'
                        )
                    )
                ),
                array(
                    'id'          => 'sv_blog_col',
                    'label'       => esc_html__('Blog Column','theone'),
                    'type'        => 'select',
                    'choices'     => array(
                        array(
                            'label'=>esc_html__('1 Column','theone'),
                            'value'=>'',
                        ),
                        array(
                            'label'=>esc_html__('2 Column','theone'),
                            'value'=>'blog-two-col'
                        )
                    )
                )
            )
        );

        // Blog metabox
        $magazine_metabox = array(
            'id'        => 'sv_blog_meta',
            'title'     => 'Set type post',
            'pages'     => array( 'post' ),
            'context'   => 'side',
            'priority'  => 'high',
            'fields'    => array(
                array(
                    'id'          => 'trending_post',
                    'label'       => esc_html__('Trending Post','theone'),
                    'type'        => 'on-off',
                    'std'         => 'off'
                ),
                array(
                    'id'          => 'featured_post',
                    'label'       => esc_html__('Featured Post','theone'),
                    'type'        => 'on-off',
                    'std'         => 'off'
                ),
                array(
                    'id'          => 'time_update',
                    'label'       => esc_html__('Update in day','theone'),
                    'type'        => 'date-picker'
                )
            )
        );
        if (function_exists('ot_register_meta_box')){
            ot_register_meta_box($format_metabox);
            ot_register_meta_box($sidebar_metabox_default);
            ot_register_meta_box($magazine_metabox);
            ot_register_meta_box($blog_metabox);
        }
    }
}
?>