<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"   
xmlns:html="http://www.w3.org/TR/REC-html40"  
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
xmlns:sitemapindex="http://www.sitemaps.org/schemas/sitemap/0.9" 
xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9" 
xmlns:image="http://www.google.com/schemas/sitemap-image/1.1"
xmlns:news="http://www.google.com/schemas/sitemap-news/0.9"
>
<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes" />

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Wordpress XML Sitemap Generator Plugin</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="robots" content="index,follow" />
<style type="text/css">
   body {font-family:Tahoma, Verdana, Arial, sans-serif;font-size:1.0em; line-height:2em;}
  #header { padding:0px; margin-top:10px; margin-bottom:20px;}
  a {text-decoration:none; color:blue;}
  table {margin-bottom:50px; width:100%;}
 
  th {font-size:0.9em; padding:0.5em; text-align:left; vertical-align:bottom; background-color:#CCCCCC; }
  td {font-size:0.9em; padding:0.5em; border-bottom: solid 1px #CCCCCC; }
  div.img {float:left;clear:both; width:90%;  font-size:0.8em; vertical:top;}
  span.imgbox{width:65px; height:55px; background-color:#CCCCCC;float:left;  margin:0px 5px 5px 0px; text-align:center;vertical-align: middle; line-height:55px; color:#FFFFFF; weight:bold;}
</style>
			</head>
			<body>
				<xsl:apply-templates></xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
	
	
	

	
	<xsl:template match="sitemap:urlset">
        <h1>Wordpress XML News Sitemap</h1>

    <div id="header">
      <p>
        This is an XML News Sitemap compatible with major search engines such as Google, Bing, Baidu and Yandex.<br />
        For more information and support go to <a href="https://xmlsitemapgenerator.org/wordpress-sitemap-generator-plugin.aspx">Wordpress Sitemap Generator Plugin</a> homepage.<br />
        You can find more information about XML sitemaps on <a href="http://sitemaps.org">sitemaps.org</a>
      </p>
    </div>


    <table cellspacing="0">
        <tr>
          <th>Title / Page url</th>

          <th style="width:150px;">Publication date</th>
        </tr>
 
<xsl:for-each select="sitemap:url">
          <tr>
            <xsl:if test="position() mod 2 != 1">
              <xsl:attribute  name="class">high</xsl:attribute>
            </xsl:if>
            <td>
			<strong><xsl:value-of select="news:news/news:title"/></strong><br />
              <xsl:variable name="page">
                <xsl:value-of select="sitemap:loc"/>
              </xsl:variable>
              <a target="_blank" href="{$page}"> 
                <xsl:value-of select="sitemap:loc"/>
              </a>
			  
            </td>
            <td>
              <xsl:value-of select="news:news/news:publication_date"/>
            </td>
          </tr>
		  <xsl:if test="image:image">
		  <tr>
			<td colspan="4">
			
 				<xsl:for-each select="image:image">
				<div class="img">
              <xsl:variable name="loc">
                <xsl:value-of select="image:loc"/>
              </xsl:variable>
					<a href="{$loc}" target="_blank"><span class="imgbox">img</span></a>
					<xsl:value-of select="image:title"/><br />
					<xsl:value-of select="image:caption"/><br />
					<a href="{$loc}" target="_blank"><xsl:value-of select="image:loc"/></a>
					
				</div>	
				 </xsl:for-each>
			</td>
		  </tr>
		  </xsl:if>
        </xsl:for-each>
      </table>
	  
<div id="xsgFooter">Generated by XmlSitemapGenerator.org -
						<a href="https://xmlsitemapgenerator.org/wordpress-sitemap-generator-plugin.aspx" 
								title="WordPress XML Sitemap Generator Plugin">
								WordPress XML Sitemap Generator Plugin</a>
</div>
 
	</xsl:template>
	

 
</xsl:stylesheet>