<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"   xmlns:html="http://www.w3.org/TR/REC-html40"  
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:output method="html" version="1.0" encoding="UTF-8" indent="yes" />

<xsl:template match="/">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Wordpress XML Sitemap Generator Plugin</title>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta name="robots" content="index,follow" />
<style type="text/css">
   body {font-family:Tahoma, Verdana, Arial, sans-serif;font-size:1.0em; line-height:2em;}
  #header { padding:0px; margin-top:10px; margin-bottom:20px;}
  a {text-decoration:none; color:blue;}
  table {margin-bottom:50px;}
  tr:nth-child(odd)		{ background-color:#eeeeee; }
  th {font-size:1.0em; padding:0.5em; text-align:left; vertical-align:bottom;}
  td {font-size:1.0em; padding:0.5em;  }
</style>
			</head>
			<body>
				<xsl:apply-templates></xsl:apply-templates>
			</body>
		</html>
	</xsl:template>
	
	
	
	<xsl:template match="rss/channel">
        <h1>Wordpress RSS Sitemap</h1>

    <div id="header">
      <p>
		This is an RSS Sitemap which helps search engines find all your pages.<br />
		This is useful for feed aggregators, search engines and spiders that do not support the XML Sitemap format.<br />
        For more information and support go to <a href="https://xmlsitemapgenerator.org/wordpress-sitemap-generator-plugin.aspx">Wordpress Sitemap Generator Plugin</a> homepage. <br />
      </p>
    </div>

    <table cellspacing="0">
        <tr>
          <th>Page title / link</th>
          <th style="width:130px;">Modified date</th>
        </tr>
        <xsl:for-each select="item">
          <tr>
            <xsl:if test="position() mod 2 != 1">
              <xsl:attribute  name="class">high</xsl:attribute>
            </xsl:if>
            <td>
              <xsl:variable name="page">
                <xsl:value-of select="link"/>
              </xsl:variable>
              <a target="_blank" href="{$page}">
                <xsl:value-of select="title"/>
              </a>
            </td>
            <td>
              <xsl:value-of select="pubDate"/>
            </td>
          </tr>
        </xsl:for-each>
      </table>
	  
<div id="xsgFooter">Generated by XmlSitemapGenerator.org -
						<a href="https://xmlsitemapgenerator.org/wordpress-sitemap-generator-plugin.aspx" 
								title="WordPress XML Sitemap Generator Plugin">
								WordPress XML Sitemap Generator Plugin</a>
</div>
 
	</xsl:template>
	

 
</xsl:stylesheet>