<?php
/**
 * Plugin Name: Forms for PhpList
 * Plugin URI: https://www.vinzz.be/forms-for-phplist
 * Description: Ajax subscription forms for PhpList.
 * Version: 1.1
 * Text Domain: phpls
 * Domain Path: /languages/
 * Author: Vincent Bloemen (VinzzB)
 * Author URI: https://www.vinzz.be
 */
defined( 'ABSPATH' ) or die();
define( 'PHPLS_ROOT', plugins_url( '', __FILE__ ) );
define( 'PHPLS_SCRIPTS', PHPLS_ROOT . '/js/' );

//load dependencies
require_once ( 'includes/shortcodes.php' );

//start plugin
new PhpListSubber();
class PhpListSubber {
	function __construct() {
		if(is_admin()) {
			include_once( 'admin/init.php' );
			new PhpListSubberAdmin();
		}
		new PhpLsShortcodes();
		$this->register();
	}
	
	function register() {
		if(is_admin()) {
			register_activation_hook( __FILE__, array($this, 'activation_callback') );
		}
		add_action( 'init', array($this, 'register_post_type' ));
		add_action( 'wp_enqueue_scripts', array($this,'style_script' ));
		add_filter( "the_content", array($this,"insert_inline_script_after_post"));
		add_action( 'plugins_loaded', array($this, 'load_textdomain' ));
	}

	function insert_inline_script_after_post($content) {
		global $post;		
		if($post->post_type === 'phpls') {
			$value_ok   = wp_slash(wp_kses_post(get_post_meta($post->ID, '_phpls_translation_msg_ok', true)));
			$value_err  = wp_slash(wp_kses_post(get_post_meta($post->ID, '_phpls_translation_msg_err', true)));
			$value_wait = wp_slash(wp_kses_post(get_post_meta($post->ID, '_phpls_translation_msg_wait', true)));
			$formId 	= esc_attr(get_post_meta($post->ID, '_phpls_form_id', true));
			$validation = get_post_meta($post->ID, '_phpls_validation', true);
			if(empty($validation))
				$validation = 'return true;';

			//add custom ajax (html) messages if specified.		
			$content .= "<script> 
			window.addEventListener('load', function() {
				phpls.forms['$formId'] = { 
					messages: {
						success: '$value_ok',
						error: '$value_err',
						wait: '$value_wait'
					}, validation: function(\$input,form, action) {
						$validation
					}
				};
			});
			</script>";
		}
		return $content;
	}
	
	function style_script() {
		wp_enqueue_script('phplist-subber', PHPLS_SCRIPTS . 'phpls.js', array( 'jquery'), '0.1', true);
	}

	function load_textdomain() {
	  load_plugin_textdomain( 'phpls', false, basename( dirname( __FILE__ ) ) . '/languages' ); 
	}
	
	function activation_callback() {
		$this->register_post_type();
		flush_rewrite_rules();
	}

	function register_post_type() {
		$labels = array(
			'name'                  =>  __( 'Forms for PhpList', 'phpls' ),
			'singular_name'         =>  __( 'PhpList Form', 'phpls' ),
			//'menu_name'          	=> '',
			//'name_admin_bar'     	=> '',
			'add_new'            	=> 	__( 'Manually Create Form','phpls'), //disabled
			'add_new_item'          =>  __( 'New PhpList form (manually)', 'phpls' ), //disabled
			'all_items'             =>  __( 'All forms', 'phpls' ),
			'edit_item'             =>  __( 'Edit form', 'phpls' ),
			'new_item'              =>  __( 'Manually Create form', 'phpls' ),
			'view_item'             =>  __( 'View form', 'phpls' ),
			'search_items'       	=> 	__( 'Search forms', 'phpls'),
			//'parent_item_colon'  	=> 'Parent :',
			'not_found'             =>  __( 'No PhpList form found', 'phpls' ),
			'not_found_in_trash'    =>  __( 'No PhpList form found in Trash', 'phpls' )
		);
		$args = array(
			'label'         =>   __( 'Forms for PhpList', 'phpls' ),
			'labels'        =>   $labels,
			'description'   =>   __( 'Use PhpList subscription forms in wordpress using Ajax (CORS).', 'phpls' ),
			'public'        =>   true,
			'show_ui'		=> 	 true,
			'show_in_menu'  =>   'phpls',
			'menu_icon'     =>   'dashicons-email-alt',
			'has_archive'   =>   false,
			'rewrite'       =>   true,
			'slug'			=>	 'phpls',
			'hierarchical'	=>	 false,
			'supports'      =>   array('title', 'editor'),
			'publicly_queryable' => true,
			'capability_type' => 'post',
			'capabilities' => array(
				'create_posts' => 'do_not_allow',		
			),	
			'map_meta_cap' => true
		);	
		register_post_type( 'phpls', $args );
	}
}?>