jQuery(document).ready( function($) {
	$(this).on('submit', "form.subscribeform",phpls.submit_action);
	$(this).on('blur',"form.subscribeform input, form.subscribeform select, form.subscribeform textarea", phpls.input_blur_action);
	$(this).on('input',"form.subscribeform input, form.subscribeform select, form.subscribeform textarea", phpls.input_changed_action);
		//set initial form state
	$("form.subscribeform").each(function() {
		phpls.validate_inputs(this);
	});
});

var phpls = {	
	messages: {
		//success: "Thank you for your registration. Please check your email to confirm.", //fallback (only used on empty 200 response )
		error: 	 "Sorry, we were unable to process your subscription.",
		wait: 	 "<b>please wait...</b>",
	},
	forms: {/* placeholder messages : [ formId->messages ], validation: fnc() */},
	get_message : function(formId, msgId) {
		var msglist = phpls.forms[formId] && phpls.forms[formId].messages 
					? phpls.forms[formId].messages : phpls.messages;
		return msglist[msgId]||phpls.messages[msgId];
	},
	submit_action : function(e) {
		var $form = jQuery(this);
		var action = $form.attr('action');
		var $resdiv = jQuery("div.result",$form);
		var submitBtn = jQuery("input[type=submit]",$form);
		submitBtn[0].disabled = true;
		$resdiv.empty().append(phpls.get_message($form.attr('id'),'wait'));		
		var data = $form.serialize();
		jQuery.ajax( {
			type: 'POST',
			data: data,
			url: action,
			dataType: 'html',
			success: function (data, status, request) {
				$resdiv.empty().append(phpls.get_message($form.attr('id'),'success')||data);
				$form.trigger("reset");
			}, 
			error: function (request, status, error) { 
				$resdiv.empty().append(phpls.get_message($form.attr('id'),'error')); 
			},
			complete: function(xhr,status) {
				phpls.validate_inputs($form);
			}
		});
		return false; //do not allow default browser submit behaviour.		
	}, 
	input_blur_action : function(e) {
		var $input = jQuery(this);
		var form = $input.closest("form")[0];
		var id = $input.prop("id");
		var label =  jQuery("label[for='" + id + "']",form);
		var valid = phpls.validate_input($input, form, 'blur');
		label.css("color", valid ? "" : "red");		
	},
	input_changed_action : function(e) {
		var $input = jQuery(this);
		var form = $input.closest("form")[0];
		jQuery("div.result",form).empty();
		phpls.validate_inputs(form);			
		if($input.prop('type') == 'checkbox') {
			phpls.validate_input($input,form,'checked');
		}
	},
	validate_input : function($input, form, action) {
		var value = $input.val();
		var name = $input.prop("name");	
		var required = $input.prop("required");
		//is mail input?
		switch(name) {
			case "email":
				 var re = /^(([^<>()[\]\.,;:\s@\"]+(\.[^<>()[\]\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
				 return re.test(value);
			default:
				if(required & !value)
					return false;
				//var formid = form[0]
				if(phpls.forms[form.id] 
				//&& phpls.forms[form.id].validation 
				&& typeof phpls.forms[form.id].validation === "function") {
					return phpls.forms[form.id].validation($input,form,action);
				}
				return true;
		}			
	},
	validate_inputs : function(form) {
		var inputs = jQuery("input,select,textarea",form);
		var submitBtn = jQuery("input[type=submit]",form);
		var valid = true;
		inputs.each(function() {
			valid &= phpls.validate_input(jQuery(this), form, 'changed');
		});
		submitBtn[0].disabled = !valid;		
	}
};