<?php
defined( 'ABSPATH' ) or die();

class PhpLsAdminSettingsPage {
	
	const nonce_field = 'phpls-options';
	const nonce_action = 'phpls-options-save';
	
	function __construct() {
		$this->register();
	}
	
	public function register() {
		 add_action( 'admin_post', array( $this, 'save' ) );
	}
	
	public function save() {
        // First, validate the nonce and verify the user as permission to save.
        if ( ! ( $this->has_valid_nonce() && current_user_can( 'manage_options' ) ) ) {
            // TODO: Display an error message.
        } else {        
			update_option( 'phpls-allow_intra_urls', isset($_POST['phpls-allow_intra_urls']));
			//update_option( 'phpls-import_via_client', isset($_POST['phpls-import_via_client']));
		}
		 // if (isset($_POST['phpls-import_via_client']) && null !== wp_unslash( $_POST['phpls-import_via_client'] ) ) {
			// $ajax_import = sanitize_text_field( $_POST['phpls-import_via_client'] );
			// update_option( 'phpls-import_via_client', $ajax_import );			 
		 // }
        $this->redirect(); 		
	}
	
    private function has_valid_nonce() {
 
        // If the field isn't even in the $_POST, then it's invalid.
        if ( ! isset( $_POST[self::nonce_field] ) ) { // Input var okay.
            return false;
        }
 
        $field  = wp_unslash( $_POST[self::nonce_field] ); 
        return wp_verify_nonce( $field, self::nonce_action );
 
    }
	
	private function redirect() {
 
        // To make the Coding Standards happy, we have to initialize this.
        if ( ! isset( $_POST['_wp_http_referer'] ) ) { // Input var okay.
            $_POST['_wp_http_referer'] = wp_login_url();
        }
 
        // Sanitize the value of the $_POST collection for the Coding Standards.
        $url = sanitize_text_field(
                wp_unslash( $_POST['_wp_http_referer'] ) // Input var okay.
        );
 
        // Finally, redirect back to the admin page.
        wp_safe_redirect( urldecode( $url ) );
        exit;
 
    }
	
    public function render() {

		 	if ( !current_user_can( 'manage_options' ) )  {
				wp_die( __( 'You do not have sufficient permissions to access this page.' ) );
			}
			$intra_urls = get_option( 'phpls-allow_intra_urls', '0' );
		//	$ajax_import = get_option( 'phpls-import_via_client', '0' );
		 ?>
		<div class="wrap">
			<h1 class="wp-heading-inline"><?php echo esc_html( get_admin_page_title() ); ?></h1>
			<hr class="wp-header-end">
		</div>
		<form method="post" action="<?php echo esc_html( admin_url( 'admin-post.php' ) ); ?>">
			<table class="form-table">
				<tbody>
				<? /*
					<tr>
						<th scope="row"><? _e('Import forms using ajax (client-based)?','phpls'); ?></th>
						<td><input type="checkbox" name="phpls-import_via_client" value="1" <? echo $ajax_import ? 'checked' : ''; ?> />
							<p class="description" id="home-description">
								<? _e('Check this option if file_get_content() is unavailable on the WP server.','phpls'); ?>
							</p>
						</td>
					</tr>
					*/ ?>
					<tr>
						<th scope="row"><? _e('Allow internal urls?','phpls'); ?></th>
						<td>
							<input type="checkbox" name="phpls-allow_intra_urls" value="1" <? echo $intra_urls ? 'checked' : ''; ?> />
							<p class="description" id="home-description">
								<? _e('Allow localhost and intranet IP adresses on imports?','phpls'); ?>
							</p>
						</td>
					</tr>					
				</tbody>
			</table>
			<?php
				wp_nonce_field(self::nonce_action,self::nonce_field);
				submit_button();
			?>
		</form>
		 <?
    }
}