<?php
defined( 'ABSPATH' ) or die();

require_once  ( 'pages/settings.php' );
require_once  ( 'inc/menu.php' );
require_once  ( 'inc/notices.php' );
require_once  ( 'inc/import.php' );
require_once  ( 'inc/meta.php' );
require_once  ( 'inc/sanitize_post.php' );

class PhpListSubberAdmin {
	
	private $notices;
	private	$messages = array(
		"add_ok" 	=> array("success","Form imported succesfully!"),
		"add_cors" 	=> array("warning",'<b>Import complete but a CORS header is missing on the phplist domain! Form submissions will fail untill this issue is resolved.</b><br />Please add these two lines to the .htaccess file in the root folder of PhpList:<br /> Header always set Access-Control-Allow-Origin "%s"<br />Header always set Access-Control-Allow-Methods "POST, GET"'),
		"upd_ok"	=> array("success","Form updated succesfully!"),
		"upd_cors"	=> array("warning",'<b>Form is synced but a CORS header is missing on the phplist domain! Form submissions will fail untill this issue is resolved.</b><br />Please add these two lines to the .htaccess file in the root folder of PhpList:<br /> Header always set Access-Control-Allow-Origin "%s"<br />Header always set Access-Control-Allow-Methods "POST, GET"'),
		"err_proc" 	=> array("error","An error occured during processing!"),
		"err_url" 	=> array("error","Invalid url! Only external http(s) addresses are allowed."),
		"err_die" 	=> array("error","Access denied!")
	);	
	
	public function __construct() {
		$this->register();
		$this->notices = new PhpLsNotices();
		new PhpLsTranslationMetaBox();
	}	
	
	function register() {
		//custom columns
		add_filter( 'manage_edit-phpls_columns', array($this, 'custom_columns_head'), 10);
		add_action( 'manage_phpls_posts_custom_column', array($this, 'custom_columns_content'), 10, 2 );
		//init admin menu and hook up pages
		add_action( 'plugins_loaded', array($this, 'custom_admin_settings'));
		//post actions
		add_action( 'admin_post_import', array($this, 'import_form'));
		add_action( 'admin_post_sync', array($this, 'sync_form'));
		//inject an import form on CPT list view.
		add_filter( 'views_edit-phpls',  array($this, "custom_list_table")); 
		//add row actions on admin table
		add_filter('post_row_actions',array($this,'action_row'), 10, 2);
		//add bulk actions on admin table
		add_filter( 'bulk_actions-edit-phpls', array($this,'register_bulk_actions'));
		add_filter( 'handle_bulk_actions-edit-phpls', array($this,'bulk_action_handler'), 10, 3 );		
		add_filter( 'content_save_pre', array($this, 'filter_post_content'),10,1 );
	}
	
	function filter_post_content($data) {
		global $post;
		return empty($post) || $post->post_type != 'phpls' ? $data : (new PhpLsSanitize())->sanitize_post($data);
	}
	
	function register_bulk_actions($bulk_actions) {
		if(empty($_REQUEST['post_status']) || $_REQUEST['post_status'] !== 'trash' )
			$bulk_actions['phpls_sync'] = __( 'Synchronize', 'phpls');
		return $bulk_actions;
	}
	
	function bulk_action_handler( $redirect_to, $doaction, $post_ids ) {
		
		if ( $doaction !== 'phpls_sync' ) {
			return $redirect_to;
		}
		$msgid = 'err_die';
		$results = array();
		if(current_user_can( 'edit_posts' )) {		
		
			$msg = '';
			$msgtype = 'success';
			foreach ( $post_ids as $post_id ) {			
				$url = get_post_meta($post_id, 'phpls_url',true);
				$result = (new PhpLsImport())->update_form($post_id,$url);						
				$msg .= sprintf('<p><b>Update for Id %s:</b> %s</p>', esc_html($post_id), $this->get_message($result));
				if($result == 'upd_cors' && $msgtype !== 'error')
					$msgtype = 'warning';
				else if($result !== 'upd_ok')
					$msgtype = 'error';
			}
			$this->notices->add_flash_notice($msg, $msgtype, true);
		}		
		return $this->redirect_url();
	}
	
	
	function action_row($actions, $post){
		//check for your post type
		if ($post->post_type =="phpls" && $post->post_status !== 'trash'){
			$url = wp_nonce_url(sprintf(
					'admin-post.php?page=phpls&post=%s&action=%s&post_status=%s',
					$post->ID,'sync',
					isset($_GET['post_status']) ? $_GET['post_status'] : ''), 
				'sync-post_' . $post->ID
			);
			$actions['sync_form'] = sprintf('<a href="%s">%s</a>',$url, __('Synchronize', 'phpls'));
		}
		return $actions;
	}

	function custom_columns_head( $defaults ) {
		$defaults['phpls_shortcode'] = __( 'Shortcode', 'phpls' );
		$defaults['phpls_url'] = __( 'PhpList Subscription url', 'phpls' );
		return $defaults;
	}

	function custom_columns_content( $column_name ) {
		if ( 'phpls_url' == $column_name ) {
			global $post;
			$url = get_post_meta($post->ID, 'phpls_url',true);
			echo sprintf('<a href="%1$s" target="_blank">%1$s</a>',esc_url($url));
		} else if( 'phpls_shortcode' == $column_name) {
			global $post;
			echo sprintf('[phplist-subber id=%s]',$post->ID);
		}
	}

	function phpls_has_valid_nonce($action, $varname) {
		if ( ! isset( $_POST[$varname] ) ) { return false; }
		$field  = wp_unslash( $_POST[$varname] );
		return wp_verify_nonce( $field, $action );
	}

	function custom_admin_settings() {
		$menu = new PhpLsAdminMenu( new PhpLsAdminSettingsPage() );
		$menu->register(); 			
	}

	function import_form() {
		$msgid = 'err_die';
		//has access?
		if ($this->phpls_has_valid_nonce('phpls-settings-import', 'phpls-import-url') 
			&& current_user_can( 'edit_posts' )) {
			$url = sanitize_text_field( $_POST['phplist_sub_url'] );
			$msgid = (new PhpLsImport())->import_form($url);
		}
		$this->notices->add_flash_notice($this->get_message($msgid), $this->messages[$msgid][0], true );
		$this->redirect_to_list();
	}
	
	function sync_form() {
		$msgid = 'err_die';
		if(current_user_can( 'edit_posts' ) && !empty($_REQUEST['post'])) {
			$url = get_post_meta($_REQUEST['post'], 'phpls_url',true);
			$msgid = (new PhpLsImport())->update_form($_REQUEST['post'],$url);
		}
		$this->notices->add_flash_notice($this->get_message($msgid), $this->messages[$msgid][0], true );
		$this->redirect_to_list();
	}

	function get_message($msgid) {
		$message = __($this->messages[$msgid][1], 'phpls');
		switch($msgid) {
			case 'add_cors':
			case 'upd_cors': return sprintf($message, (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST']);			
		}
		return $message;
	}
	
	function redirect_url(){
		return admin_url(sprintf( '/edit.php?post_type=phpls&post_status=%s', esc_html((isset($_REQUEST['post_status']) ? $_REQUEST['post_status'] : ''))));
	}
	
	function redirect_to_list() {
		wp_redirect($this->redirect_url() ,301);		
	}

	function custom_list_table( $views ) {
		/* Print import form */ ?>			
		<form method="post" action="<?php echo admin_url( 'admin-post.php?page=phpls&action=import' ); ?>">
			<? wp_nonce_field( 'phpls-settings-import', 'phpls-import-url' );  ?>		
			<label for="phpls_sub_url"><? _e('Enter PhpList subscription url to import:','phpls') ?></label><br />
			<input id="phpls_sub_url" type="text" name="phplist_sub_url" style="max-width:400px; min-width:150px; width:50%"><input type="submit" name="submit" id="submit_import" class="button button-primary" value="<? _e('Import')?> ">
		</form><? 	
		return $views;
	}
}?>