<?

class PhpLsSanitize {
	
	function sanitize_post($data) {		
		return wp_kses($data, $this->allowed_html_tags_in_form());
	}
	
	function allowed_html_tags_in_form() {
		return array(
                'address'    => array(),
                'a'          => array(
                        'href'     => true,
                        'rel'      => true,
                        'rev'      => true,
                        'name'     => true,
                        'target'   => true,
                        'download' => array(
                                'valueless' => 'y',
                        ),
                ),
                'abbr'       => array(),
                'acronym'    => array(),
                'area'       => array(
                        'alt'    => true,
                        'coords' => true,
                        'href'   => true,
                        'nohref' => true,
                        'shape'  => true,
                        'target' => true,
                ),
                'article'    => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'aside'      => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'audio'      => array(
                        'autoplay' => true,
                        'controls' => true,
                        'loop'     => true,
                        'muted'    => true,
                        'preload'  => true,
                        'src'      => true,
                ),
                'b'          => array(),
                'bdo'        => array(
                        'dir' => true,
                ),
                'big'        => array(),
                'blockquote' => array(
                        'cite'     => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'br'         => array(),
                'button'     => array(
                        'disabled' => true,
                        'name'     => true,
                        'type'     => true,
                        'value'    => true,
                ),
                'caption'    => array(
                        'align' => true,
                ),
                'cite'       => array(
                        'dir'  => true,
                        'lang' => true,
                ),
                'code'       => array(),
                'col'        => array(
                        'align'   => true,
                        'char'    => true,
                        'charoff' => true,
                        'span'    => true,
                        'dir'     => true,
                        'valign'  => true,
                        'width'   => true,
                ),
                'colgroup'   => array(
                        'align'   => true,
                        'char'    => true,
                        'charoff' => true,
                        'span'    => true,
                        'valign'  => true,
                        'width'   => true,
                ),
                'del'        => array(
                        'datetime' => true,
                ),
                'dd'         => array(),
                'dfn'        => array(),
                'details'    => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'open'     => true,
                        'xml:lang' => true,
                ),
                'div'        => array(
                        'align'    => true,
						'class'    => true,
                        'dir'      => true,
                        'lang'     => true,
						'style'	   => true,
                        'xml:lang' => true,
                ),
                'dl'         => array(),
                'dt'         => array(),
                'em'         => array(),
                'fieldset'   => array(),
                'figure'     => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'figcaption' => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'font'       => array(
                        'color' => true,
                        'face'  => true,
                        'size'  => true,
                ),
                'footer'     => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
				'form' => array(
					'id' => true,
					'class' => true,
					'action' => true,
					'enctype' => true,
					'method' => true,
					'style' => true,
					'name' => true,
				),
                'h1'         => array(
                        'align' => true,
                ),
                'h2'         => array(
                        'align' => true,
                ),
                'h3'         => array(
                        'align' => true,
                ),
                'h4'         => array(
                        'align' => true,
                ),
                'h5'         => array(
                        'align' => true,
                ),
                'h6'         => array(
                        'align' => true,
                ),
                'header'     => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'hgroup'     => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'hr'         => array(
                        'align'   => true,
                        'noshade' => true,
                        'size'    => true,
                        'width'   => true,
                ),
                'i'          => array(),
				'input' 	 => array(
					'id' 		  => true,
					'class' 	  => true,
					'checked' 	  => true,
					'name' 		  => true,
					'type' 		  => true,
					'value' 	  => true,
					'required' 	  => true,
					'disabled' 	  => true,
					'style' 	  => true,
					'size' 		  => true,
					'placeholder' => true,
				),				
                'img'        => array(
                        'alt'      => true,
                        'align'    => true,
                        'border'   => true,
                        'height'   => true,
                        'hspace'   => true,
                        'longdesc' => true,
                        'vspace'   => true,
                        'src'      => true,
                        'usemap'   => true,
                        'width'    => true,
                ),
                'ins'        => array(
                        'datetime' => true,
                        'cite'     => true,
                ),
                'kbd'        => array(),
                'label'      => array(
                        'for'   => true,
						'style' => true,
						'class' => true
                ),
                'legend'     => array(
                        'align' => true,
                ),
                'li'         => array(
                        'align' => true,
                        'value' => true,
                ),
                'map'        => array(
                        'name' => true,
                ),
                'mark'       => array(),
                'menu'       => array(
                        'type' => true,
                ),
                'nav'        => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'p'          => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'pre'        => array(
                        'width' => true,
                ),
                'q'          => array(
                        'cite' => true,
                ),
                's'          => array(),
                'samp'       => array(),
                'span'       => array(
						'class'    => true,
                        'dir'      => true,
                        'align'    => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'section'    => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'small'      => array(),
                'strike'     => array(),
                'strong'     => array(),
                'sub'        => array(),
                'summary'    => array(
                        'align'    => true,
                        'dir'      => true,
                        'lang'     => true,
                        'xml:lang' => true,
                ),
                'sup'        => array(),
                'table'      => array(
                        'align'       => true,
                        'bgcolor'     => true,
                        'border'      => true,
						'class'		  => true,
                        'cellpadding' => true,
                        'cellspacing' => true,
                        'dir'         => true,
                        'rules'       => true,
                        'summary'     => true,
                        'width'       => true,
                ),
                'tbody'      => array(
                        'align'   => true,
                        'char'    => true,
                        'charoff' => true,
                        'valign'  => true,
                ),
                'td'         => array(
                        'abbr'    => true,
                        'align'   => true,
                        'axis'    => true,
                        'bgcolor' => true,
                        'char'    => true,
                        'charoff' => true,
						'class'	  => true,
                        'colspan' => true,
                        'dir'     => true,
                        'headers' => true,
                        'height'  => true,
                        'nowrap'  => true,
                        'rowspan' => true,
                        'scope'   => true,
                        'valign'  => true,
                        'width'   => true,
                ),
                'textarea'   => array(
                        'cols'     => true,
                        'rows'     => true,
                        'disabled' => true,
                        'name'     => true,
                        'readonly' => true,
                ),
                'tfoot'      => array(
                        'align'   => true,
                        'char'    => true,
                        'charoff' => true,
                        'valign'  => true,
                ),
                'th'         => array(
                        'abbr'    => true,
                        'align'   => true,
                        'axis'    => true,
                        'bgcolor' => true,
                        'char'    => true,
                        'charoff' => true,
                        'colspan' => true,
                        'headers' => true,
                        'height'  => true,
                        'nowrap'  => true,
                        'rowspan' => true,
                        'scope'   => true,
                        'valign'  => true,
                        'width'   => true,
                ),
                'thead'      => array(
                        'align'   => true,
                        'char'    => true,
                        'charoff' => true,
                        'valign'  => true,
                ),
                'title'      => array(),
                'tr'         => array(
                        'align'   => true,
                        'bgcolor' => true,
                        'char'    => true,
                        'charoff' => true,
                        'valign'  => true,
                ),
                'track'      => array(
                        'default' => true,
                        'kind'    => true,
                        'label'   => true,
                        'src'     => true,
                        'srclang' => true,
                ),
                'tt'         => array(),
                'u'          => array(),
                'ul'         => array(
                        'type' => true,
                ),
                'ol'         => array(
                        'start'    => true,
                        'type'     => true,
                        'reversed' => true,
                ),
                'var'        => array(),
                'video'      => array(
                        'autoplay' => true,
                        'controls' => true,
                        'height'   => true,
                        'loop'     => true,
                        'muted'    => true,
                        'poster'   => true,
                        'preload'  => true,
                        'src'      => true,
                        'width'    => true,
                ),
        );	
	}
} ?>