<?
defined( 'ABSPATH' ) or die();

/* Custom Meta Box: Translation */
class PhpLsTranslationMetaBox {
	
	function __construct() {
		add_action('add_meta_boxes', array($this,'add_translation_box'));	
		add_action('save_post', array($this,'save_postdata'),10,3);
	}
	
	function add_translation_box() 	{   
		add_meta_box(
			'phpls_tanslation_box_id',          // Unique ID
			__('Ajax messages and form validation', 'phpls'),  				// Box title
			array($this,'translation_box_html'),// Content callback, must be of type callable
			'phpls',                   			// Post type
			'normal', 'high' 
		);		
	}
	
	function translation_box_html($post)
	{		
		$value_ok   = get_post_meta($post->ID, '_phpls_translation_msg_ok', true);
		$value_err  = get_post_meta($post->ID, '_phpls_translation_msg_err', true);
		$value_wait = get_post_meta($post->ID, '_phpls_translation_msg_wait', true);
		$value_val   = get_post_meta($post->ID, '_phpls_validation', true);
		$htmlmsg = esc_attr('Html tage are allowed in this field', 'phpls');
		wp_nonce_field(basename(__FILE__), "phpls_translation-box-nonce");
		?><label for='phpls_translation_msg_ok'><? _e('Success message','phpls') ?> 
			<small><? _e('(Optional: This will override the ajax response from the newsletter service)','phpls') ?></small>
		</label>
		<input 	type='text' 
				style="width:100%;" 
				id='phpls_translation_msg_ok' 
				name='phpls_translation_msg_ok' 
				value='<? echo esc_attr($value_ok); ?>' 
				title='<? echo( $htmlmsg); ?>' />
		<br />
		<label for='phpls_translation_msg_err'><? _e('Failure message','phpls'); ?></label>
		<input  type='text' 
				style="width:100%;" 
				id='phpls_translation_msg_err' 
				name='phpls_translation_msg_err' 
				value='<? echo esc_attr($value_err); ?>'
				title='<? echo( $htmlmsg); ?>' >
		<br />		
		<label for='phpls_translation_msg_wait'><? _e('Wait message','phpls'); ?></label>
		<input  type='text' 
				style="width:100%;" 
				id='phpls_translation_msg_wait' 
				name='phpls_translation_msg_wait' 
				value='<? echo esc_attr($value_wait); ?>'
				title='<? echo( $htmlmsg); ?>' >
		<? if(current_user_can( 'administrator' )) { ?>
			<br />
			<label for='phpls_validation'>
				<? _e('Custom JS form validation','phpls'); ?>
				<small>
					<? _e('This function is called on every input action and on input blur.<br />function($input,form) {','phpls'); ?>
				</small>
			</label>
			<textarea rows='10'
					style="width:100%;" 
					id='phpls_validation' 
					name='phpls_validation' ><? echo esc_textarea($value_val); ?></textarea> 
			<small>};</small>
		<?php }
		/*		<textarea style="width:100%;" rows='3' id="phpls_translation_text" name="phpls_translation_text" class=""><?php echo $value; ?></textarea> */
	}

	function save_postdata($post_id, $post, $update)
	{	
		// if($post->post_type !== 'phpls')
			// return;
		// if our nonce isn't there, or we can't verify it, bail
		if (!isset($_POST["phpls_translation-box-nonce"]) 
			|| !wp_verify_nonce($_POST["phpls_translation-box-nonce"], basename(__FILE__)))
			return;
		// if our current user can't edit this post, bail
		if(!current_user_can("edit_post", $post_id))
			return ;
		// Bail if we're doing an auto save
		if(defined("DOING_AUTOSAVE") && DOING_AUTOSAVE)
			return;
		//save metadata.
		$this->update_post_html_meta($post_id,'phpls_translation_msg_ok');   //HTML IS ALLOWED 
		$this->update_post_html_meta($post_id,'phpls_translation_msg_err');  //HTML IS ALLOWED
		$this->update_post_html_meta($post_id,'phpls_translation_msg_wait'); //HTML IS ALLOWED
		if(current_user_can( 'administrator' )) {
			$this->update_post_js_meta($post_id,'phpls_validation'); //IS Javascript! (no sanitize option (needs a js parser), only esc_js?)
		}
		//extract form id (used to inject translation messages)!!!
		update_post_meta($post_id,'_phpls_form_id',$this->extract_form_id($post->post_content));		
		
	}
	
	function update_post_html_meta($post_id, $fieldname) {		
		if (array_key_exists($fieldname, $_POST)) {
			$value = wp_kses_post( $_POST[$fieldname] ); //sanitize html (as in posts)
			update_post_meta($post_id,'_' . $fieldname, $value);
		}
	}
	
	function update_post_js_meta($post_id, $fieldname) {		
		if (array_key_exists($fieldname, $_POST)) {
			$value = sanitize_textarea_field( $_POST[$fieldname] );
			update_post_meta($post_id,'_' . $fieldname, $value);
		}
	}
	
	function extract_form_id($rawhtml) {
		$dom = new DOMDocument();
		@$dom->loadHTML($rawhtml); 
		$xpath = new DOMXpath($dom);
		$xform = $xpath->query('//form[@name="subscribeform"]')->item(0);
		if(!empty($xform))
			return sanitize_key( $xform->getAttribute('id'));
		return '';
	}
}