<?
defined( 'ABSPATH' ) or die();

class PhpLsImport {
	
	private function validate_url($weburl) {
		if(empty(wp_unslash($weburl))) 
			return false;
		//sanitize url
		$url = filter_var($weburl, FILTER_SANITIZE_URL);
		//is it a valid http(s) scheme?
		$isvalid = filter_var($url, FILTER_VALIDATE_URL, FILTER_FLAG_QUERY_REQUIRED | FILTER_FLAG_SCHEME_REQUIRED) 
				&& (stripos($url, "http://") === 0 || stripos($url, "https://") === 0);
		if(!$isvalid) 
			return false;
		
		$allow_intra_urls = get_option( 'phpls-allow_intra_urls', '0' );
		if($allow_intra_urls == '1') {
			return true;
		}
		
		//strip http(s):// and www from url.
		$url = substr($url, stripos($url, "http://") === 0 ? 7 : 8);
		if(stripos($url,"www.") === 0)
			$url = substr($url,4);
		$domain = substr($url, 0, stripos($url,'/',8));
		//not localhost?
		if($domain == "localhost") 
			return false;
		//is an ip? is it within reserved or private range?
		if(ip2long($domain) && !filter_var($domain, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE))
			return false;		
		return true;
	}
	
	private function webpage_has_cors($headers) {
		return isset($headers['access-control-allow-origin'])
				&& ($headers['access-control-allow-origin'] == ('http://'  . $_SERVER['HTTP_HOST']) 
					|| $headers['access-control-allow-origin'] == ('https://' . $_SERVER['HTTP_HOST']) 
					|| $headers['access-control-allow-origin'] == '*' 
				);
	}
		
	private function extract_form($page, $subscription_id, $ajax_url){
		$dom = new DOMDocument();
		@$dom->loadHTML($page); 
		$xpath = new DOMXpath($dom);
		//remove all <script> tags
		foreach($xpath->query('//form[@name="subscribeform"]//script') as $element){
			$element->parentNode->removeChild($element);
		}
		//Get form and modify attributes.
		$xform = $xpath->query('//form[@name="subscribeform"]')->item(0);
		$xform->setAttribute('action',$ajax_url);
		$xform->setAttribute('id','phpls_form_' . esc_html($subscription_id));
		$xform->setAttribute('class','subscribeform');
		$xform->setAttribute('enctype','multipart/form-data');	
		//Add Ajax result div
		$xresult = $dom->createElement("div");
		$xresult->setAttribute("class","result");
		$xform->appendChild($xresult);
		//properly hide VerificationCodeX input field.
		$xverifycodex = $xpath->query('//form[@name="subscribeform"]//input[@name="VerificationCodeX"]')->item(0);		
		$xverifycodex->setAttribute('type','hidden');
		//modify submit button
		$xsubmit = $xpath->query('//form[@name="subscribeform"]//input[@type="submit"]')->item(0);
		$xsubmit->removeAttribute("onclick");
		$xsubmit->setAttribute('disabled','disabled');
		//get form as html string.
		return $dom->saveHtml($xform);
	}
	
	private function insert_form_to_db($subscription_id, $url, $form) {
		return wp_insert_post(array(
			'post_title' 	=> 'subscription form ' . esc_attr($subscription_id),
			'post_content' 	=> (new PhpLsSanitize())->sanitize_post($form),
			'post_type'		=> 'phpls',
			'post_author'   => get_current_user_id(),
			'meta_input'	=> array('phpls_url' => esc_url_raw($url))
		));	
	}
	private function update_form_to_db($id, $form) {		
		return wp_update_post(  $my_post = array(
			'ID'           => $id,			
			'post_content' => (new PhpLsSanitize())->sanitize_post($form),
		));
	}

	private function extract_and_prepare_form($url) {
		//convert url to ajax subscribe url. ($aurl)
		$url_parts = parse_url($url);		
		parse_str($url_parts['query'], $query);		
		$query['p'] = 'asubscribe';		
		$aurl = '//' . $url_parts['host'] . $url_parts['path'] . '?' . http_build_query($query);	
		//get contents from url.		
		$data = wp_remote_get( $url );
		//bail out if response is empty.
		if(empty($data) || empty($data['body'])) return '';		
		//check for CORS headers.
		$has_cors = $this->webpage_has_cors($data['headers']);
		//parse Html response and extract subscription form.
		$form = $this->extract_form($data['body'], $query['id'], $aurl);
		return array('has_cors' => $has_cors, 'form' => $form, 'id' => $query['id']);
	}
		
	function import_form($url) {
		//bail out if input is invalid url
		if (!$this->validate_url($url)) return err_url;
		//get form data from url
		$form = $this->extract_and_prepare_form($url);
		//bail out if form is empty.
		if(empty($form) || empty($form['form'])) return 'err_proc';	
		//insert form into db.
		$this->insert_form_to_db($form['id'], $url, $form['form']);
		//return with message
		return $form['has_cors'] ? 'add_ok' : 'add_cors';
	}	
	function update_form($id, $url) {
		//get form data from url
		$form = $this->extract_and_prepare_form($url);
		//bail out if form is empty.
		if(empty($form) || empty($form['form'])) return 'err_proc';	
		//update post in db
		$this->update_form_to_db($id,$form['form']);
		//return with message
		return $form['has_cors'] ? 'upd_ok' : 'upd_cors';		
	}
}