<div class="form-group">
    <div class="form-input">
        <div class="box-emphasis">
            <div class="form-group">
                <div class="form-input">
                    <h3>Identificación de la oferta</h3>
                </div>
            </div>
            <div class="form-group">
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Tipo de oferta', 'name' => 'oferta_tipo', 'onchange' => 'document.getElementById(\'tipo-oferta\').innerHTML = this.value; document.getElementById(\'tipo-oferta2\').innerHTML = this.value; loadTipoOfertaDesc(this.value);', 'type' => 'select', 'required' => true, 'value' => (isset($ofertaData['oferta_tipo']) ? $ofertaData['oferta_tipo'] : '')), $arr_oferta_tipo); ?>
                </div>
            </div>
            <div class="form-group">
                <div id="oferta_tipo_explicacion" class="form-input"><?php if (isset($ofertaData['oferta_tipo']) && $ofertaData['oferta_tipo'] != '') { $_REQUEST['tipo'] = $ofertaData['oferta_tipo']; require('dynamic/tipoofertadesc.php'); } ?>;</div>
            </div>
            <div class="form-group">
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Titulo de la oferta', 'name' => 'oferta_titulo', 'onchange' => 'document.getElementById(\'titulo-oferta\').innerHTML = this.value; document.getElementById(\'titulo-oferta2\').innerHTML = this.value;', 'required' => true, 'value' => (isset($ofertaData['oferta_titulo']) ? $ofertaData['oferta_titulo'] : ''))); ?><?php echo $main->ayuda_icon('PENDIENTE'); ?>
                </div>
            </div>
            <div class="form-group form-programa-entre-avanzado" style="display:none;">
                <div class="form-input">
                    <div id="accordion">
                        <h3>Dimensión 1: Justificación y denominación del programa de entrenamiento avanzado en
                            medicina</h3>
                        <div>
                            <p>La Justificación es un pilar fundamental para el planteamiento de un programa de
                                entrenamiento avanzado en medicina, su pertinencia, el soporte para su contenido
                                temático y los perfiles y competencias que se desean plantear. Para el desarrollo de
                                esta dimensión, se tendrán en cuenta los siguientes aspectos:</p>
                            <ol>
                                <li>La denominación de los programas deberá ser coherente con el contenido curricular
                                    y con los objetivos de formación.</li>
                                <li>La denominación debe reflejar el grado de especificidad y complejidad de las
                                    competencia o especialidad sobre las que le corresponde dentro del área de la
                                    medicina.</li>
                                <li>Existe un objetivo o meta esperada en la formulación del programa de entrenamiento
                                    avanzado en medicina.</li>
                                <li>Debe existir un equilibrio entre el programa de entrenamiento avanzado en medicina y
                                    la misión de la institución que lo propone.</li>
                                <li>Consideración de las necesidades de salud de la comunidad, las necesidades de la
                                    prestación de atención médica, sistema y otros aspectos de la responsabilidad
                                    social y de la investigación para la formulación del programa.</li>
                                <li>Asegurar que las actividades del programa de entrenamiento avanzado en medicina
                                    sirven para mejorar el desempeño y desarrollo profesional y personal de los
                                    médicos, el avance de la ciencia médica y de la investigación e innovación en el
                                    área de entrenamiento.</li>
                            </ol>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿Hay articulación y coherencia entre el plan de formación propuesto y la
                                    denominación del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Corresponde la denominación del programa de entrenamiento avanzado en medicina a
                                    una tradición académica reconocida en los campos nacional e internacional?</li>
                                <li>¿Son relevantes los aspectos que justifican la pertinencia del programa de
                                    entrenamiento avanzado en medicina en el marco de un contexto globalizado?</li>
                                <li>¿Hay articulación entre los argumentos presentados para demostrar la pertinencia
                                    del programa de entrenamiento avanzado en medicina y las necesidades locales y
                                    nacionales? ¿Responden las características del programa de entrenamiento avanzado
                                    en medicina a las necesidades regionales y del país?</li>
                                <li>¿Existen estudios recientes de contexto disciplinar, profesional investigativo, que
                                    permitan validar la pertinencia del programa de entrenamiento avanzado en medicina
                                    en el momento actual?</li>
                                <li>¿Demuestra el programa de entrenamiento avanzado en medicina, con claridad y
                                    coherencia, la existencia de oportunidades reales -o potenciales- de desempeño en
                                    el campo profesional en el que se inserta?</li>
                                <li>¿Son relevantes las características básicas que describe el programa de
                                    entrenamiento avanzado en medicina, permitiéndole definir su identidad o
                                    particularidad?</li>
                                <li>¿A qué elementos de la misión institucional responde la propuesta del programa de
                                    entrenamiento avanzado en medicina? ¿Contribuye el programa de entrenamiento
                                    avanzado en medicina al fortalecimiento de la misión de la institución? ¿A través
                                    de qué estrategias?</li>
                                <li>¿La institución ha realizado o realiza proyectos, eventos académicos u otro tipo
                                    de acción académica o de desarrollo relacionada con el área del programa de
                                    entrenamiento avanzado en medicina?</li>
                                <li>¿Cuáles son las áreas de formación/entrenamiento del programa de entrenamiento
                                    avanzado en medicina presentado y cómo estas se articulan con el alcance de la
                                    denominación?</li>
                                <li>¿De qué manera las competencias previstas a desarrollar en el programa de
                                    entrenamiento avanzado en medicina soportan el alcance y la especificidad de la
                                    denominación? ¿Cómo se explica la coherencia entre la denominación y el campo de
                                    conocimiento?</li>
                                <li>¿Cuáles son los soportes y argumentos que utiliza la institución para justificar
                                    la necesidad del programa de entrenamiento avanzado en medicina en el contexto
                                    local?</li>
                                <li>¿Cuáles son los soportes y argumentos que utiliza la institución para justificar
                                    la metodología y modalidad del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Plantea el programa de entrenamiento avanzado en medicina programas o actividades
                                    de formación/entrenamiento relacionadas con las tendencias dominantes del ejercicio
                                    profesional?</li>
                            </ul>
                            <strong>Información de soporte</strong>
                            <ul>
                                <li>Documento institucional o del entrenamiento avanzado en medicina en el cual se
                                    sustente que la denominación y el enfoque de formación son congruentes con la
                                    naturaleza, objetivos y área de entrenamiento o formación.</li>
                                <li>Estudios existentes (en la institución) en los que se consignen análisis
                                    realizados sobre el área de formación/entrenamiento.</li>
                                <li>Total de cursos/eventos/acciones formativas del plan de formación que desarrollan
                                    la(s) disciplina(s) relacionada(s) con la denominación del programa de
                                    entrenamiento avanzado en medicina.</li>
                                <li>Programas diseñados con base en las necesidades profesionales en el área de la
                                    salud.</li>
                                <li>Convenios (preferiblemente académicos) establecidos con
                                    instituciones/organizaciones del sector salud (locales, regionales o
                                    internacionales) y sociedades científicas relacionadas.</li>
                                <li>Presencia o existencia de programas similares a nivel local o nacional y cuál
                                    sería el aspecto diferenciador del programa propuesto.</li>
                                <li>Porcentaje de programas fundamentados en problemática investigativa en el área que
                                    actualmente está generando conocimiento de punta.</li>
                                <li>Programas cortos, prácticas o proyectos realizados, en desarrollo y planeados en
                                    relación con las condiciones particulares del entrenamiento avanzado en medicina.
                                </li>
                                <li>Correlación entre el estado actual del entrenamiento avanzado en medicina y la
                                    visión institucional propuesta.</li>
                                <li>Plan de Desarrollo institucional o Proyecto Educativo Institucional.</li>
                                <li>Documentos que expresen las necesidades a nivel regional, nacional e internacional,
                                    sobre los cuales se apoyó la institución para el diseño del entrenamiento
                                    avanzado en medicina.</li>
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 1', 'name' => 'documento_dimension_1', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                        <h3>Dimensión 2: Plan educativo</h3>
                        <div>
                            <p>Esta dimensión plantea los elementos curriculares básicos del programa de entrenamiento
                                avanzado en medicina, con la incorporación de los siguientes aspectos:</p>
                            <ol>
                                <li>Las competencias esperadas en términos de habilidades clínicas/quirúrgicas,
                                    conocimientos teóricos, actitudes y habilidades de comunicación, en relación con
                                    la
                                    organización del trabajo clínico, docencia o investigación.</li>
                                <li>El plan educativo representado en créditos académicos. La duración del mismo no
                                    excederá los 2 años.</li>
                                <li>Un plan educativo que guarde estrecha relación entre los objetivos propuestos para
                                    el
                                    programa y los resultados esperados. Su estructura compromete las áreas de
                                    conocimiento y
                                    campos de acción requeridos exclusivamente para su aplicación.</li>
                                <li>Organizar las actividades académicas y las estrategias de enseñanza-aprendizaje
                                    del
                                    programa de entrenamiento avanzado en medicina, teniendo en cuenta los resultados
                                    esperados
                                    como competencias y habilidades clínicas/quirúrgicas. Los tiempos asignados para
                                    las
                                    actividades deben ser suficientes para el logro de las competencias esperadas.</li>
                                <li>Una actividad de un programa de entrenamiento avanzado en medicina puede
                                    corresponder a:
                                    profundización en conocimientos y elaboraciones conceptuales puntuales;
                                    perfeccionamiento
                                    de habilidades y destrezas especializadas muy específicas; participación en
                                    investigaciones de alta complejidad bajo la orientación y dirección de
                                    investigadores o
                                    grupos de reconocido prestigio científico y tecnológico; perfeccionamiento en el
                                    entrenamiento para la manipulación y utilización de equipos tecnológicos de
                                    última
                                    generación.</li>
                                <li>El programa de entrenamiento avanzado en medicina requiere la elaboración de
                                    Syllabus
                                    que contengan los objetivos de aprendizaje, las competencias esperadas, los
                                    contenidos
                                    (temáticas, técnicas, procedimientos, protocolos) a tratar y los mecanismos de
                                    evaluación
                                    por los cuales será evaluado el profesional.</li>
                                <li>Se debe explicitar la metodología para el programa propuesto si es presencial o
                                    b-learning. En el caso de programas de DPP propuestos en metodología b-learning, es
                                    necesario detallar aspectos relacionados con las actividades de estudio
                                    independiente (no
                                    presencial) y las estrategias de acompañamiento tutorial a las mismas.</li>
                                <li>El oferente del programa de entrenamiento avanzado en medicina debe garantizar un
                                    escenario de práctica que desarrolle una dinámica de servicios específicos y
                                    suficientes
                                    para el entrenamiento del objeto del programa.</li>
                                <li>No podrá ser evaluado un programa o programa de entrenamiento avanzado cuando el
                                    plan de
                                    estudios, objetivos y metodología que esté contemplada en una primera o segunda
                                    especialidad.</li>
                            </ol>
                            <p><strong>Nota:</strong> Los programas de entrenamiento avanzado en medicina, tendrán una
                                duración mínima de 300 horas y la duración de este no excederá los 2 años.</p>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿El programa de entrenamiento avanzado en medicina define el plan educativo de tal
                                    forma
                                    que se muestra coherente con los objetivos de formación integral propuestos?</li>
                                <li>¿Qué competencias se privilegian en el programa de entrenamiento avanzado en
                                    medicina?
                                </li>
                                <li>¿Qué elementos permiten verificar la coherencia entre el perfil establecido para el
                                    programa de entrenamiento avanzado en medicina, las competencias y el plan
                                    educativo?,
                                    ¿ésta se articula con la justificación para la oferta del mismo?</li>
                                <li>¿Se percibe coherencia entre las competencias que se describen y los campos de
                                    ejercicio
                                    profesional en los cuales va a actuar o intervenir el profesional vinculado al
                                    mismo?
                                </li>
                                <li>¿La organización muestra en el plan educativo una agrupación u ordenamiento
                                    rígido ó
                                    flexible de los contenidos formativos?</li>
                                <li>¿La organización del plan de formación del programa de entrenamiento avanzado en
                                    medicina permite que el participante pueda fundamentar, especificar, ampliar o
                                    profundizar flexible y libremente en el énfasis propuesto?</li>
                                <li>¿Favorece la organización del plan educativo del programa de entrenamiento avanzado
                                    en
                                    medicina nuevas formas de organización del aprendizaje?</li>
                                <li>¿Se observa en el programa de entrenamiento avanzado en medicina un balance entre
                                    los
                                    conocimientos académicos y las prácticas propias de la actividad profesional?</li>
                                <li>¿Se presentan evidencias que el programa de entrenamiento avanzado en medicina tiene
                                    una
                                    tradición de trabajo institucional o regional?</li>
                                <li>¿Cuáles fueron los criterios académicos que tuvo en cuenta la institución para la
                                    definición de los créditos en el plan de formación?</li>
                                <li>Según la naturaleza del programa de entrenamiento avanzado en medicina, ¿prevé los
                                    tiempos, espacios y medios necesarios para facilitar el desarrollo de las
                                    responsabilidades propias del estudiante?</li>
                                <li>¿Es coherente el tiempo asignado al trabajo académico del participante con el
                                    conjunto
                                    de actividades de aprendizaje que se requieren para desarrollar contenidos y
                                    competencias?</li>
                                <li>¿Clasifica el programa de entrenamiento avanzado en medicina las actividades de
                                    acompañamiento directo del docente o tiempo presencial y las de tiempo
                                    independiente
                                    del participante?</li>
                                <li>¿Cuál es el número de créditos académicos del programa de entrenamiento avanzado
                                    en
                                    medicina?</li>
                                <li>¿Ha definido la institución un sistema de reconocimiento de créditos y de
                                    homologaciones de conocimientos y de experiencias?</li>
                                <li>¿Qué estrategias, medios y contextos prevé el programa de entrenamiento avanzado
                                    en
                                    medicina para el desarrollo del aprendizaje? ¿Qué estrategias permiten lograr las
                                    competencias propuestas desde el plan de formación?</li>
                                <li>¿Se explicitan las estrategias pedagógicas utilizadas en el programa de
                                    entrenamiento
                                    avanzado en medicina en los diferentes programas y actividades académicas?</li>
                                <li>¿Qué tan adecuadas se perciben las estrategias, medios (materiales y virtuales) y
                                    los
                                    contextos para garantizar el aprendizaje de los estudiantes?</li>
                                <li>¿Orientan las estrategias y mediaciones pedagógicas a que el estudiante desarrolle
                                    su
                                    curiosidad intelectual, su iniciativa, su responsabilidad y compromiso consigo
                                    mismo,
                                    así como su capacidad de trabajar en equipo?</li>
                                <li>¿Cuáles elementos del contenido general de las actividades permiten verificar
                                    coherencia con el plan de formación, las competencias propuestas y el área de
                                    conocimiento o disciplina propios del programa de entrenamiento avanzado en
                                    medicina?
                                </li>
                                <li>Para el caso de programas b-learning: ¿Qué elementos de los contenidos curriculares
                                    y
                                    qué estrategias se han desarrollado que sean propios de esta modalidad?</li>
                                <li>¿Qué escenarios coloca la Institución a disposición del programa de entrenamiento
                                    avanzado en medicina para lograr un desarrollo adecuado de los tiempos de trabajo
                                    propuestos?</li>
                                <li>¿De qué manera se prevén las prácticas formativas en cuanto al nivel de
                                    supervisión
                                    de los profesores y los escenarios apropiados para su realización? ¿Cómo se
                                    contempló
                                    la relación docencia servicio cuando amerita?</li>
                            </ul>
                            <strong>Información de soporte</strong>
                            <ul>
                                <li>Describa la relación porcentual entre las competencias y los programas
                                    desarrolladas
                                    por el plan de formación.</li>
                                <li>Número de programas de cada uno de los períodos académicos y su equivalencia en
                                    créditos, carga horaria presencial de los estudiantes en cada período, número de
                                    estudiantes por programa y por actividad.</li>
                                <li>Descripción de las actividades curriculares que tienen carácter
                                    interdisciplinario:
                                    Intensidad horaria.</li>
                                <li>Proyectos realizados en los últimos cuatro años que evidencian la tradición de
                                    trabajo interdisciplinario.</li>
                                <li>Coherencia entre las estrategias de aprendizaje utilizadas teniendo en cuenta el
                                    número
                                    de estudiantes por programa y por actividad académica.</li>
                                <li>Número de los contextos de actuación del estudiante, propios del campo de
                                    ejercicio
                                    profesional, al cual pertenece el programa de entrenamiento avanzado en medicina.
                                </li>
                                <li>Grado de disponibilidad de tiempos, espacios y medios ofrecidos a los estudiantes
                                    para
                                    desarrollar sus responsabilidades propias.</li>
                                <li>Grado de coherencia entre las estrategias y contextos de aprendizaje y el desarrollo
                                    de
                                    las competencias propuestas.</li>
                                <li>Relación entre el volumen de contenidos en los diferentes programas y las
                                    actividades
                                    académicas requeridas para desarrollar competencias y el proporcional al tiempo
                                    asignado al trabajo independiente del estudiante.</li>
                                <li>Cantidad, calidad y pertinencia del material de apoyo producido por los docentes y
                                    su
                                    correspondiente programa en los últimos dos años, que apoye el desarrollo del
                                    programa
                                </li>
                                <li>Guías cátedra de las temáticas del plan de estudios.</li>
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 2', 'name' => 'documento_dimension_2', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                        <h3>Dimensión 3: Personal académico</h3>
                        <div>
                            <p>Son considerados como personal académico aquellos actores que hacen parte dentro del
                                proceso de desarrollo del programa de entrenamiento avanzado en medicina, entiéndase
                                esto como tutores y los profesionales en formación.</p>
                            <ol>
                                <li>Involucrar a los profesionales en formación en el desarrollo de las competencias de
                                    otros profesionales, incluidos los médicos en formación, estudiantes y demás
                                    personal de salud. La colaboración con otros profesionales de la salud fomentaría
                                    el aprendizaje multidisciplinario.</li>
                                <li>El programa debe definir el perfil de ingreso y ocupacional de los participantes. Un
                                    requisito mínimo del perfil de ingreso es tener un título acreditado de
                                    profesional en Medicina.</li>
                                <li>Aunque los programas de entrenamiento avanzado en medicina son considerados
                                    programas de educación no formal, y ante la baja cantidad de cupos para participar
                                    en este tipo de programas, deben existir criterios claros para la selección de los
                                    aspirantes, garantizando la transparencia en los procesos de selección.</li>
                                <li>Los profesionales que cumplan funciones de docencia en el programa de entrenamiento
                                    avanzado en medicina, deberán contar con la formación idónea, con conocimiento y
                                    dominio del tema en el área del programa de profundización para garantizar la
                                    calidad del mismo. En tal sentido deben tener título de posgrado (especialización,
                                    maestría, doctorado) y demostrar trayectoria profesional o investigativa en el
                                    campo específico del programa a impartir.</li>
                                <li>Se establecen los mecanismos de comunicación, destinados a la orientación y
                                    verificación del desempeño de tutores durante el desarrollo de la acción
                                    formativa.</li>
                            </ol>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿Garantizan el número y la dedicación de los profesores la formación adecuada en
                                    el programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Cómo sustenta la institución la disponibilidad, idoneidad y suficiencia de
                                    profesores para atender las diferentes áreas curriculares del programa, en
                                    correspondencia con el número de estudiantes actual y/o proyectado?</li>
                                <li>¿Se han diseñado mecanismos claros y objetivos de evaluación del desempeño
                                    docente que permitan el mejoramiento de la docencia y la retroalimentación de los
                                    profesores?</li>
                                <li>¿Prevé el programa de entrenamiento avanzado en medicina el apoyo de profesores
                                    visitantes, de asesores y de expertos internacionales?</li>
                                <li>¿Tiene la institución mecanismos para valorar la calidad de los profesores?</li>
                                <li>¿Tiene la institución mecanismos claros que permitan valorar la calidad de las
                                    producciones de los profesores? . Si es así, ¿cuáles son?</li>
                                <li>¿Existen criterios claros de selección para el programa de entrenamiento avanzado?.
                                    ¿Los estudiantes cumplen el perfil de ingreso planteado por el programa?</li>
                            </ul>
                            <strong>Información de soporte</strong>
                            <ul>
                                <li>Porcentaje de docentes con respecto al total de estudiantes del programa de
                                    entrenamiento avanzado en medicina.</li>
                                <li>Porcentaje de docentes con respecto a su titulación.</li>
                                <li>Porcentaje de docentes pasantes.</li>
                                <li>Grado de correspondencia de los docentes (a nivel de titulación y experiencia) con
                                    referencia específica a las competencias del perfil que desarrollan en los
                                    programas y el programa de entrenamiento avanzado en medicina.</li>
                                <li>Porcentaje de docentes participantes en programas de capacitación y actualización.
                                </li>
                                <li>Calidad y cantidad de las publicaciones realizadas por los docentes.</li>
                                <li>Proceso de selección de participantes en el programa de entrenamiento avanzado en
                                    medicina.
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 3', 'name' => 'documento_dimension_3', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                        <h3>Dimensión 4: Evaluación y autoevaluación</h3>
                        <div>
                            <p>Las actividades de evaluación y autoevaluación permiten la valoración y medición del
                                aprendizaje y el logro de competencias por parte de los profesionales en formación. La
                                autoevaluación continua permite el desarrollo y evolución de la calidad del programa
                                de entrenamiento avanzado en medicina. Son aspectos relevantes:</p>
                            <ol>
                                <li>Establecer sistemas para monitorear y documentar la participación en las
                                    actividades del programa de entrenamiento avanzado de manera sistemática y
                                    transparente. Esto implica garantizar que la documentación de las actividades del
                                    programa reconozca el aprendizaje real y se base en la mejora de competencias, y no
                                    solo en la participación en actividades de entrenamiento avanzado.</li>
                                <li>Formular y aplicar criterios de evaluación para cada uno de los aspectos más
                                    relevantes de la actividad formativa.</li>
                                <li>Garantizar que las actividades del programa de entrenamiento avanzado en medicina
                                    cumplan con la calidad educativa generalmente acordada y esperada. Para esto el
                                    programa implementará actividades de autoevaluación que den cuenta de acciones de
                                    mejora continua para el mismo, con criterios definidos, momentos y técnicas para
                                    evaluar la satisfacción generada por la actividad formativa.</li>
                                <li>Cumplidos todos los requisitos exigidos por el programa, se otorgará una
                                    certificación que acreditará que el profesional posgraduado ha cumplido con las
                                    actividades académicas programadas.</li>
                            </ol>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿De qué manera las estrategias de evaluación de los estudiantes son coherentes con
                                    los propósitos de formación?</li>
                                <li>¿De qué manera se prevé desarrollar la autoevaluación del programa de
                                    entrenamiento avanzado en medicina?</li>
                                <li>¿Con qué periodicidad se realizan las prácticas de autoevaluación en el programa
                                    de entrenamiento avanzado en medicina?</li>
                                <li>¿Existe en la institución una cultura de mejora continua?</li>
                                <li>¿Permite la autoevaluación obtener información clara, objetiva y confiable sobre
                                    el estado del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿El programa considera la realización de evaluaciones y seguimientos al plan
                                    educativo con frecuencia? (Revise los registros de las evaluaciones hechas por
                                    profesores o directivas del programa con respecto a cada asignatura o a la
                                    estructura curricular general).</li>
                                <li>¿Se cuenta con criterios claros de evaluación de los estudiantes? (Se pueden
                                    valorar criterios, rúbricas, formatos, etc. que tenga la institución para la
                                    evaluación de los estudiantes). ¿Cómo se determina el logro de las competencias
                                    esperadas?</li>
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 4', 'name' => 'documento_dimension_4', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                        <h3>Dimensión 5: Investigación</h3>
                        <div>
                            <p>Como parte del desarrollo de competencias en un área específica, la formación en
                                investigación mejora el desempeño, el desarrollo profesional y personal, así como la
                                autonomía de los profesionales en formación. El programa de entrenamiento avanzado en
                                medicina debe:</p>
                            <ol>
                                <li>Asegurar las posibilidades de participación en actividades de desarrollo de
                                    investigación como parte del programa.</li>
                                <li>Permitir la participación en proyectos de investigación como parte del programa si
                                    es relevante.</li>
                            </ol>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿Existen líneas de investigación relacionadas con el programa de entrenamiento
                                    avanzado en medicina? ó ¿Posee el programa sus propias líneas de investigación?
                                </li>
                                <li>¿Existe relación entre las líneas de investigación y las áreas del programa de
                                    entrenamiento avanzado en medicina?</li>
                                <li>¿Se han establecido mecanismos para que la investigación retroalimente
                                    efectivamente el desarrollo del programa?</li>
                                <li>¿Se brindan oportunidades para que los estudiantes, participen en proyectos de
                                    investigación de los profesores? (Estas oportunidades pueden expresarse en la
                                    posibilidad de desarrollar prácticas académicas y otro tipo de actividades
                                    pertinentes).</li>
                                <li>¿Mediante qué estrategias y actividades académicas se promueve la participación
                                    de estudiantes y profesores del programa de entrenamiento avanzado en medicina,
                                    investigación?</li>
                            </ul>
                            <strong>Información de soporte</strong>
                            <ul>
                                <li>Porcentaje de profesores que han participado en los últimos cuatro años en
                                    programas de desarrollo profesoral, proporción de docentes en comisión académica
                                    o de estudio orientadas a estudios avanzados, proyectos de investigación y
                                    pasantías, relacionadas con la especificidad del programa de entrenamiento avanzado
                                    en medicina</li>
                                <li>Número y temáticas de líneas de investigación propias y relacionadas con el
                                    programa de entrenamiento avanzado en medicina.</li>
                                <li>Enumere las mejoras a los contenidos del programa de entrenamiento avanzado en
                                    medicina en los últimos cuatro años como resultado de la actividad investigativa.
                                </li>
                                <li>Relación del número total de proyectos en ejecución y los proyectos
                                    específicamente de investigación relacionados con la especificidad del programa de
                                    entrenamiento avanzado en medicina.</li>
                                <li>Los antecedentes y desarrollos de la investigación en la institución en áreas
                                    afines con el programa de entrenamiento avanzado en medicina.</li>
                                <li>Listado de personal académico que prestan servicios al programa de entrenamiento
                                    avanzado en medicina indicando su dedicación a la investigación.</li>
                                <li>Publicaciones realizadas por el personal académico en torno a resultados de
                                    proyectos de investigación.</li>
                                <li>Documento que establezca los mecanismos para apoyar actividades de investigación
                                    relacionadas con la especificidad del programa de entrenamiento avanzado en
                                    medicina.</li>
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 5', 'name' => 'documento_dimension_5', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                        <h3>Dimensión 6: Recursos educativos, administrativos y financieros</h3>
                        <div>
                            <p>Para garantizar la calidad del programa de entrenamiento avanzado en medicina, se debe
                                contar con medios educativos y financieros suficientes para el desarrollo del programa.
                                Se deben tener en cuenta:</p>
                            <ol>
                                <li>El programa de entrenamiento avanzado en medicina, así como el escenario de
                                    práctica, deben contar con recursos bibliográficos e informáticos suficientes
                                    para el desarrollo de sus actividades académicas de formación.</li>
                                <li>El desarrollo del programa de entrenamiento avanzado deberá ser apoyado por una
                                    institución que cuente con una relación docencia servicio con una institución
                                    educativa formal.</li>
                                <li>Como parte de la formación integral del profesional, el sitio de práctica contará
                                    con áreas de trabajo y descanso durante el tiempo que dure el desarrollo del
                                    programa de entrenamiento avanzado en medicina.</li>
                                <li>La institución que coordina el programa de entrenamiento avanzado en medicina,
                                    deberá contar con los recursos administrativos y financieros necesarios para el
                                    desarrollo del programa. Se llevan a cabo las acciones necesarias para la dotación
                                    y administración de los recursos materiales necesarios para la práctica formativa.
                                </li>
                                <li>El sitio de prácticas deberá demostrar que cuenta con el recurso técnico,
                                    tecnológico y humano especializado para el desarrollo del programa de entrenamiento
                                    avanzado en medicina.</li>
                                <li>Si el programa se propone b-learning, se requiere presentar la descripción
                                    detallada de las condiciones de infraestructura tecnológica y de contenidos que
                                    soportan el trabajo en los entornos virtuales.</li>
                            </ol>
                            <strong>Cuestiones a considerar en la apreciación de calidad</strong>
                            <ul>
                                <li>¿Existen en la institución estrategias claras en materia presupuestal que
                                    posibiliten la viabilidad, permanencia y desarrollo del programa de entrenamiento
                                    avanzado en medicina?</li>
                                <li>¿Qué monto económico financiero se tiene previsto para la apertura del programa de
                                    entrenamiento avanzado en medicina?</li>
                                <li>Verifique que el programa de entrenamiento avanzado en medicina cuenta con un
                                    presupuesto coherente con su plan de desarrollo, adecuado y suficiente para el
                                    desarrollo de actividades de docencia.</li>
                                <li>Verifique que la institución dispone del monto financiero para la apertura y/o
                                    mantenimiento del programa de entrenamiento avanzado en medicina, acorde con las
                                    necesidades planteadas.</li>
                                <li>Describa el aprovisionamiento (ya sea por contrato de fiducia) que acredita la
                                    disponibilidad y destinación de los recursos necesarios para garantizar la
                                    dotación, mantenimiento y sostenibilidad del programa de entrenamiento avanzado en
                                    medicina.</li>
                                <li>¿Cuenta la institución con una biblioteca y/o centro de recursos bibliográficos
                                    dotado con el material bibliográfico suficiente en el campo de conocimiento del
                                    programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Permite la cantidad del material bibliográfico (número de volúmenes, número de
                                    títulos, bases de datos y elementos anexos y complementarios) disponible para el
                                    programa de entrenamiento avanzado en salud, el acceso sin dificultad a todos los
                                    estudiantes?</li>
                                <li>¿Permite la calidad del material bibliográfico disponible para el programa de
                                    entrenamiento avanzado en medicina, el acceso a materiales que apoyen el análisis
                                    crítico y la profundización?</li>
                                <li>¿Tiene facilidad el estudiante para encontrar el material bibliográfico que se le
                                    recomienda en la bibliografía del programa de entrenamiento avanzado en medicina?
                                </li>
                                <li>¿Se puede identificar con claridad qué campos de práctica o de experimentación
                                    requiere el programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Dispone la institución de los materiales y medios didácticos necesarios para
                                    apoyar el desarrollo del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Cuenta la institución con laboratorios, equipos o talleres requeridos para el
                                    desarrollo del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Es adecuada la dotación de los laboratorios en equipos e insumos?</li>
                                <li>¿Existen normas de higiene y seguridad para el uso de laboratorios?. ¿Éstas se
                                    divulgan entre los usuarios de los laboratorios?</li>
                                <li>¿Presentan los laboratorios condiciones de seguridad que garanticen el uso de sus
                                    instalaciones, materiales y equipos?</li>
                                <li>¿Posee la institución estrategias y recursos de conexión con redes de
                                    información, nacionales e internacionales?</li>
                                <li>¿Dispone la institución de conexiones a correo electrónico o medios de
                                    comunicación para estudiantes y profesores?</li>
                                <li>¿Hay mecanismos ágiles y flexibles para facilitar la consulta bibliográfica y el
                                    acceso a bases de datos oportunamente?</li>
                                <li>¿Dispone la institución de software, en cantidad y calidad, para garantizar el
                                    apoyo y desarrollo del programa de entrenamiento avanzado en medicina?</li>
                                <li>¿Se planea racionalmente el uso de los recursos tecnológicos existentes para
                                    garantizar la cobertura y la calidad del servicio?</li>
                                <li>¿Existen convenios interinstitucionales con bibliotecas o centros de información
                                    para la realización de intercambios?</li>
                                <li>¿Existen convenios interinstitucionales para el uso de laboratorios, equipos o
                                    talleres?</li>
                                <li>¿Cuenta el programa de entrenamiento avanzado en medicina con personal profesional
                                    calificado para el manejo de la biblioteca, laboratorios, equipos y talleres?</li>
                                <li>¿Tiene la institución un plan de mantenimiento y renovación de equipos?</li>
                                <li>¿Qué soportes permiten verificar la suficiencia, legalidad y nivel de
                                    actualización en recursos bibliográficos (libros, revistas, bases de datos
                                    especializadas u otros) en relación a la naturaleza del programa de entrenamiento
                                    avanzado en medicina y la cantidad de estudiantes actual o proyectada?</li>
                                <li>¿Según la naturaleza del programa de entrenamiento avanzado en medicina, cómo se
                                    demuestra la suficiencia en: equipos, software con licencia, conectividad,
                                    laboratorios físicos y simulados para la experimentación, talleres e insumos; a
                                    partir del desarrollo de competencias propuestas y la cantidad de estudiantes
                                    proyectada?</li>
                                <li>En el caso de programas de entrenamiento avanzado en medicina bajo la modalidad
                                    be-learning: ¿De qué manera garantiza la institución una infraestructura
                                    apropiada, legal y actualizada para los programas de entrenamiento avanzado de esta
                                    naturaleza en cuanto a plataforma, conectividad, producción de materiales,
                                    disponibilidad del material producido y los medios educativos, herramientas de
                                    comunicación, interacción y evaluación?</li>
                                <li>¿Cómo se logra verificar la disponibilidad y suficiencia en los escenarios de
                                    práctica académica, profesional o de docencia servicio en coherencia con la
                                    cantidad de estudiantes y profesores actual o proyectada?</li>
                                <li>¿Cuáles son los elementos que al verificarse permiten a la institución garantizar
                                    que la infraestructura física (aulas, biblioteca, auditorios, laboratorios,
                                    escenarios para el bienestar universitario) es adecuada, y suficiente para el
                                    programa de entrenamiento avanzado, según su naturaleza, y cumple con las normas
                                    vigentes?</li>
                                <li>¿Permiten los laboratorios, talleres y sitios de práctica realizar las actividades
                                    experimentales con comodidad y seguridad?</li>
                                <li>¿Posee la institución estrategias y normas específicas para el manejo de riesgos?
                                </li>
                            </ul>
                            <strong>Información de soporte</strong>
                            <ul>
                                <li>Descripción de la asignación y ejecución de los recursos financieros de acuerdo
                                    al plan de desarrollo y funcionamiento general del programa de entrenamiento
                                    avanzado en medicina.</li>
                                <li>Descripción de la asignación y ejecución de los presupuestos del programa de
                                    entrenamiento avanzado en medicina para el desarrollo de actividades previstas.</li>
                                <li>Formato de pago de matrícula de estudiantes.</li>
                                <li>Relación entre costos e ingresos.</li>
                                <li>Indicadores de proyección relacionados con la continuidad desde el punto de vista
                                    financiero.</li>
                                <li>Descripción de las necesidades del programa de entrenamiento avanzado en medicina
                                    con respecto a los medios educativos con que cuenta y debe contar.</li>
                                <li>Mecanismos de evaluación de los recursos y materiales dirigidos a los usuarios
                                    finales (docentes y estudiantes).</li>
                                <li>Soportes de convenios (según requerimientos del programa) para el desarrollo de
                                    prácticas y actividades de docencia servicio</li>
                            </ul>
                            <div class="form-group">
                                <div class="form-input">
                                    <?php echo $main->input(array('span' => 'Adjuntar documento de soporte de la Dimensión 6', 'name' => 'documento_dimension_6', 'type' => 'file', 'class' => '', 'accept' => $main->allowedDocs)); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group form-programa-entre-avanzado" style="display:none;">
                <div class="form-input text-center">
                    <input type="button" class="btn success" value="Enviar">
                </div>
            </div>
            <div class="form-group form-generico">
                <div class="form-input">
                    <span>Dirigido a:</span>
                    <table>
                        <tbody>
                            <tr>
                                <td>Médicos Generales</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_medicos_generales', (isset($ofertaData['oferta_dirigido_medicos_generales']) ? $ofertaData['oferta_dirigido_medicos_generales'] : '')); ?>
                                </td>
                                <td>Médicos especialistas</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_medicos_especialistas', (isset($ofertaData['oferta_dirigido_medicos_especialistas']) ? $ofertaData['oferta_dirigido_medicos_especialistas'] : '')); ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Profesionales de la salud</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_profesionales_salud', (isset($ofertaData['oferta_dirigido_profesionales_salud']) ? $ofertaData['oferta_dirigido_profesionales_salud'] : '')); ?>
                                </td>
                                <td>Otros profesionales</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_otro_profesionales', (isset($ofertaData['oferta_dirigido_otro_profesionales']) ? $ofertaData['oferta_dirigido_otro_profesionales'] : '')); ?>
                                </td>
                            </tr>
                            <tr>
                                <td>Estudiantes pregrado</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_estudiantes_pregrado', (isset($ofertaData['oferta_dirigido_estudiantes_pregrado']) ? $ofertaData['oferta_dirigido_estudiantes_pregrado'] : '')); ?>
                                </td>
                                <td>Docentes</td>
                                <td><?php echo $main->radio_si_no('oferta_dirigido_docentes', (isset($ofertaData['oferta_dirigido_docentes']) ? $ofertaData['oferta_dirigido_docentes'] : '')); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="form-group form-generico">
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Fecha de inicio', 'name' => 'oferta_fecha_inicio', 'type' => 'date', 'required' => true, 'value' => (isset($ofertaData['oferta_fecha_inicio']) ? $ofertaData['oferta_fecha_inicio'] : ''))); ?>
                </div>
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Hora de inicio', 'name' => 'oferta_hora_inicio', 'type' => 'time', 'value' => (isset($ofertaData['oferta_hora_inicio']) ? $ofertaData['oferta_hora_inicio'] : ''))); ?>
                </div>
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Fecha de finalización', 'name' => 'oferta_fecha_finalizacion', 'type' => 'date', 'required' => true, 'value' => (isset($ofertaData['oferta_fecha_finalizacion']) ? $ofertaData['oferta_fecha_finalizacion'] : ''))); ?>
                </div>
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Hora de finalización', 'name' => 'oferta_hora_finalizacion', 'type' => 'time', 'value' => (isset($ofertaData['oferta_hora_finalizacion']) ? $ofertaData['oferta_hora_finalizacion'] : ''))); ?>
                </div>
            </div>
            <div class="form-group form-generico">
                <div class="form-input">
                    <span required>Cupos limitados:</span>
                    <label><input type="radio" name="oferta_cupos_limitados" value="Si"
                            onclick="document.getElementById('oferta_cupos_limitados_cuantos').style.display = 'block';"
                            <?php echo isset($ofertaData['oferta_cupos_limitados']) && $ofertaData['oferta_cupos_limitados'] == 'Si' ? 'checked' : ''; ?>>
                        Si</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_cupos_limitados" value="No"
                            onclick="document.getElementById('oferta_cupos_limitados_cuantos').style.display = 'none';"
                            <?php echo isset($ofertaData['oferta_cupos_limitados']) && $ofertaData['oferta_cupos_limitados'] == 'Si' ? '' : 'checked'; ?>>
                        No</label><br />
                    <input type="number" id="oferta_cupos_limitados_cuantos" name="oferta_cupos_limitados_cuantos"
                        class="input" min="0" placeholder="¿Cuantos?"
                        value="<?php echo isset($ofertaData['oferta_cupos_limitados_cuantos']) ? $ofertaData['oferta_cupos_limitados_cuantos'] : ''; ?>"
                        style="display:<?php echo isset($ofertaData['oferta_cupos_limitados']) && $ofertaData['oferta_cupos_limitados'] == 'Si' ? 'block' : 'none'; ?>;">
                </div>
                <div class="form-input">
                    <span required>Tipo de oferta:</span>
                    <label><input type="radio" name="oferta_tipo_oferta" value="Pública"
                            <?php echo isset($ofertaData['oferta_tipo_oferta']) && $ofertaData['oferta_tipo_oferta'] == 'Pública' ? 'checked' : ''; ?>>
                        Pública</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_tipo_oferta" value="Privada"
                            <?php echo isset($ofertaData['oferta_tipo_oferta']) && $ofertaData['oferta_tipo_oferta'] == 'Privada' ? 'checked' : ''; ?>>
                        Privada</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_tipo_oferta" value="In Company"
                            <?php echo isset($ofertaData['oferta_tipo_oferta']) && $ofertaData['oferta_tipo_oferta'] == 'In Company' ? 'checked' : ''; ?>>
                        In Company</label>
                </div>
            </div>
            <div class="form-group form-generico">
                <div class="form-input">
                    <span required>Modalidad:</span>
                    <label><input type="radio" name="oferta_modalidad" value="Presencial"
                            onclick="document.getElementById('divmodalidad').style.display = 'flex';"
                            <?php echo isset($ofertaData['oferta_modalidad']) && $ofertaData['oferta_modalidad'] == 'Presencial' ? 'checked' : ''; ?>>
                        Presencial</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_modalidad" value="Virtual"
                            onclick="document.getElementById('divmodalidad').style.display = 'none';"
                            <?php echo isset($ofertaData['oferta_modalidad']) && $ofertaData['oferta_modalidad'] == 'Virtual' ? 'checked' : ''; ?>>
                        Virtual</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_modalidad" value="Combinado (blended)"
                            onclick="document.getElementById('divmodalidad').style.display = 'flex';"
                            <?php echo isset($ofertaData['oferta_modalidad']) && $ofertaData['oferta_modalidad'] == 'Combinado (blended)' ? 'checked' : ''; ?>>
                        Combinado
                        (blended)</label>
                </div>
                <div class="form-input">
                    <span required>Sede única:</span>
                    <label><input type="radio" name="oferta_sede_unica" value="Si"
                            <?php echo isset($ofertaData['oferta_sede_unica']) && $ofertaData['oferta_sede_unica'] == 'Si' ? 'checked' : ''; ?>>
                        Si</label>&nbsp;&nbsp;&nbsp;
                    <label><input type="radio" name="oferta_sede_unica" value="No (Multi-sede)"
                            <?php echo isset($ofertaData['oferta_sede_unica']) && $ofertaData['oferta_sede_unica'] == 'No (Multi-sede)' ? 'checked' : ''; ?>>
                        No (Multi-sede)</label>
                </div>
            </div>
            <div id="divmodalidad" class="form-group form-generico"
                style="display:<?php echo isset($ofertaData['oferta_modalidad']) && ($ofertaData['oferta_modalidad'] == 'Presencial' || $ofertaData['oferta_modalidad'] == 'Combinado (blended)') ? 'flex' : 'none'; ?>;">
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Departamento', 'name' => 'oferta_departamento', 'type' => 'select', 'value' => (isset($ofertaData['oferta_departamento']) ? $ofertaData['oferta_departamento'] : '')), $departamento); ?>
                </div>
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Ciudad', 'name' => 'oferta_ciudad', 'value' => (isset($ofertaData['oferta_ciudad']) ? $ofertaData['oferta_ciudad'] : ''))); ?><?php echo $main->ayuda_icon('Si su institución cuenta con varias sucursales, registre únicamente la principal, en donde se encuentre ubicado el representante legal registrado en el N.I.T.'); ?>
                </div>
            </div>
            <div class="form-group form-generico">
                <div class="form-input">
                    <?php echo $main->input(array('span' => 'Intensidad horaria', 'name' => 'oferta_intensidad_horaria', 'type' => 'number', 'value' => (isset($ofertaData['oferta_intensidad_horaria']) ? $ofertaData['oferta_intensidad_horaria'] : ''))); ?>
                </div>
                <div class="form-input">
                    <div class="form-group">
                        <div class="form-input">
                            <?php echo $main->input(array('span' => '% Teóricas', 'name' => 'oferta_porc_teoricas', 'type' => 'number', 'value' => (isset($ofertaData['oferta_porc_teoricas']) ? $ofertaData['oferta_porc_teoricas'] : ''))); ?>
                        </div>
                        <div class="form-input">
                            <?php echo $main->input(array('span' => '% Practicas', 'name' => 'oferta_porc_practicas', 'type' => 'number', 'value' => (isset($ofertaData['oferta_porc_practicas']) ? $ofertaData['oferta_porc_practicas'] : ''))); ?>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="form-input">
                            <?php echo $main->input(array('span' => '% Autónomo del estudiante', 'name' => 'oferta_porc_autonomo_estudiante', 'type' => 'number', 'value' => (isset($ofertaData['oferta_porc_autonomo_estudiante']) ? $ofertaData['oferta_porc_autonomo_estudiante'] : ''))); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>