<?php require('_common/_f.php'); ?>
<!DOCTYPE html>
<html>
<?php require('_common/head.php'); ?>
<?php require('_common/auth.php'); ?>
<?php require('_common/admin.php'); ?>

<body>
    <?php require('_common/header.php'); ?>
    <div class="main-column">
        <?php echo $iets->formOpen('?saveUser'); ?>
        <h3><label id="titulo">Crear</label> usuario:</h3>
        <div class="form-group">
            <div class="form-input two-col">
                <input type="hidden" name="idusuario" id="idusuario">
                <input type="text" name="nombres" id="nombres" class="input" placeholder="Nombres" required>
            </div>
            <div class="form-input two-col">
                <input type="text" name="apellidos" id="apellidos" class="input" placeholder="Apellidos" required>
            </div>
        </div>
        <div class="form-group">
            <div class="form-input two-col">
                <input type="email" name="email" id="email" class="input" placeholder="Correo electrónico" required>
            </div>
            <div class="form-input two-col">
                <input type="text" name="clave" id="clave" class="input" placeholder="Contraseña" required>
            </div>
        </div>
        <div class="form-group">
            <div class="form-input three-col">
                <span>Tipo de usuario:</span>
            </div>
            <div class="form-input three-col">
                <label><input type="radio" name="rol" id="rol1" value="1" required> Administrador</label>
            </div>
            <div class="form-input three-col">
                <label><input type="radio" name="rol" id="rol0" value="0"> Registrado (Personal IETS)</label>
            </div>
        </div>
        <div class="form-group">
            <input class="btn-guardar" type="submit" name="btn1" value="Guardar">
        </div>
        <?php echo $iets->formClose(); ?>
        <br />
        <h3>Lista de usuarios:</h3>
        <table id="datatable1" class="stripe compact row-border">
            <thead>
                <tr>
                    <th>Datos</th>
                    <th>Privilegio</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                foreach($iets->usuarios() as $usuario) { ?>
                <tr>
                    <td><span><?php echo $usuario['apellidos']; ?></span>,
                        <span><?php echo $usuario['nombres']; ?></span><br />
                        <span><?php echo $usuario['email']; ?>
                    </td>
                    <td><?php if($usuario['rol'] == 1) {
                            echo 'Administrador';
                        } else {
                            echo 'Registrado (Personal IETS)';
                        } ?></td>
                    <td><?php if ($usuario['estado'] == 1) { ?>
                        <a href="javascript:void(0)" onclick="javascript:editarUsuario(this);" data-idusuario="<?php echo $usuario['idusuario']; ?>"
                            data-apellidos="<?php echo $usuario['apellidos']; ?>"
                            data-nombres="<?php echo $usuario['nombres']; ?>"
                            data-email="<?php echo $usuario['email']; ?>"
                            data-rol="<?php echo $usuario['rol']; ?>">Editar</a>&nbsp;|&nbsp;
                        <?php } ?>
                        <a href="?statusUser&idusuario=<?php echo $usuario['idusuario']; ?>&estado=<?php echo $usuario['estado']; ?>"><?php echo $usuario['estado'] == 1 ? 'Deshabilitar' : 'Habilitar'; ?></a></td>
                </tr>
                <?php } ?>

            </tbody>
        </table>
    </div>
    <?php require('_common/footer.php'); ?>
</body>

</html>