/*
 Highcharts JS v7.2.0 (2019-09-03)

 Force directed graph module

 (c) 2010-2019 Torstein Honsi

 License: www.highcharts.com/license
*/
(function(k){"object"===typeof module&&module.exports?(k["default"]=k,module.exports=k):"function"===typeof define&&define.amd?define("highcharts/modules/networkgraph",["highcharts"],function(l){k(l);k.Highcharts=l;return k}):k("undefined"!==typeof Highcharts?Highcharts:void 0)})(function(k){function l(g,a,c,d){g.hasOwnProperty(a)||(g[a]=d.apply(null,c))}k=k?k._modules:{};l(k,"mixins/nodes.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(g,a){var c=a.defined,d=g.pick,h=g.Point;g.NodesMixin=
{createNode:function(b){function e(b,e){return g.find(b,function(b){return b.id===e})}var f=e(this.nodes,b),a=this.pointClass;if(!f){var p=this.options.nodes&&e(this.options.nodes,b);f=(new a).init(this,g.extend({className:"highcharts-node",isNode:!0,id:b,y:1},p));f.linksTo=[];f.linksFrom=[];f.formatPrefix="node";f.name=f.name||f.options.id;f.mass=d(f.options.mass,f.options.marker&&f.options.marker.radius,this.options.marker&&this.options.marker.radius,4);f.getSum=function(){var b=0,e=0;f.linksTo.forEach(function(e){b+=
e.weight});f.linksFrom.forEach(function(b){e+=b.weight});return Math.max(b,e)};f.offset=function(b,e){for(var d=0,a=0;a<f[e].length;a++){if(f[e][a]===b)return d;d+=f[e][a].weight}};f.hasShape=function(){var b=0;f.linksTo.forEach(function(e){e.outgoing&&b++});return!f.linksTo.length||b!==f.linksTo.length};this.nodes.push(f)}return f},generatePoints:function(){var b=this.chart,e={};g.Series.prototype.generatePoints.call(this);this.nodes||(this.nodes=[]);this.colorCounter=0;this.nodes.forEach(function(b){b.linksFrom.length=
0;b.linksTo.length=0;b.level=void 0});this.points.forEach(function(f){c(f.from)&&(e[f.from]||(e[f.from]=this.createNode(f.from)),e[f.from].linksFrom.push(f),f.fromNode=e[f.from],b.styledMode?f.colorIndex=d(f.options.colorIndex,e[f.from].colorIndex):f.color=f.options.color||e[f.from].color);c(f.to)&&(e[f.to]||(e[f.to]=this.createNode(f.to)),e[f.to].linksTo.push(f),f.toNode=e[f.to]);f.name=f.name||f.id},this);this.nodeLookup=e},setData:function(){this.nodes&&(this.nodes.forEach(function(b){b.destroy()}),
this.nodes.length=0);g.Series.prototype.setData.apply(this,arguments)},destroy:function(){this.data=[].concat(this.points||[],this.nodes);return g.Series.prototype.destroy.apply(this,arguments)},setNodeState:function(b){var e=arguments,d=this.isNode?this.linksTo.concat(this.linksFrom):[this.fromNode,this.toNode];"select"!==b&&d.forEach(function(b){b.series&&(h.prototype.setState.apply(b,e),b.isNode||(b.fromNode.graphic&&h.prototype.setState.apply(b.fromNode,e),b.toNode.graphic&&h.prototype.setState.apply(b.toNode,
e)))});h.prototype.setState.apply(this,e)}}});l(k,"modules/networkgraph/integrations.js",[k["parts/Globals.js"]],function(g){g.networkgraphIntegrations={verlet:{attractiveForceFunction:function(a,c){return(c-a)/a},repulsiveForceFunction:function(a,c){return(c-a)/a*(c>a?1:0)},barycenter:function(){var a=this.options.gravitationalConstant,c=this.barycenter.xFactor,d=this.barycenter.yFactor;c=(c-(this.box.left+this.box.width)/2)*a;d=(d-(this.box.top+this.box.height)/2)*a;this.nodes.forEach(function(a){a.fixedPosition||
(a.plotX-=c/a.mass/a.degree,a.plotY-=d/a.mass/a.degree)})},repulsive:function(a,c,d){c=c*this.diffTemperature/a.mass/a.degree;a.fixedPosition||(a.plotX+=d.x*c,a.plotY+=d.y*c)},attractive:function(a,c,d){var h=a.getMass(),b=-d.x*c*this.diffTemperature;c=-d.y*c*this.diffTemperature;a.fromNode.fixedPosition||(a.fromNode.plotX-=b*h.fromNode/a.fromNode.degree,a.fromNode.plotY-=c*h.fromNode/a.fromNode.degree);a.toNode.fixedPosition||(a.toNode.plotX+=b*h.toNode/a.toNode.degree,a.toNode.plotY+=c*h.toNode/
a.toNode.degree)},integrate:function(a,c){var d=-a.options.friction,h=a.options.maxSpeed,b=(c.plotX+c.dispX-c.prevX)*d;d*=c.plotY+c.dispY-c.prevY;var e=Math.abs,f=e(b)/(b||1);e=e(d)/(d||1);b=f*Math.min(h,Math.abs(b));d=e*Math.min(h,Math.abs(d));c.prevX=c.plotX+c.dispX;c.prevY=c.plotY+c.dispY;c.plotX+=b;c.plotY+=d;c.temperature=a.vectorLength({x:b,y:d})},getK:function(a){return Math.pow(a.box.width*a.box.height/a.nodes.length,.5)}},euler:{attractiveForceFunction:function(a,c){return a*a/c},repulsiveForceFunction:function(a,
c){return c*c/a},barycenter:function(){var a=this.options.gravitationalConstant,c=this.barycenter.xFactor,d=this.barycenter.yFactor;this.nodes.forEach(function(h){if(!h.fixedPosition){var b=h.getDegree();b*=1+b/2;h.dispX+=(c-h.plotX)*a*b/h.degree;h.dispY+=(d-h.plotY)*a*b/h.degree}})},repulsive:function(a,c,d,h){a.dispX+=d.x/h*c/a.degree;a.dispY+=d.y/h*c/a.degree},attractive:function(a,c,d,h){var b=a.getMass(),e=d.x/h*c;c*=d.y/h;a.fromNode.fixedPosition||(a.fromNode.dispX-=e*b.fromNode/a.fromNode.degree,
a.fromNode.dispY-=c*b.fromNode/a.fromNode.degree);a.toNode.fixedPosition||(a.toNode.dispX+=e*b.toNode/a.toNode.degree,a.toNode.dispY+=c*b.toNode/a.toNode.degree)},integrate:function(a,c){c.dispX+=c.dispX*a.options.friction;c.dispY+=c.dispY*a.options.friction;var d=c.temperature=a.vectorLength({x:c.dispX,y:c.dispY});0!==d&&(c.plotX+=c.dispX/d*Math.min(Math.abs(c.dispX),a.temperature),c.plotY+=c.dispY/d*Math.min(Math.abs(c.dispY),a.temperature))},getK:function(a){return Math.pow(a.box.width*a.box.height/
a.nodes.length,.3)}}}});l(k,"modules/networkgraph/QuadTree.js",[k["parts/Globals.js"]],function(g){var a=g.QuadTreeNode=function(d){this.box=d;this.boxSize=Math.min(d.width,d.height);this.nodes=[];this.body=this.isInternal=!1;this.isEmpty=!0};g.extend(a.prototype,{insert:function(d,c){this.isInternal?this.nodes[this.getBoxPosition(d)].insert(d,c-1):(this.isEmpty=!1,this.body?c?(this.isInternal=!0,this.divideBox(),!0!==this.body&&(this.nodes[this.getBoxPosition(this.body)].insert(this.body,c-1),this.body=
!0),this.nodes[this.getBoxPosition(d)].insert(d,c-1)):(c=new a({top:d.plotX,left:d.plotY,width:.1,height:.1}),c.body=d,c.isInternal=!1,this.nodes.push(c)):(this.isInternal=!1,this.body=d))},updateMassAndCenter:function(){var d=0,a=0,b=0;this.isInternal?(this.nodes.forEach(function(e){e.isEmpty||(d+=e.mass,a+=e.plotX*e.mass,b+=e.plotY*e.mass)}),a/=d,b/=d):this.body&&(d=this.body.mass,a=this.body.plotX,b=this.body.plotY);this.mass=d;this.plotX=a;this.plotY=b},divideBox:function(){var d=this.box.width/
2,c=this.box.height/2;this.nodes[0]=new a({left:this.box.left,top:this.box.top,width:d,height:c});this.nodes[1]=new a({left:this.box.left+d,top:this.box.top,width:d,height:c});this.nodes[2]=new a({left:this.box.left+d,top:this.box.top+c,width:d,height:c});this.nodes[3]=new a({left:this.box.left,top:this.box.top+c,width:d,height:c})},getBoxPosition:function(a){var d=a.plotY<this.box.top+this.box.height/2;return a.plotX<this.box.left+this.box.width/2?d?0:3:d?1:2}});var c=g.QuadTree=function(d,c,b,e){this.box=
{left:d,top:c,width:b,height:e};this.maxDepth=25;this.root=new a(this.box,"0");this.root.isInternal=!0;this.root.isRoot=!0;this.root.divideBox()};g.extend(c.prototype,{insertNodes:function(a){a.forEach(function(a){this.root.insert(a,this.maxDepth)},this)},visitNodeRecursive:function(a,c,b){var e;a||(a=this.root);a===this.root&&c&&(e=c(a));!1!==e&&(a.nodes.forEach(function(a){if(a.isInternal){c&&(e=c(a));if(!1===e)return;this.visitNodeRecursive(a,c,b)}else a.body&&c&&c(a.body);b&&b(a)},this),a===this.root&&
b&&b(a))},calculateMassAndCenter:function(){this.visitNodeRecursive(null,null,function(a){a.updateMassAndCenter()})}})});l(k,"modules/networkgraph/layouts.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],function(g,a){var c=a.defined,d=g.pick;a=g.addEvent;var h=g.Chart;g.layouts={"reingold-fruchterman":function(){}};g.extend(g.layouts["reingold-fruchterman"].prototype,{init:function(b){this.options=b;this.nodes=[];this.links=[];this.series=[];this.box={x:0,y:0,width:0,height:0};this.setInitialRendering(!0);
this.integration=g.networkgraphIntegrations[b.integration];this.attractiveForce=d(b.attractiveForce,this.integration.attractiveForceFunction);this.repulsiveForce=d(b.repulsiveForce,this.integration.repulsiveForceFunction);this.approximation=b.approximation},start:function(){var b=this.series,a=this.options;this.currentStep=0;this.forces=b[0]&&b[0].forces||[];this.initialRendering&&(this.initPositions(),b.forEach(function(b){b.render()}));this.setK();this.resetSimulation(a);a.enableSimulation&&this.step()},
step:function(){var b=this,a=this.series,c=this.options;b.currentStep++;"barnes-hut"===b.approximation&&(b.createQuadTree(),b.quadTree.calculateMassAndCenter());b.forces.forEach(function(a){b[a+"Forces"](b.temperature)});b.applyLimits(b.temperature);b.temperature=b.coolDown(b.startTemperature,b.diffTemperature,b.currentStep);b.prevSystemTemperature=b.systemTemperature;b.systemTemperature=b.getSystemTemperature();c.enableSimulation&&(a.forEach(function(b){b.chart&&b.render()}),b.maxIterations--&&isFinite(b.temperature)&&
!b.isStable()?(b.simulation&&g.win.cancelAnimationFrame(b.simulation),b.simulation=g.win.requestAnimationFrame(function(){b.step()})):b.simulation=!1)},stop:function(){this.simulation&&g.win.cancelAnimationFrame(this.simulation)},setArea:function(b,a,c,d){this.box={left:b,top:a,width:c,height:d}},setK:function(){this.k=this.options.linkLength||this.integration.getK(this)},addElementsToCollection:function(b,a){b.forEach(function(b){-1===a.indexOf(b)&&a.push(b)})},removeElementFromCollection:function(b,
a){b=a.indexOf(b);-1!==b&&a.splice(b,1)},clear:function(){this.nodes.length=0;this.links.length=0;this.series.length=0;this.resetSimulation()},resetSimulation:function(){this.forcedStop=!1;this.systemTemperature=0;this.setMaxIterations();this.setTemperature();this.setDiffTemperature()},setMaxIterations:function(b){this.maxIterations=d(b,this.options.maxIterations)},setTemperature:function(){this.temperature=this.startTemperature=Math.sqrt(this.nodes.length)},setDiffTemperature:function(){this.diffTemperature=
this.startTemperature/(this.options.maxIterations+1)},setInitialRendering:function(b){this.initialRendering=b},createQuadTree:function(){this.quadTree=new g.QuadTree(this.box.left,this.box.top,this.box.width,this.box.height);this.quadTree.insertNodes(this.nodes)},initPositions:function(){var b=this.options.initialPositions;g.isFunction(b)?(b.call(this),this.nodes.forEach(function(b){c(b.prevX)||(b.prevX=b.plotX);c(b.prevY)||(b.prevY=b.plotY);b.dispX=0;b.dispY=0})):"circle"===b?this.setCircularPositions():
this.setRandomPositions()},setCircularPositions:function(){function b(a){a.linksFrom.forEach(function(a){g[a.toNode.id]||(g[a.toNode.id]=!0,m.push(a.toNode),b(a.toNode))})}var a=this.box,c=this.nodes,n=2*Math.PI/(c.length+1),p=c.filter(function(b){return 0===b.linksTo.length}),m=[],g={},h=this.options.initialPositionRadius;p.forEach(function(a){m.push(a);b(a)});m.length?c.forEach(function(b){-1===m.indexOf(b)&&m.push(b)}):m=c;m.forEach(function(b,c){b.plotX=b.prevX=d(b.plotX,a.width/2+h*Math.cos(c*
n));b.plotY=b.prevY=d(b.plotY,a.height/2+h*Math.sin(c*n));b.dispX=0;b.dispY=0})},setRandomPositions:function(){function b(b){b=b*b/Math.PI;return b-=Math.floor(b)}var a=this.box,c=this.nodes,n=c.length+1;c.forEach(function(c,e){c.plotX=c.prevX=d(c.plotX,a.width*b(e));c.plotY=c.prevY=d(c.plotY,a.height*b(n+e));c.dispX=0;c.dispY=0})},force:function(b){this.integration[b].apply(this,Array.prototype.slice.call(arguments,1))},barycenterForces:function(){this.getBarycenter();this.force("barycenter")},getBarycenter:function(){var b=
0,a=0,c=0;this.nodes.forEach(function(d){a+=d.plotX*d.mass;c+=d.plotY*d.mass;b+=d.mass});return this.barycenter={x:a,y:c,xFactor:a/b,yFactor:c/b}},barnesHutApproximation:function(b,a){var c=this.getDistXY(b,a),d=this.vectorLength(c);if(b!==a&&0!==d)if(a.isInternal)if(a.boxSize/d<this.options.theta&&0!==d){var e=this.repulsiveForce(d,this.k);this.force("repulsive",b,e*a.mass,c,d);var m=!1}else m=!0;else e=this.repulsiveForce(d,this.k),this.force("repulsive",b,e*a.mass,c,d);return m},repulsiveForces:function(){var b=
this;"barnes-hut"===b.approximation?b.nodes.forEach(function(a){b.quadTree.visitNodeRecursive(null,function(c){return b.barnesHutApproximation(a,c)})}):b.nodes.forEach(function(a){b.nodes.forEach(function(c){if(a!==c&&!a.fixedPosition){var d=b.getDistXY(a,c);var e=b.vectorLength(d);if(0!==e){var f=b.repulsiveForce(e,b.k);b.force("repulsive",a,f*c.mass,d,e)}}})})},attractiveForces:function(){var b=this,a,c,d;b.links.forEach(function(e){e.fromNode&&e.toNode&&(a=b.getDistXY(e.fromNode,e.toNode),c=b.vectorLength(a),
0!==c&&(d=b.attractiveForce(c,b.k),b.force("attractive",e,d,a,c)))})},applyLimits:function(){var b=this;b.nodes.forEach(function(a){a.fixedPosition||(b.integration.integrate(b,a),b.applyLimitBox(a,b.box),a.dispX=0,a.dispY=0)})},applyLimitBox:function(b,a){var c=b.radius;b.plotX=Math.max(Math.min(b.plotX,a.width-c),a.left+c);b.plotY=Math.max(Math.min(b.plotY,a.height-c),a.top+c)},coolDown:function(b,a,c){return b-a*c},isStable:function(){return.00001>Math.abs(this.systemTemperature-this.prevSystemTemperature)||
0>=this.temperature},getSystemTemperature:function(){return this.nodes.reduce(function(b,a){return b+a.temperature},0)},vectorLength:function(b){return Math.sqrt(b.x*b.x+b.y*b.y)},getDistR:function(b,a){b=this.getDistXY(b,a);return this.vectorLength(b)},getDistXY:function(b,a){var c=b.plotX-a.plotX;b=b.plotY-a.plotY;return{x:c,y:b,absX:Math.abs(c),absY:Math.abs(b)}}});a(h,"predraw",function(){this.graphLayoutsLookup&&this.graphLayoutsLookup.forEach(function(b){b.stop()})});a(h,"render",function(){function b(b){b.maxIterations--&&
isFinite(b.temperature)&&!b.isStable()&&!b.options.enableSimulation&&(b.beforeStep&&b.beforeStep(),b.step(),c=!1,a=!0)}var a=!1;if(this.graphLayoutsLookup){g.setAnimation(!1,this);for(this.graphLayoutsLookup.forEach(function(b){b.start()});!c;){var c=!0;this.graphLayoutsLookup.forEach(b)}a&&this.series.forEach(function(b){b&&b.layout&&b.render()})}})});l(k,"modules/networkgraph/draggable-nodes.js",[k["parts/Globals.js"]],function(g){var a=g.Chart,c=g.addEvent;g.dragNodesMixin={onMouseDown:function(a,
c){c=this.chart.pointer.normalize(c);a.fixedPosition={chartX:c.chartX,chartY:c.chartY,plotX:a.plotX,plotY:a.plotY};a.inDragMode=!0},onMouseMove:function(a,c){if(a.fixedPosition&&a.inDragMode){var b=this.chart,d=b.pointer.normalize(c);c=a.fixedPosition.chartX-d.chartX;d=a.fixedPosition.chartY-d.chartY;if(5<Math.abs(c)||5<Math.abs(d))c=a.fixedPosition.plotX-c,d=a.fixedPosition.plotY-d,b.isInsidePlot(c,d)&&(a.plotX=c,a.plotY=d,a.hasDragged=!0,this.redrawHalo(a),this.layout.simulation?this.layout.resetSimulation():
(this.layout.setInitialRendering(!1),this.layout.enableSimulation?this.layout.start():this.layout.setMaxIterations(1),this.chart.redraw(),this.layout.setInitialRendering(!0)))}},onMouseUp:function(a,c){a.fixedPosition&&a.hasDragged&&(this.layout.enableSimulation?this.layout.start():this.chart.redraw(),a.inDragMode=a.hasDragged=!1,this.options.fixedDraggable||delete a.fixedPosition)},redrawHalo:function(a){a&&this.halo&&this.halo.attr({d:a.haloPath(this.options.states.hover.halo.size)})}};c(a,"load",
function(){var a=this,g,b,e;a.container&&(g=c(a.container,"mousedown",function(d){var f=a.hoverPoint;f&&f.series&&f.series.hasDraggableNodes&&f.series.options.draggable&&(f.series.onMouseDown(f,d),b=c(a.container,"mousemove",function(a){return f&&f.series&&f.series.onMouseMove(f,a)}),e=c(a.container.ownerDocument,"mouseup",function(a){b();e();return f&&f.series&&f.series.onMouseUp(f,a)}))}));c(a,"destroy",function(){g()})})});l(k,"modules/networkgraph/networkgraph.src.js",[k["parts/Globals.js"],k["parts/Utilities.js"]],
function(g,a){var c=a.defined,d=g.addEvent;a=g.seriesType;var h=g.seriesTypes,b=g.pick,e=g.Point,f=g.Series,k=g.dragNodesMixin;a("networkgraph","line",{stickyTracking:!1,inactiveOtherPoints:!0,marker:{enabled:!0,states:{inactive:{opacity:.3,animation:{duration:50}}}},states:{inactive:{linkOpacity:.3,animation:{duration:50}}},dataLabels:{formatter:function(){return this.key},linkFormatter:function(){return this.point.fromNode.name+"<br>"+this.point.toNode.name},linkTextPath:{enabled:!0},textPath:{enabled:!1}},
link:{color:"rgba(100, 100, 100, 0.5)",width:1},draggable:!0,layoutAlgorithm:{initialPositions:"circle",initialPositionRadius:1,enableSimulation:!1,theta:.5,maxSpeed:10,approximation:"none",type:"reingold-fruchterman",integration:"euler",maxIterations:1E3,gravitationalConstant:.0625,friction:-.981},showInLegend:!1},{forces:["barycenter","repulsive","attractive"],hasDraggableNodes:!0,drawGraph:null,isCartesian:!1,requireSorting:!1,directTouch:!0,noSharedTooltip:!0,pointArrayMap:["from","to"],trackerGroups:["group",
"markerGroup","dataLabelsGroup"],drawTracker:g.TrackerMixin.drawTrackerPoint,animate:null,buildKDTree:g.noop,createNode:g.NodesMixin.createNode,destroy:function(){this.layout.removeElementFromCollection(this,this.layout.series);g.NodesMixin.destroy.call(this)},init:function(){f.prototype.init.apply(this,arguments);d(this,"updatedData",function(){this.layout&&this.layout.stop()});return this},generatePoints:function(){var a;g.NodesMixin.generatePoints.apply(this,arguments);this.options.nodes&&this.options.nodes.forEach(function(a){this.nodeLookup[a.id]||
(this.nodeLookup[a.id]=this.createNode(a.id))},this);for(a=this.nodes.length-1;0<=a;a--){var c=this.nodes[a];c.degree=c.getDegree();c.radius=b(c.marker&&c.marker.radius,this.options.marker&&this.options.marker.radius,0);this.nodeLookup[c.id]||c.remove()}this.data.forEach(function(a){a.formatPrefix="link"});this.indexateNodes()},indexateNodes:function(){this.nodes.forEach(function(a,b){a.index=b})},markerAttribs:function(a,b){b=f.prototype.markerAttribs.call(this,a,b);c(a.plotY)||(b.y=0);b.x=(a.plotX||
0)-(b.width/2||0);return b},translate:function(){this.processedXData||this.processData();this.generatePoints();this.deferLayout();this.nodes.forEach(function(a){a.isInside=!0;a.linksFrom.forEach(function(a){a.shapeType="path";a.y=1})})},deferLayout:function(){var a=this.options.layoutAlgorithm,b=this.chart.graphLayoutsStorage,d=this.chart.graphLayoutsLookup,f=this.chart.options.chart;if(this.visible){b||(this.chart.graphLayoutsStorage=b={},this.chart.graphLayoutsLookup=d=[]);var e=b[a.type];e||(a.enableSimulation=
c(f.forExport)?!f.forExport:a.enableSimulation,b[a.type]=e=new g.layouts[a.type],e.init(a),d.splice(e.index,0,e));this.layout=e;e.setArea(0,0,this.chart.plotWidth,this.chart.plotHeight);e.addElementsToCollection([this],e.series);e.addElementsToCollection(this.nodes,e.nodes);e.addElementsToCollection(this.points,e.links)}},render:function(){var a=this.points,b=this.chart.hoverPoint,c=[];this.points=this.nodes;h.line.prototype.render.call(this);this.points=a;a.forEach(function(a){a.fromNode&&a.toNode&&
(a.renderLink(),a.redrawLink())});b&&b.series===this&&this.redrawHalo(b);this.chart.hasRendered&&!this.options.dataLabels.allowOverlap&&(this.nodes.concat(this.points).forEach(function(a){a.dataLabel&&c.push(a.dataLabel)}),this.chart.hideOverlappingLabels(c))},drawDataLabels:function(){var a=this.options.dataLabels.textPath;f.prototype.drawDataLabels.apply(this,arguments);this.points=this.data;this.options.dataLabels.textPath=this.options.dataLabels.linkTextPath;f.prototype.drawDataLabels.apply(this,
arguments);this.points=this.nodes;this.options.dataLabels.textPath=a},pointAttribs:function(a,c){var d=c||a.state||"normal";c=f.prototype.pointAttribs.call(this,a,d);d=this.options.states[d];a.isNode||(c=a.getLinkAttributes(),d&&(c={stroke:d.linkColor||c.stroke,dashstyle:d.linkDashStyle||c.dashstyle,opacity:b(d.linkOpacity,c.opacity),"stroke-width":d.linkColor||c["stroke-width"]}));return c},redrawHalo:k.redrawHalo,onMouseDown:k.onMouseDown,onMouseMove:k.onMouseMove,onMouseUp:k.onMouseUp,setState:function(a,
b){b?(this.points=this.nodes.concat(this.data),f.prototype.setState.apply(this,arguments),this.points=this.data):f.prototype.setState.apply(this,arguments);this.layout.simulation||a||this.render()}},{setState:g.NodesMixin.setNodeState,init:function(){e.prototype.init.apply(this,arguments);this.series.options.draggable&&!this.series.chart.styledMode&&(d(this,"mouseOver",function(){g.css(this.series.chart.container,{cursor:"move"})}),d(this,"mouseOut",function(){g.css(this.series.chart.container,{cursor:"default"})}));
return this},getDegree:function(){var a=this.isNode?this.linksFrom.length+this.linksTo.length:0;return 0===a?1:a},getLinkAttributes:function(){var a=this.series.options.link,c=this.options;return{"stroke-width":b(c.width,a.width),stroke:c.color||a.color,dashstyle:c.dashStyle||a.dashStyle,opacity:b(c.opacity,a.opacity,1)}},renderLink:function(){if(!this.graphic&&(this.graphic=this.series.chart.renderer.path(this.getLinkPath()).add(this.series.group),!this.series.chart.styledMode)){var a=this.series.pointAttribs(this);
this.graphic.attr(a);(this.dataLabels||[]).forEach(function(b){b&&b.attr({opacity:a.opacity})})}},redrawLink:function(){var a=this.getLinkPath();if(this.graphic){this.shapeArgs={d:a};if(!this.series.chart.styledMode){var b=this.series.pointAttribs(this);this.graphic.attr(b);(this.dataLabels||[]).forEach(function(a){a&&a.attr({opacity:b.opacity})})}this.graphic.animate(this.shapeArgs);this.plotX=(a[1]+a[4])/2;this.plotY=(a[2]+a[5])/2}},getMass:function(){var a=this.fromNode.mass,b=this.toNode.mass,
c=a+b;return{fromNode:1-a/c,toNode:1-b/c}},getLinkPath:function(){var a=this.fromNode,b=this.toNode;a.plotX>b.plotX&&(a=this.toNode,b=this.fromNode);return["M",a.plotX,a.plotY,"L",b.plotX,b.plotY]},isValid:function(){return!this.isNode||c(this.id)},remove:function(a,b){var c=this.series,d=c.options.nodes||[],e,g=d.length;if(this.isNode){c.points=[];[].concat(this.linksFrom).concat(this.linksTo).forEach(function(a){e=a.fromNode.linksFrom.indexOf(a);-1<e&&a.fromNode.linksFrom.splice(e,1);e=a.toNode.linksTo.indexOf(a);
-1<e&&a.toNode.linksTo.splice(e,1);f.prototype.removePoint.call(c,c.data.indexOf(a),!1,!1)});c.points=c.data.slice();for(c.nodes.splice(c.nodes.indexOf(this),1);g--;)if(d[g].id===this.options.id){c.options.nodes.splice(g,1);break}this&&this.destroy();c.isDirty=!0;c.isDirtyData=!0;a&&c.chart.redraw(a)}else c.removePoint(c.data.indexOf(this),a,b)},destroy:function(){this.isNode&&this.linksFrom.concat(this.linksTo).forEach(function(a){a.destroyElements&&a.destroyElements()});this.series.layout.removeElementFromCollection(this,
this.series.layout[this.isNode?"nodes":"links"]);return e.prototype.destroy.apply(this,arguments)}});""});l(k,"masters/modules/networkgraph.src.js",[],function(){})});
//# sourceMappingURL=networkgraph.js.map