<?php require('_common/_f.php'); ?>
<!DOCTYPE html>
<html>
<?php require('_common/head.php'); ?>

<body>
    <?php require('_common/header.php'); ?>
    <div class="main-column">
        <h3>Vista en detalle del recurso</h3>
        <?php if(isset($_SESSION['busqueda'])) {
            echo '<a href="busqueda.php">Ir a los resultados de busqueda</a>';
        } ?>
        <?php
        $iddocumento = isset($iets->get['iddocumento']) ? (int)$iets->get['iddocumento'] : 0;
        $documento = $iets->documento_detalle($iddocumento);

        if($iddocumento > 0 && isset($documento['iddocumento'])) { ?>
        <div class="label-group box-radius">
            <div class="one-third-col">
                <img src="<?php echo $documento['portada']; ?>" alt="<?php echo $documento['titulo']; ?>"
                    class="portada-bg" />
            </div>
            <div class="two-third-col">
                <div class="label-group">
                    <div>
                        <label>Tipo:</label>
                        <?php echo $tipos[$documento['tipo']]; ?>
                    </div>
                </div>
                <div class="label-group">
                    <div>
                        <label>Titulo:</label>
                        <?php echo $documento['titulo']; ?>
                    </div>
                </div>
                <?php if($documento['resumen'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Resumen:</label>
                        <?php echo $documento['resumen']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['tipo_ley_dec'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Tipo de ley o decreto:</label>
                        <?php echo $tipo_ley_dec[$documento['tipo_ley_dec']]; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['serie'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Serie:</label>
                        <?php echo $documento['serie']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['titulo_revista'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Titulo de la revista:</label>
                        <?php echo $documento['titulo_revista']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['issn_revista'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>ISSN:</label>
                        <?php echo $documento['issn_revista']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if(isset($documento['autor']) && count($documento['autor']) > 0) { ?>
                <div class="label-group">
                    <div>
                        <label>Autor:</label>
                        <?php foreach($documento['autor'] as $value) {
                                echo '<a href="busqueda.php?filtro=autor&valor=' . $value . '">' . $value . '</a>; ';
                            } ?>
                    </div>
                </div>
                <?php } ?>
                <?php if(isset($documento['autor_corporativo']) && count($documento['autor_corporativo']) > 0) { ?>
                <div class="label-group">
                    <div>
                        <label>Autor corporativo:</label>
                        <?php foreach($documento['autor_corporativo'] as $value) {
                                echo '<a href="busqueda.php?filtro=autor_corporativo&valor=' . $value . '">' . $value . '</a>; ';
                            } ?>
                    </div>
                </div>
                <?php } ?>
                <?php if(isset($documento['editor']) && count($documento['editor']) > 0) { ?>
                <div class="label-group">
                    <div>
                        <label>Editor:</label>
                        <?php foreach($documento['editor'] as $value) {
                                echo '<a href="busqueda.php?filtro=editor&valor=' . $value . '">' . $value . '</a>; ';
                            } ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['editorial'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Editorial:</label>
                        <?php echo $documento['editorial']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['isbn'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>ISBN:</label>
                        <?php echo $documento['isbn']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['year_publicacion'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Año de publicación (AAAA):</label>
                        <?php echo $documento['year_publicacion']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['suplemento'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Suplemento:</label>
                        <?php echo $documento['suplemento']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['volumen'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Volumen:</label>
                        <?php echo $documento['volumen']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['numero'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Número:</label>
                        <?php echo $documento['numero']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['pagina_inicial'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Pagina inicial:</label>
                        <?php echo $documento['pagina_inicial']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['pagina_final'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Pagina final:</label>
                        <?php echo $documento['pagina_final']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['edicion'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Edición:</label>
                        <?php echo $documento['edicion']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['numero_paginas'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Número de páginas:</label>
                        <?php echo $documento['numero_paginas']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['existencias'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Existencias:</label>
                        <?php echo $documento['existencias']; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['bd_bibliografica'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Base de datos bibliográfica:</label>
                        <?php echo $bd_bibliografica[$documento['bd_bibliografica']]; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['idioma'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Idioma:</label>
                        <?php echo $idioma[$documento['idioma']]; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['tipo_acceso'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Tipo de acceso:</label>
                        <?php echo $tipo_acceso[$documento['tipo_acceso']]; ?>
                    </div>
                </div>
                <?php } ?>
                <?php if($documento['disponibilidad'] != '') { ?>
                <div class="label-group">
                    <div>
                        <label>Tipo de acceso:</label>
                        <?php echo $disponibilidad[$documento['disponibilidad']]; ?>
                    </div>
                </div>
                <?php } ?>
            </div>
        </div>
        <div class="label-group box-radius box-shadow">
            <?php if(isset($documento['palabras_clave']) && count($documento['palabras_clave']) > 0) { ?>
            <div class="label-group">
                <div>
                    <label>Palabras clave:</label>
                    <ul>
                        <?php foreach($documento['palabras_clave'] as $value) {
                                echo '<li><a href="busqueda.php?filtro=palabras_clave&valor=' . $value . '">' . $value . '</a></li> ';
                            } ?>
                    </ul>
                </div>
            </div>
            <?php if($documento['coleccion'] != '') { ?>
            <div class="label-group">
                <div>
                    <label>Colección:</label>
                    <a
                        href="busqueda.php?filtro=coleccion&valor=<?php echo $documento['idcoleccion']; ?>"><?php echo $documento['coleccion']; ?></a>
                </div>
            </div>
            <?php } ?>
            <?php } ?>
            <?php } else { 
                $iets->header('busqueda.php', '?err=El documento no puede ser consultado.');
             } ?>
        </div>

    </div>
    <?php require('barra-documento.php'); ?>
    <?php require('_common/footer.php'); ?>
</body>

</html>