<?php require('_common/_f.php'); ?>
<!DOCTYPE html>
<html>
<?php require('_common/head.php'); ?>
<?php require('_common/auth.php'); ?>
<?php require('_common/admin.php'); ?>

<body>
    <?php require('_common/header.php'); ?>
    <div class="main-column">
        <?php echo $iets->formOpen('?saveColeccion'); ?>
        <h3><label id="titulo">Crear</label> colección:</h3>
        <div class="form-group">
            <div class="form-input two-col">
                <input type="hidden" name="idcoleccion" id="idcoleccion">
                <input type="text" name="coleccion" id="coleccion" class="input" placeholder="Nombre de la colección"
                    required>
            </div>
        </div>
        <div class="form-group">
            <input class="btn-guardar" type="submit" name="btn1" value="Guardar">
        </div>
        <?php echo $iets->formClose(); ?>
        <br />
        <h3>Lista de colecciones:</h3>
        <table id="datatable1" class="stripe compact row-border">
            <thead>
                <tr>
                    <th>Colección</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                foreach($iets->colecciones() as $idcoleccion => $coleccion) { ?>
                <tr>
                    <td><span><?php echo $coleccion['coleccion']; ?></span> </td>
                    <td><?php if ($coleccion['estado'] == 1) { ?>
                        <a href="javascript:void(0)" onclick="javascript:editarColeccion(this);"
                            data-idcoleccion="<?php echo $idcoleccion; ?>"
                            data-coleccion="<?php echo $coleccion['coleccion']; ?>">Editar</a>&nbsp;|&nbsp;
                        <?php } ?>
                        <a
                            href="?statusColeccion&idcoleccion=<?php echo $idcoleccion; ?>&estado=<?php echo $coleccion['estado']; ?>"><?php echo $coleccion['estado'] == 1 ? 'Deshabilitar' : 'Habilitar'; ?></a>
                    </td>
                </tr>
                <?php } ?>

            </tbody>
        </table>
    </div>
    <?php require('_common/footer.php'); ?>
</body>

</html>