<?php require('_common/_f.php'); ?>
<!DOCTYPE html>
<html>
<?php require('_common/head.php'); ?>

<body>
    <?php require('_common/header.php'); ?>
    <?php require('barra-filtros.php'); ?>
    <div class="main-column-filtros">
        <?php
        //echo '<div style="display:none;">'.var_dump($_SESSION).'</div>';
        $documentosTotalResultados = $iets->busqueda_resultados(true);
        $documentosResultados = $iets->busqueda_resultados();
        $documentosTotal = $iets->resumen_documentos(); ?>
        <h3>Resultados de búsqueda</h3>
        <p>Se encontraron <?php echo $documentosTotalResultados; ?> recursos de un total de
            <?php echo count($documentosTotal); ?> recursos registrados.</p>
        <?php
        foreach($documentosResultados as $documento) { ?>
        <div class="label-group box-radius">
            <div class="one-fifth-col">
                <img src="<?php echo $documento['portada']; ?>" alt="<?php echo $documento['titulo']; ?>"
                    class="portada-bg" />
            </div>
            <div class="two-fifth-col">
                <div class="label-group">
                    <label>Titulo:</label>
                    <?php echo $documento['titulo']; ?>
                </div>
                <div class="label-group">
                    <label>Año de publicación:</label>
                    <?php echo $documento['year_publicacion']; ?>
                </div>
                <?php if(isset($documento['autor']) && count($documento['autor']) > 0) { ?>
                <div class="label-group">
                    <div>
                        <label>Autor:</label>
                        <?php foreach($documento['autor'] as $value) {
                        echo '<a href="busqueda.php?filtro=autor&valor=' . $value . '">' . $value . '</a>; ';
                    } ?>
                    </div>
                </div>
                <?php } ?>
                <div class="label-group">
                    <a href="documento-detalle.php?iddocumento=<?php echo $documento['iddocumento']; ?>"
                        class="btn-guardar">Ver detalle</a>
                </div>
            </div>
        </div>
        <?php }  ?>
        <ul class="paginas box-radius">
            <?php
            $filtros = isset($iets->get['filtro']) ? '&filtro=' . $iets->get['filtro'] : '';
            $valor = isset($iets->get['valor']) ? '&valor=' . $iets->get['valor'] : '';

            //$params = 

            $limite = ceil($documentosTotalResultados / $iets->registrosPagina);
            
            for($a=0; $a<$limite; $a++) { ?>
            <li><a href="?offset=<?php echo $a . $filtros . $valor; ?>"><?php echo ($a + 1); ?></a></li>
            <?php } ?>
        </ul>
    </div>
    <?php require('_common/footer.php'); ?>
</body>

</html>