<?php require('_common/_f.php'); ?>
<!DOCTYPE html>
<html>
<?php require('_common/head.php'); ?>
<body>
    <?php require('_common/header.php'); ?>
    <div class="main-column">
        <h3>Biblioteca en cifras</h3>
        <div class="form-group">
            <div class="form-input two-col">
                <label>Seleccione el tipo de gráfico:
                    <select class="input" onchange="generarCifras(this.value);">
                        <option value="tipo" selected>Tipo de recurso</option>
                        <option value="year_publicacion">Fechas de publicación</option>
                        <option value="tipo_acceso">Tipo de acceso</option>
                        <option value="autores">Top autores</option>
                        <option value="palabras">Top palabras clave</option>
                        <option value="idioma">Top idioma</option>
                        <option value="iets">Producidos por IETS</option>
                    </select></label>
            </div>
        </div>
        <div class="label-group box-radius">
            <script src="js/highcharts.js"></script>
            <script src="js/modules/exporting.js"></script>
            <script src="js/modules/export-data.js"></script>
            <div class="form-group">
                <div class="form-input two-col">
                    <div id="highchartscontainer" style="min-width: 310px; height: 400px; max-width: 600px; margin: 0 auto"></div>
                </div>
            </div>
            <script>
            function generarCifras(tipo) {
                if(tipo == 'year_publicacion') {
                    <?php
                    $categories = array();
                    $valores = array();
                    foreach($iets->cifras('year_publicacion') as $year_publicacion => $valor) {
                        array_push($categories, $year_publicacion);
                        array_push($valores, $valor);
                    } ?>
                    Highcharts.chart('highchartscontainer', {
                        title: {
                            text: 'Fechas de publicación'
                        },
                        xAxis: {
                            categories: [<?php
                            $cont = 0;
                            foreach($categories as $value) {
                                echo ($cont == 0 ? '' : ',') . "'" . $value . "'";
                                $cont++;
                            } ?>]
                        },
                        plotOptions: {
                            line: {
                                dataLabels: {
                                    enabled: true
                                }
                            }
                        },
                        yAxis: {
                            title: {
                                text: 'Numero de recursos'
                            }
                        },
                        series: [{
                            showInLegend: false,
                            name: 'Numero de recursos',
                            data: [<?php
                            $cont = 0;
                            foreach($valores as $value) {
                                echo ($cont == 0 ? '' : ',') . $value;
                                $cont++;
                            } ?>]
                        }],
                        responsive: {
                            rules: [{
                                condition: {
                                    maxWidth: 500
                                },
                                chartOptions: {
                                    legend: {
                                        layout: 'horizontal',
                                        align: 'center',
                                        verticalAlign: 'bottom'
                                    }
                                }
                            }]
                        }
                    });

                } else if(tipo == 'tipo_acceso') {
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            plotBackgroundColor: null,
                            plotBorderWidth: null,
                            plotShadow: false,
                            type: 'pie'
                        },
                        title: {
                            text: 'Tipo de acceso'
                        },
                        tooltip: {
                            pointFormat: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                        },
                        plotOptions: {
                            pie: {
                                allowPointSelect: true,
                                cursor: 'pointer',
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                                }
                            }
                        },
                        series: [{
                            name: 'Brands',
                            colorByPoint: true,
                            data: [<?php
                                foreach($iets->cifras('tipo_acceso') as $tipo => $valor) {
                                    echo "{ name: '" . $tipo_acceso[$tipo] .  "', y: " . $valor . " },";
                                } ?>
                            ]
                        }]
                    });

                } else if(tipo == 'autores') {
                    <?php
                    $categories = array();
                    $valores = array();
                    foreach($iets->cifras_valores_multiples('autor') as $valor => $total) {
                        array_push($categories, $valor);
                        array_push($valores, $total);
                    } ?>
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            type: 'bar'
                        },
                        title: {
                            text: 'Top de autores'
                        },
                        xAxis: {
                            categories: [<?php
                                $cont = 0;
                                foreach($categories as $value) {
                                    echo ($cont == 0 ? '' : ',') . "'" . $value . "'";
                                    $cont++;
                                } ?>],
                            title: {
                                text: null
                            }
                        },
                        yAxis: {
                            min: 0,
                            title: {
                                text: 'Numero de recursos'
                            },
                            labels: {
                                overflow: 'justify'
                            }
                        },
                        plotOptions: {
                            bar: {
                                dataLabels: {
                                    enabled: true
                                }
                            }
                        },
                        credits: {
                            enabled: false
                        },
                        series: [{
                            showInLegend: false,
                            name: 'Numero de recursos',
                            data: [<?php
                                $cont = 0;
                                foreach($valores as $value) {
                                    echo ($cont == 0 ? '' : ',') . $value;
                                    $cont++;
                                } ?>]
                        }]
                    });

                } else if(tipo == 'palabras') {
                    <?php
                    $categories = array();
                    $valores = array();
                    foreach($iets->cifras_valores_multiples('palabras_clave') as $valor => $total) {
                        array_push($categories, $valor . ' ');
                        array_push($valores, $total);
                    } ?>
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            type: 'bar'
                        },
                        title: {
                            text: 'Top de autores'
                        },
                        xAxis: {
                            categories: [<?php
                                $cont = 0;
                                foreach($categories as $value) {
                                    echo ($cont == 0 ? '' : ',') . "'" . $value . "'";
                                    $cont++;
                                } ?>],
                            title: {
                                text: null
                            }
                        },
                        yAxis: {
                            min: 0,
                            title: {
                                text: 'Numero de recursos'
                            },
                            labels: {
                                overflow: 'justify'
                            }
                        },
                        plotOptions: {
                            bar: {
                                dataLabels: {
                                    enabled: true
                                }
                            }
                        },
                        credits: {
                            enabled: false
                        },
                        series: [{
                            showInLegend: false,
                            name: 'Numero de recursos',
                            data: [<?php
                                $cont = 0;
                                foreach($valores as $value) {
                                    echo ($cont == 0 ? '' : ',') . $value;
                                    $cont++;
                                } ?>]
                        }]
                    });

                } else if(tipo == 'idioma') {
                    <?php
                    $categories = array();
                    $valores = array();
                    foreach($iets->cifras('idioma') as $valor => $total) {
                        array_push($categories, $idioma[$valor]);
                        array_push($valores, $total);
                    } ?>
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            type: 'bar'
                        },
                        title: {
                            text: 'Top de autores'
                        },
                        xAxis: {
                            categories: [<?php
                                $cont = 0;
                                foreach($categories as $value) {
                                    echo ($cont == 0 ? '' : ',') . "'" . $value . "'";
                                    $cont++;
                                } ?>],
                            title: {
                                text: null
                            }
                        },
                        yAxis: {
                            min: 0,
                            title: {
                                text: 'Numero de recursos'
                            },
                            labels: {
                                overflow: 'justify'
                            }
                        },
                        plotOptions: {
                            bar: {
                                dataLabels: {
                                    enabled: true
                                }
                            }
                        },
                        credits: {
                            enabled: false
                        },
                        series: [{
                            showInLegend: false,
                            name: 'Numero de recursos',
                            data: [<?php
                                $cont = 0;
                                foreach($valores as $value) {
                                    echo ($cont == 0 ? '' : ',') . $value;
                                    $cont++;
                                } ?>]
                        }]
                    });

                } else if(tipo == 'iets') {
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            plotBackgroundColor: null,
                            plotBorderWidth: null,
                            plotShadow: false,
                            type: 'pie'
                        },
                        title: {
                            text: 'Tipo de recursos'
                        },
                        tooltip: {
                            pointFormat: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                        },
                        plotOptions: {
                            pie: {
                                allowPointSelect: true,
                                cursor: 'pointer',
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                                }
                            }
                        },
                        series: [{
                            name: 'Brands',
                            colorByPoint: true,
                            data: [<?php
                                foreach($iets->cifras_iets() as $tipo => $valor) {
                                    echo "{ name: '" . $tipo .  "', y: " . $valor . " },";
                                } ?>
                            ]
                        }]
                    });

                } else {
                    Highcharts.chart('highchartscontainer', {
                        chart: {
                            plotBackgroundColor: null,
                            plotBorderWidth: null,
                            plotShadow: false,
                            type: 'pie'
                        },
                        title: {
                            text: 'Tipo de recursos'
                        },
                        tooltip: {
                            pointFormat: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                        },
                        plotOptions: {
                            pie: {
                                allowPointSelect: true,
                                cursor: 'pointer',
                                dataLabels: {
                                    enabled: true,
                                    format: '{point.name}: {point.y} ({point.percentage:.1f}%)'
                                }
                            }
                        },
                        series: [{
                            name: 'Brands',
                            colorByPoint: true,
                            data: [<?php
                                foreach($iets->cifras('tipo') as $tipo => $valor) {
                                    echo "{ name: '" . $tipos[$tipo] .  "', y: " . $valor . " },";
                                } ?>
                            ]
                        }]
                    });
                }
            }
            generarCifras('tipo');
            </script>
        </div>
    </div>
    <?php require('barra-lateral.php'); ?>
    <?php require('_common/footer.php'); ?>
</body>

</html>