<?php session_start();
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require('_common/_db.php');

class IETS extends mysqliConn {
    public $get;
    public $post;
    public $session;
    private $mysqli;
    private $token;

    public $usuarios;
    public $years = array();
    public $tipos_documentos = array();
    public $colecciones = array();
    public $dir_portadas = 'portadas/';
    public $dir_archivos = 'archivos/';
    public $registrosPagina = 10;

    public $isadmin;
    private $idusuario = '';
    public $email = '';
    public $nombres = '';
    public $apellidos = '';
    public $estado = '';
    public $rol = '';
    private $cadenalogin = '';

    public $checkToken;
    public $loginCheck;

    function __construct($get, $post) {
        $this->mysqli = parent::mysqliConn();
        $this->get = $this->cleanvar($get);
        $this->post = $this->cleanvar($post);
        $this->session = $this->cleanvar($_SESSION);

        $this->token = $this->generateToken();
        $this->checkToken = $this->checkToken();

        $this->loginCheck = $this->loginCheck();

        $this->isadmin = $this->loginCheck && isset($this->rol) && $this->rol == 1;

        $this->redirect();
    }

    public function cleanvar($var) {
        $array = array();
        if(is_array($var)) {
            foreach($var as $key => $value) {
                $array[$key] = $this->cleanvar($value);
            }
        } else {
            return $this->mysqli->real_escape_string($var);
        }
        return $array;
    }

    public function usuarios() {
        $return = array();
        if($this->isadmin) {
            $stmt = $this->mysqli->prepare("SELECT idusuario, nombres, apellidos, email, estado, rol FROM usuario ORDER BY apellidos ASC");
            $stmt->execute();
            $result = $stmt->get_result();
            if($result->num_rows > 0) {
                while($row = $result->fetch_assoc()) {
                    array_push($return, array('idusuario' => $row['idusuario'],
                                            'nombres' => $row['nombres'],
                                            'apellidos' => $row['apellidos'],
                                            'email' => $row['email'],
                                            'estado' => $row['estado'],
                                            'rol' => $row['rol']));
                }
            }
            $stmt->close();
        }
        return $return;

    }

    public function colecciones() {
        $return = array();
        
        $stmt = $this->mysqli->prepare("SELECT * FROM coleccion ORDER BY coleccion ASC");
        $stmt->execute();
        $result = $stmt->get_result();
        if($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                if($this->isadmin || $row['estado'] == 1) {
                    $return[$row['idcoleccion']] = array(
                                            'coleccion' => $row['coleccion'],
                                            'estado' => $row['estado']);

                }
            }
        }
        $stmt->close();
        
        return $return;

    }

    public function resumen_documentos() {
        $return = array();
        
        $stmt = $this->mysqli->prepare("SELECT documentos.*, coleccion.coleccion FROM documentos JOIN coleccion ON coleccion.idcoleccion = documentos.idcoleccion ORDER BY titulo ASC");
        $stmt->execute();
        $result = $stmt->get_result();
        if($result->num_rows > 0) {
            while($row = $result->fetch_assoc()) {
                if($this->isadmin || 
                    $row['tipo_acceso'] == 'lib' || 
                    ($this->loginCheck && $this->rol == 0 && $row['tipo_acceso'] != 'solo_par_adm')) {
                    $return[$row['iddocumento']] = array(
                                            'tipo' => $row['tipo'],
                                            'titulo' => $row['titulo'],
                                            'year_publicacion' => $row['year_publicacion'],
                                            'tipo_acceso' => $row['tipo_acceso'],
                                            'portada' => $row['portada'],
                                            'coleccion' => $row['coleccion']);

                    $sql = 'SELECT * FROM documento_valores_multiples WHERE iddocumento = ' . $row['iddocumento'];
                    $consulta = $this->mysqli->query($sql) or exit($this->mysqli->error);
                    while($resultados = $consulta->fetch_array()) {
                        if(!isset($return[$row['iddocumento']][$resultados['tipo']])) {
                            $return[$row['iddocumento']][$resultados['tipo']] = array();
                        }
                        array_push($return[$row['iddocumento']][$resultados['tipo']], $resultados['valor']);
                        
                    }
                }
            }
        }
        $stmt->close();
        return $return;

    }

    public function cifras($columna) {
        $return = array();

        $sql = 'SELECT ' . $columna . ', COUNT(' . $columna . ') AS total FROM documentos GROUP BY ' . $columna . '';
        $resultados = $this->mysqli->query($sql);
        
        while($fila = $resultados->fetch_array()) {
            $array[$fila[$columna]] = $fila['total'];
        }

        return $array;
    }

    public function cifras_valores_multiples($tipo, $limite = 10) {
        $return = array();

        $sql = 'SELECT valor, COUNT(valor) AS total FROM documento_valores_multiples WHERE tipo = "' . $tipo . '" GROUP BY valor ORDER BY total DESC LIMIT ' . $limite;
        $resultados = $this->mysqli->query($sql);
        
        while($fila = $resultados->fetch_array()) {
            $array[$fila['valor']] = $fila['total'];
        }

        return $array;
    }

    public function cifras_iets() {
        $return = array();

        $sql = 'SELECT iddocumento FROM documentos';
        $resultados = $this->mysqli->query($sql);
        $total = $resultados->num_rows;

        $sql = 'SELECT COUNT(documentos.iddocumento) AS TOTAL FROM  documentos JOIN documento_valores_multiples ON documento_valores_multiples.iddocumento = documentos.iddocumento WHERE documento_valores_multiples.valor LIKE "%iets%" GROUP BY documentos.iddocumento';
        $resultados = $this->mysqli->query($sql);
        $iets = $resultados->num_rows;

        $otros = ($total - $iets);

        return array('IETS' => $iets, 'Otros' => $otros);
    }

    public function documento_detalle($iddocumento = 0) {
        $return = array();

        $stmt = $this->mysqli->prepare("SELECT documentos.*, coleccion.coleccion FROM documentos JOIN coleccion ON coleccion.idcoleccion = documentos.idcoleccion WHERE documentos.iddocumento = ?");
        $stmt->bind_param('i', $iddocumento);
        $stmt->execute();
        $result = $stmt->get_result();
        if($result->num_rows == 1) {
            while($row = $result->fetch_assoc()) {
                if($this->isadmin || 
                    $row['tipo_acceso'] == 'lib' || 
                    ($this->loginCheck && $this->rol == 0 && $row['tipo_acceso'] != 'solo_par_adm')) {
                    $return = array('iddocumento' => $row['iddocumento'],
                                            'tipo' => $row['tipo'],
                                            'titulo' => $row['titulo'],
                                            'tipo_ley_dec' => $row['tipo_ley_dec'],
                                            'serie' => $row['serie'],
                                            'titulo_revista' => $row['titulo_revista'],
                                            'issn_revista' => $row['issn_revista'],
                                            'editorial' => $row['editorial'],
                                            'isbn' => $row['isbn'],
                                            'year_publicacion' => $row['year_publicacion'],
                                            'suplemento' => $row['suplemento'],
                                            'volumen' => $row['volumen'],
                                            'numero' => $row['numero'],
                                            'pagina_inicial' => $row['pagina_inicial'],
                                            'pagina_final' => $row['pagina_final'],
                                            'edicion' => $row['edicion'],
                                            'numero_paginas' => $row['numero_paginas'],
                                            'existencias' => $row['existencias'],
                                            'resumen' => $row['resumen'],
                                            'bd_bibliografica' => $row['bd_bibliografica'],
                                            'portada' => $row['portada'],
                                            'idioma' => $row['idioma'],
                                            'tipo_acceso' => $row['tipo_acceso'],
                                            'disponibilidad' => $row['disponibilidad'],
                                            'idcoleccion' => $row['idcoleccion'],
                                            'archivo' => $row['archivo'],
                                            'coleccion' => $row['coleccion']);

                    $sql = 'SELECT * FROM documento_valores_multiples WHERE iddocumento = ' . $row['iddocumento'];
                    $consulta = $this->mysqli->query($sql) or exit($this->mysqli->error);
                    while($resultados = $consulta->fetch_array()) {
                        if(!isset($return[$resultados['tipo']])) {
                            $return[$resultados['tipo']] = array();
                        }
                        array_push($return[$resultados['tipo']], $resultados['valor']);
                        
                    }
                }
            }
        }
        $stmt->close();
        
        return $return;
                
    }
    
    protected function saveColeccion() {
        if($this->isadmin) {
            $idcoleccion = isset($this->post['idcoleccion']) ? $this->post['idcoleccion'] : 0;
            $coleccion = isset($this->post['coleccion']) ? $this->post['coleccion'] : '';
    
            if($coleccion != '') {
                if($idcoleccion > 0) {
                    if($stmt = $this->mysqli->prepare("UPDATE coleccion SET coleccion = ? WHERE idcoleccion = ?")) {
                        $stmt->bind_param("si", $coleccion,  $idcoleccion);
                        $stmt->execute();
                        $this->header('', '?suc=Colección editada.');
    
                    } else {
                        $this->header('', '?err=Error editando coleccion.' . $this->mysqli->error);
    
                    }
                } else {
                    if($stmt = $this->mysqli->prepare("INSERT INTO coleccion(coleccion) VALUES (?)")) {
                        $stmt->bind_param("s", $coleccion);
                        $stmt->execute();
                        $this->header('', '?suc=Colección creada.');
    
                    } else {
                        $this->header('', '?err=Error creando coleccion.' . $this->mysqli->error);
    
                    }
                }
            }
        }
    }

    protected function statusColeccion() {
        if($this->isadmin) {
            $idcoleccion = isset($this->get['idcoleccion']) ? $this->get['idcoleccion'] : 0;
            $estado = isset($this->get['estado']) ? $this->get['estado'] : -1;

            if($idcoleccion > 0 && ($estado == 0 || $estado == 1)) {
                $estado = $estado == 0 ? 1 : 0;

                if($stmt = $this->mysqli->prepare("UPDATE coleccion SET estado = ? WHERE idcoleccion = ?")) {
                    $stmt->bind_param("ii", $estado, $idcoleccion);
                    $stmt->execute();
                    $this->header('', '?suc=Estado de la colección cambiado.');

                } else {
                    $this->header('', '?err=Error cambiando estado de la colección.' . $this->mysqli->error);

                }
            }
        }
        $this->header('', '?err=Error cambiando estado del usuario.');
    }

    protected function saveUser() {
        if($this->isadmin) {
            $idusuario = isset($this->post['idusuario']) ? $this->post['idusuario'] : 0;
            $nombres = isset($this->post['nombres']) ? $this->post['nombres'] : '';
            $apellidos = isset($this->post['apellidos']) ? $this->post['apellidos'] : '';
            $email = isset($this->post['email']) ? $this->post['email'] : '';
            $password = isset($this->post['password']) ? sha1($this->post['password']) : '';
            $estado = 1;
            $rol = isset($this->post['rol']) ? $this->post['rol'] : 0;
    
            if($nombres != '' && $apellidos != '' && $email != '') { //   && $password != ''
                if($idusuario > 0) {
                    if($stmt = $this->mysqli->prepare("UPDATE usuario SET nombres = ?, apellidos = ?, email = ?, rol = ? WHERE idusuario = ?")) {
                        $stmt->bind_param("sssii", $nombres, $apellidos, $email, $rol,  $idusuario);
                        $stmt->execute();
                        $this->header('', '?suc=Usuario editado.');
    
                    } else {
                        $this->header('', '?err=Error editando usuario.' . $this->mysqli->error);
    
                    }
                } else {
                    if($stmt = $this->mysqli->prepare("INSERT INTO usuario(nombres, apellidos, email, clave, estado, rol) VALUES (?, ?, ?, ?, ?, ?)")) {
                        $stmt->bind_param("ssssii", $nombres, $apellidos, $email, $password, $estado, $rol);
                        $stmt->execute();
                        $this->header('', '?suc=Usuario creado.');
    
                    } else {
                        $this->header('', '?err=Error creando usuario.' . $this->mysqli->error);
    
                    }
                }
            }
        }
    }

    protected function statusUser() {
        if($this->isadmin) {
            $idusuario = isset($this->get['idusuario']) ? $this->get['idusuario'] : 0;
            $estado = isset($this->get['estado']) ? $this->get['estado'] : -1;

            if($idusuario > 0 && ($estado == 0 || $estado == 1)) {
                $estado = $estado == 0 ? 1 : 0;

                if($stmt = $this->mysqli->prepare("UPDATE usuario SET estado = ? WHERE idusuario = ?")) {
                    $stmt->bind_param("ii", $estado, $idusuario);
                    $stmt->execute();
                    $this->header('', '?suc=Estado del usuario cambiado.');

                } else {
                    $this->header('', '?err=Error cambiando estado del usuario usuario.' . $this->mysqli->error);

                }
            }
        }
        $this->header('', '?err=Error cambiando estado del usuario usuario.');
    }

    protected function saveDocumento() {
        if($this->isadmin) {
            $err = '';

            $iddocumento = isset($this->post['iddocumento']) ? $this->post['iddocumento'] : '';
            $tipo = isset($this->post['tipo']) ? $this->post['tipo'] : '';
            $titulo = isset($this->post['titulo']) ? $this->post['titulo'] : '';
            $tipo_ley_dec = isset($this->post['tipo_ley_dec']) ? $this->post['tipo_ley_dec'] : '';
            $serie = isset($this->post['serie']) ? $this->post['serie'] : '';
            $titulo_revista = isset($this->post['titulo_revista']) ? $this->post['titulo_revista'] : '';
            $issn_revista = isset($this->post['issn_revista']) ? $this->post['issn_revista'] : '';
            $contautor = isset($this->post['contautor']) ? $this->post['contautor'] : 0;
            $arrayautor = array();
            for($a=1; $a<=$contautor; $a++) {
                $autor = isset($this->post['autor'.$a]) ? $this->post['autor'.$a] : '';
                if($autor != '') {
                    array_push($arrayautor, $autor);
                }
            }
            $contautor_corporativo = isset($this->post['contautor_corporativo']) ? $this->post['contautor_corporativo'] : '';
            $arrayautor_corporativo = array();
            for($a=1; $a<=$contautor_corporativo; $a++) {
                $autor_corporativo = isset($this->post['autor_corporativo'.$a]) ? $this->post['autor_corporativo'.$a] : '';
                if($autor_corporativo != '') {
                    array_push($arrayautor_corporativo, $autor_corporativo);
                }
            }
            $conteditor = isset($this->post['conteditor']) ? $this->post['conteditor'] : '';
            $arrayeditor = array();
            for($a=1; $a<=$conteditor; $a++) {
                $editor = isset($this->post['editor'.$a]) ? $this->post['editor'.$a] : '';
                if($editor != '') {
                    array_push($arrayeditor, $editor);
                }
            }
            $editorial = isset($this->post['editorial']) ? $this->post['editorial'] : '';
            $isbn = isset($this->post['isbn']) ? $this->post['isbn'] : '';
            $year_publicacion = isset($this->post['year_publicacion']) ? $this->post['year_publicacion'] : '';
            $suplemento = isset($this->post['suplemento']) ? $this->post['suplemento'] : '';
            $volumen = isset($this->post['volumen']) ? $this->post['volumen'] : '';
            $numero = isset($this->post['numero']) ? $this->post['numero'] : '';
            $pagina_inicial = isset($this->post['pagina_inicial']) ? $this->post['pagina_inicial'] : '';
            $pagina_final = isset($this->post['pagina_final']) ? $this->post['pagina_final'] : '';
            $edicion = isset($this->post['edicion']) ? $this->post['edicion'] : '';
            $numero_paginas = isset($this->post['numero_paginas']) ? $this->post['numero_paginas'] : '';
            $existencias = isset($this->post['existencias']) ? $this->post['existencias'] : '';
            $resumen = isset($this->post['resumen']) ? $this->post['resumen'] : '';
            $bd_bibliografica = isset($this->post['bd_bibliografica']) ? $this->post['bd_bibliografica'] : '';
            $portadaCheck = isset($_FILES['portada']) ? true : '';
            $portada = '';
            if($portadaCheck === true && isset($_FILES["portada"]["name"]) && $_FILES["portada"]["name"] != '') { //mt_rand(100000000,999999999)
                $portada_origen = basename($_FILES["portada"]["name"]);
                $portada_extension = strtolower(pathinfo($portada_origen,PATHINFO_EXTENSION));
                $portada_destino = $this->dir_portadas . date('YmdHis_') . mt_rand(1000000000, 9999999999) . '.' . $portada_extension;
                $portada_check = getimagesize($_FILES["portada"]["tmp_name"]);
                if($portada_check !== false) {
                    if(move_uploaded_file($_FILES["portada"]["tmp_name"], $portada_destino)) {
                        $portada = $portada_destino;
                    } else {
                        $err .= 'Error subiendo imagen de portada. ';
                    }
                }
            }
            $idioma = isset($this->post['idioma']) ? $this->post['idioma'] : '';
            $contpalabras_clave = isset($this->post['contpalabras_clave']) ? $this->post['contpalabras_clave'] : '';
            $arraypalabras_clave = array();
            for($a=1; $a<=$contpalabras_clave; $a++) {
                $palabras_clave = isset($this->post['palabras_clave'.$a]) ? $this->post['palabras_clave'.$a] : '';
                if($palabras_clave != '') {
                    array_push($arraypalabras_clave, $palabras_clave);
                }
            }
            $tipo_acceso = isset($this->post['tipo_acceso']) ? $this->post['tipo_acceso'] : '';
            $disponibilidad = isset($this->post['disponibilidad']) ? $this->post['disponibilidad'] : '';
            $archivoInput = 'archivo' . $disponibilidad;
            $archivo = isset($this->post[$archivoInput]) ? $this->post[$archivoInput] : '';

      

            if($disponibilidad == 'dig' || $disponibilidad == 'dig_y_fis') {
                $archivoCheck = isset($_FILES[$archivoInput]) ? true : '';
                $archivo = '';
                if($archivoCheck === true && isset($_FILES[$archivoInput]["name"]) && $_FILES[$archivoInput]["name"] != '') { //mt_rand(100000000,999999999)
                    $archivo_origen = basename($_FILES[$archivoInput]["name"]);
                    $archivo_extension = strtolower(pathinfo($archivo_origen,PATHINFO_EXTENSION));
                    $archivo_destino = $this->dir_archivos . date('YmdHis_') . mt_rand(1000000000, 9999999999) . '.' . $archivo_extension;

                        if(move_uploaded_file($_FILES[$archivoInput]["tmp_name"], $archivo_destino)) {
                            $archivo = $archivo_destino;
                        } else {
                            $err .= 'Error subiendo archivo. ';
                        }
                    
                }
            }
            
            $idcoleccion = isset($this->post['idcoleccion']) ? $this->post['idcoleccion'] : '';

            $valores_multiples = array('autor' => $arrayautor, 'autor_corporativo' => $arrayautor_corporativo, 'editor' => $arrayeditor, 'palabras_clave' => $arraypalabras_clave);

            if($tipo != '' && $titulo != '' && $year_publicacion != '' && $tipo_acceso != '' && $disponibilidad != '' && $idcoleccion != '') {
                if($iddocumento > 0) {
                    if($stmt = $this->mysqli->prepare("UPDATE documentos SET tipo = ?, titulo = ?, tipo_ley_dec = ?, serie = ?, titulo_revista = ?, issn_revista = ?, editorial = ?, isbn = ?, year_publicacion = ?, suplemento = ?, volumen = ?, numero = ?, pagina_inicial = ?, pagina_final = ?, edicion = ?, numero_paginas = ?, existencias = ?, resumen = ?, bd_bibliografica = ?, idioma = ?, tipo_acceso = ?, disponibilidad = ?, idcoleccion = ? WHERE iddocumento = ?")) {
                        $stmt->bind_param("ssssssssisssiisiisssssii", $tipo, $titulo, $tipo_ley_dec, $serie, $titulo_revista, $issn_revista, $editorial, $isbn, $year_publicacion, $suplemento, $volumen, $numero, $pagina_inicial, $pagina_final, $edicion, $numero_paginas, $existencias, $resumen, $bd_bibliografica, $idioma, $tipo_acceso, $disponibilidad, $idcoleccion, $iddocumento);
                        $stmt->execute();

                        $sql = 'DELETE FROM documento_valores_multiples WHERE iddocumento = ' . $iddocumento;
                        $this->mysqli->query($sql) or exit($this->mysqli->error);
                        foreach($valores_multiples as $tipo => $array) {
                            foreach($array as $value) {
                                if($stmt = $this->mysqli->prepare("INSERT INTO documento_valores_multiples(iddocumento, tipo, valor) VALUES (?, ?, ?)")) {
                                    $stmt->bind_param("iss", $iddocumento, $tipo, $value);
                                    $stmt->execute();
    
                                } else {
                                    $err .= 'Error creando ' . $tipo . '. ';
    
                                }
                            }

                        }

                        if($portada != '') {
                            if($stmt = $this->mysqli->prepare("UPDATE documentos SET portada = ? WHERE iddocumento = ?")) {
                                $stmt->bind_param("si", $portada, $iddocumento);
                                $stmt->execute();
            
                            }
                        }

                        if($archivo != '') {
                            if($stmt = $this->mysqli->prepare("UPDATE documentos SET archivo = ? WHERE iddocumento = ?")) {
                                $stmt->bind_param("si", $archivo, $iddocumento);
                                $stmt->execute();
            
                            }
                        }

                        $this->header('inventario.php', '?suc=Documento actualizado.');
    
                    } else {
                        $this->header('', '?err=Error actualizando documento.' . $this->mysqli->error);
    
                    }

                } else {
                    if($stmt = $this->mysqli->prepare("INSERT INTO documentos(tipo, titulo, tipo_ley_dec, serie, titulo_revista, issn_revista, editorial, isbn, year_publicacion, suplemento, volumen, numero, pagina_inicial, pagina_final, edicion, numero_paginas, existencias, resumen, bd_bibliografica, portada, idioma, tipo_acceso, disponibilidad, archivo, idcoleccion) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)")) {
                        $stmt->bind_param("ssssssssisssiisiisssssssi", $tipo, $titulo, $tipo_ley_dec, $serie, $titulo_revista, $issn_revista, $editorial, $isbn, $year_publicacion, $suplemento, $volumen, $numero, $pagina_inicial, $pagina_final, $edicion, $numero_paginas, $existencias, $resumen, $bd_bibliografica, $portada, $idioma, $tipo_acceso, $disponibilidad, $archivo, $idcoleccion);
                        $stmt->execute();
                        $iddocumento = $stmt->insert_id;

                        foreach($valores_multiples as $tipo => $array) {
                            foreach($array as $value) {
                                if($stmt = $this->mysqli->prepare("INSERT INTO documento_valores_multiples(iddocumento, tipo, valor) VALUES (?, ?, ?)")) {
                                    $stmt->bind_param("iss", $iddocumento, $tipo, $value);
                                    $stmt->execute();
    
                                } else {
                                    $err .= 'Error creando ' . $tipo . '. ';
    
                                }
                            }

                        }
                        
                        $this->header('inventario.php', '?suc=Documento creado.' . ($err != '' ? '&err=' . $err : ''));
    
                    } else {
                        $this->header('', '?err=Error creando documento.' . $this->mysqli->error);
    
                    }
                }
            } else {
                echo 'tipo:' . $tipo . '<br />titulo:' . $titulo . '<br />year_publicacion:' . $year_publicacion . '<br />tipo_acceso:' . $tipo_acceso . '<br />disponibilidad:' . $disponibilidad . '<br />idcoleccion:' . $idcoleccion . '<br />';
                exit;
            }
        }
    }
    
    /* START - Login functions */
    private function loginHandler() {
        $captcha = isset($this->post['captcha']) ? hash('sha512', $this->mysqli->real_escape_string($this->post['captcha'])) : '';

        if($this->checkToken) {
            if(isset($_SESSION['captcha'], $captcha) && $captcha != '' && hash_equals($_SESSION['captcha'], $captcha)) {
                $email = isset($this->post['email']) && filter_var($this->post['email'], FILTER_VALIDATE_EMAIL) ? $this->post['email'] : '';
                $password = isset($this->post['password']) ? sha1($this->post['password']) : '';

                if ($stmt = $this->mysqli->prepare('SELECT idusuario, nombres, apellidos, clave, rol, estado FROM usuario WHERE email = ? LIMIT 1')) {
                    $stmt->bind_param('s', $email);
                    $stmt->execute();
                    $stmt->store_result();
                    $stmt->bind_result($idusuario, $nombres, $apellidos, $clave, $rol, $estado);
                    $stmt->fetch();

                    if ($stmt->num_rows == 1) {
                        if ($this->checkBrute($idusuario)) {
                            $this->header('', '?err=Ha hecho mas de 5 intentos de inicio de sesión en los últimos 30 minutos. Debe esperar una hora para ser habilitado de nuevo o intente recuperar su contraseña.');
                            
                        } else {
                            if (hash_equals($clave, $password)) {
                                if($estado == 1) {
                                    $user_browser = $_SERVER['HTTP_USER_AGENT'] . $this->userIp();

                                    $_SESSION['idusuario'] = $idusuario;
                                    $_SESSION['email'] = $email;
                                    $_SESSION['nombres'] = $nombres;
                                    $_SESSION['apellidos'] = $apellidos;
                                    $_SESSION['rol'] = $rol;
                                    $_SESSION['estado'] = $estado;
                                    $_SESSION['cadenalogin'] = hash('sha512', $password . $user_browser);

                                    $sql = 'INSERT INTO sesion(idusuario, cadenalogin) VALUES (' . $idusuario . ', "' . $_SESSION['cadenalogin'] . '")';

                                    $this->mysqli->query($sql) or exit($this->mysqli->error);
                                    $this->header('index.php', '?suc=Inicio de sesión correcto.');
            
                                } else {
                                    $this->header('', '?err=Su usuario ha sido desactivado. Contacte al administrador.');

                                }

                            } else {
                                $this->mysqli->query('INSERT INTO intentossesion(idusuario) VALUES ("' . $idusuario . '")') or exit($this->mysqli->error);
                                $this->header('', '?err=La contraseña no es correcta. Intente de nuevo.');
                            }
                        }
                    } else {
                        $this->header('', '?err=El correo electrónico no esta registrado.');

                    }
                } else {
                    echo $this->mysqli->error;
                    exit;
                }
            } else {
                $this->header('', '?err=El código de la imagen no es correcto. Intente de nuevo.');
                
            }
        } else {
            $this->header('', '?err=La validación del formulario no ha sido exitosa. Intente de nuevo.');

        }
        $this->header('', '?err=Error desconocido');
        
    }

    private function logoutHandler() {
        if ($stmt = $this->mysqli->prepare('SELECT idsesion FROM sesion WHERE idusuario = ? AND horafin IS NULL')) {
            $stmt->bind_param('i', $this->idusuario);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows >= 1) {
                $stmt->bind_result($idsesion);
            
                while($stmt->fetch()) {
                    $this->mysqli->query('UPDATE sesion SET horafin = now() WHERE idusuario = ' . $this->idusuario) or exit($this->mysqli->error);
                }
            }
            $stmt->close();
        }

        $_SESSION = array();

        session_unset();
        session_destroy(); 

        $this->header('', '?suc=Ha cerrado sesión.');
        
    }

    private function recoverPassword() {
        if($this->checkToken) {
            $email = isset($this->post['email']) && filter_var($this->post['email'], FILTER_VALIDATE_EMAIL) ? $this->post['email'] : '';
            $codigo = isset($this->post['codigo']) ? hash('sha512', $this->post['codigo']) : 'null';
            $password = sha1(isset($this->post['password']) ? $this->post['password'] : 'null');
            $password2 = sha1(isset($this->post['password2']) ? $this->post['password2'] : 'null2');
            
            if($email != '') {
                if ($stmt = $this->mysqli->prepare('SELECT idusuario, estado FROM usuario WHERE email = ? LIMIT 1')) {
                    $stmt->bind_param('s', $email);
                    $stmt->execute();
                    $stmt->store_result();
                    $stmt->bind_result($idusuario, $estado);
                    $stmt->fetch();

                    if ($stmt->num_rows == 1) {
                        if($estado == 1) {
                            if($codigo != 'null') {
                                if ($stmt = $this->mysqli->prepare('SELECT secreto FROM recuperarclave WHERE idusuario = ? LIMIT 1')) {
                                    $stmt->bind_param('i', $idusuario);
                                    $stmt->execute();
                                    $stmt->store_result();
                                    $stmt->bind_result($secreto);
                                    $stmt->fetch();
                                    
                                    $sql = 'DELETE FROM recuperarclave WHERE idusuario = ' . $idusuario;
                                    $this->mysqli->query($sql) or exit($this->mysqli->error);

                                    if(hash_equals($codigo, $secreto)) {
                                        if($password == $password2) {
                                            $sql = 'UPDATE usuario SET clave = "' . $password . '" WHERE idusuario = ' . $idusuario;
                                            $this->mysqli->query($sql) or exit($this->mysqli->error);
                                            
                                            $sql = 'DELETE FROM intentossesion WHERE idusuario = ' . $idusuario;
                                            $this->mysqli->query($sql) or exit($this->mysqli->error);

                                            $this->header('login.php', '?suc=Ha cambiado su contraseña, inicie sesión.');
                                        }
                                        $this->header('', '?err=Las contraseñas no coinciden, recupere su contraseña de nuevo.');

                                    }
                                }
                                
                                $this->header('', '?err=Código invalido, recupere su contraseña de nuevo.');
    
                            } else {
                                $secret = mt_rand(100001, 999999);
                                $hashsecret = hash('sha512', $secret);
    
                                $sql = 'INSERT INTO recuperarclave(idusuario, secreto) VALUES (' . $idusuario . ', "' . $hashsecret . '")';
                                $this->mysqli->query($sql) or exit($this->mysqli->error);
                                
                                require 'PHPMailer/Exception.php';
                                require 'PHPMailer/PHPMailer.php';
                                require 'PHPMailer/SMTP.php';
    
                                $mail = new PHPMailer(true);
    
                                try {
                                    $mail->isSMTP();                                            // Set mailer to use SMTP
                                    $mail->Host       = 'mail.ascofame.org.co';                 // Specify main and backup SMTP servers
                                    $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
                                    $mail->Username   = 'info@ascofame.org.co';                 // SMTP username
                                    $mail->Password   = '*3202283620*';                         // SMTP password
                                    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;         // Enable TLS encryption, `PHPMailer::ENCRYPTION_SMTPS` also accepted
                                    $mail->Port       = 465;                                    // TCP port to connect to
                                    $mail->CharSet    = 'UTF-8';
    
                                    //Recipients
                                    $mail->setFrom('info@ascofame.org.co');
                                    $mail->addAddress($email);     // Add a recipient
                                    //$mail->addBCC('sistemas@ascofame.org.co');
    
                                    // Content
                                    $mail->isHTML(true);                                  // Set email format to HTML
                                    $mail->Subject = 'Catalogo - Recuperar contraseña';
                                    $mail->Body    = 'Ha solicitado recuperar su contraseña. Ingrese el código inferior en la pagina para continuar:<br /><br /><strong>'.$secret.'</strong><br /><br />Catalogo IETS';
                                    $mail->AltBody = 'Ha solicitado recuperar su contraseña. Ingrese el código inferior en la pagina para continuar:'.$secret;
    
                                    $mail->send();
                                    $this->header('', '?setPassword&suc=Se ha enviado un código de verificación a su correo, no cierre esta ventana.');
    
                                } catch (Exception $e) {
                                    $this->header('', '?err=Error. Contacte el administrador.' . $mail->ErrorInfo);
                                    
                                }
                            }

                        } else {
                            $this->header('', '?err=Su usuario ha sido desactivado. Contacte al administrador.');

                        }
                        
                        return false;
                    } else {
                        $this->header('', '?err=El correo electrónico no esta registrado. Intente de nuevo.');
                                     
                    }
                } else {
                    $this->header('', '?err=' . $this->mysqli->error);
                    
                }
            }
        } else {
            $this->header('', '?err=La validación del formulario no ha sido exitosa. Intente de nuevo.');
            
        }
        $this->header('', '?err=Error desconocido');

    }

    private function checkBrute($idusuario) {
        $intentosvalidos = time() - (1 * 5 * 60); //30Min (1 * 30 * 60) - 1Hr (1 * 60 * 60) - 2Hr (2 * 60 * 60) - 3Hr (3 * 60 * 60) ...

        if ($stmt = $this->mysqli->prepare('SELECT hora FROM intentossesion WHERE idusuario = ? AND hora > ?')) {
            $stmt->bind_param('is', $idusuario, $intentosvalidos);
            $stmt->execute();
            $stmt->store_result();

            if ($stmt->num_rows > 20) {
                return true;
            }
        }
        return false;
    }

    private function loginCheck() {
        if(isset($this->session['idusuario'], $this->session['email'], $this->session['nombres'], $this->session['apellidos'], $this->session['rol'], $this->session['estado'], $this->session['cadenalogin'])) {
            $this->idusuario = $this->session['idusuario'];
            $this->email = $this->session['email'];
            $this->nombres = $this->session['nombres'];
            $this->apellidos = $this->session['apellidos'];
            $this->estado = $this->session['estado'];
            $this->rol = $this->session['rol'];
            $this->cadenalogin = $this->session['cadenalogin'];
            
            $user_browser = $_SERVER['HTTP_USER_AGENT'] . $this->userIp();

            if($stmt = $this->mysqli->prepare('SELECT usuario.clave, usuario.estado FROM usuario JOIN sesion ON usuario.idusuario = sesion.idusuario WHERE usuario.idusuario = ? AND sesion.cadenalogin = ? AND sesion.horafin IS NULL')) {
                $stmt->bind_param('is', $this->idusuario, $this->cadenalogin);
                $stmt->execute();
                $stmt->store_result();
                
                if ($stmt->num_rows > 0) {
                    $stmt->bind_result($clave, $estado);
                    $stmt->fetch();
                    $login_check = hash('sha512', $clave . $user_browser);

                    if($estado == 1) {
                        if(hash_equals($login_check, $this->cadenalogin)) {
                            return true;
                        }
                    }
                }
            }
        }
        unset($this->idusuario, $this->email, $this->nombres, $this->apellidos, $this->estado, $this->cadenalogin);
        return false;

    }
    /* END - Login functions */

    

    public function displayMsgs() {
        if(isset($this->get['err'])) {
            return '<div class="error">' . $this->get['err'] . '</div>';
        }

        if(isset($this->get['suc'])) {
            return '<div class="succes">' . $this->get['suc'] . '</div>';
        }
    }

    private function redirect() {
        if(isset($this->get['loginHandler'])) {
            return $this->loginHandler();
            exit;

        } else if(isset($this->get['recoverPassword'])) {
            return $this->recoverPassword();

        } else if(isset($this->get['logoutHandler'])) {
            return $this->logoutHandler();

        } else if(isset($this->get['saveUser'])) {
            return $this->saveUser();

        } else if(isset($this->get['statusUser'])) {
            return $this->statusUser();

        } else if(isset($this->get['statusColeccion'])) {
            return $this->statusColeccion();

        } else if(isset($this->get['saveColeccion'])) {
            return $this->saveColeccion();

        } else if(isset($this->get['saveDocumento'])) {
            return $this->saveDocumento();

        } else if(isset($this->get['busqueda'])) {
            return $this->busqueda();

        }
        
    }

    public function formOpen($action = '') {
        return '<form action="' . $action . '" method="post" enctype="multipart/form-data"><input type="hidden" name="token" value="' . $this->token . '">';
    }

    public function formClose() {
        return '</form>';
    }

    protected function generateToken() {
        $this->token = hash('sha512', openssl_random_pseudo_bytes(16));
        $_SESSION['token'] = $this->token;
        return $this->token;
    }

    protected function checkToken() {
        //if(isset($this->session['token'], $this->post['token']) && $this->session['token'] == $this->post['token']) {
            return true;
        /*}
        return false;*/
    }

    protected function userIp() {
        $ipaddress = '';

        if (getenv('HTTP_CLIENT_IP')) {
            $ipaddress = getenv('HTTP_CLIENT_IP');

        } else if(getenv('HTTP_X_FORWARDED_FOR')) {
            $ipaddress = getenv('HTTP_X_FORWARDED_FOR');

        } else if(getenv('HTTP_X_FORWARDED')) {
            $ipaddress = getenv('HTTP_X_FORWARDED');

        } else if(getenv('HTTP_FORWARDED_FOR')) {
            $ipaddress = getenv('HTTP_FORWARDED_FOR');

        } else if(getenv('HTTP_FORWARDED')) {
            $ipaddress = getenv('HTTP_FORWARDED');

        } else if(getenv('REMOTE_ADDR')) {
            $ipaddress = getenv('REMOTE_ADDR');

        } else {
            $ipaddress = 'UNKNOWN';

        }
     
        return $ipaddress;
    }

    public function header($url = 'index.php', $params = '?') {
        //header('Location: ' . $url . $params);
        echo '
        Haga <a href="' . $url . $params . '">clic aquí</a> para continuar.
        <script>window.location = "' . $url . $params . '";</script>';
        exit;
    }

    protected function log($msg, $display = false, $type = 'ERROR') {
        //Handle errors
    }

    protected function busqueda() {
        $_SESSION['busqueda'] = array();

        $palabra = isset($this->post['palabra']) ? $this->post['palabra'] : '';
        $filtro = isset($this->post['filtro']) ? $this->post['filtro'] : '';
        $condicional = isset($this->post['condicional']) ? $this->post['condicional'] : '';
        $palabracondicional = isset($this->post['palabracondicional']) ? $this->post['palabracondicional'] : '';
        $filtrocondicional = isset($this->post['filtrocondicional']) ? $this->post['filtrocondicional'] : '';
        if($palabra != '') {
            if($filtro == 'titulo' || $filtro == 'editorial' || $filtro == 'resumen') {
                array_push($_SESSION['busqueda'], ' AND documentos.' . $filtro . ' LIKE "%' . $palabra . '%" ');

            } else if($filtro == 'autor' || $filtro == 'palabras_clave') {
                array_push($_SESSION['busqueda'], ' AND (documento_valores_multiples.tipo = "' . $filtro . '" AND documento_valores_multiples.valor LIKE "%' . $palabra . '%") ');

            } else {
                array_push($_SESSION['busqueda'], ' AND (documentos.titulo LIKE "%' . $palabra . '%" OR documentos.editorial LIKE "%' . $palabra . '%"  OR documentos.resumen LIKE "%' . $palabra . '%" OR (documento_valores_multiples.tipo = "autor" AND documento_valores_multiples.valor LIKE "%' . $palabra . '%") OR (documento_valores_multiples.tipo = "palabra_clave" AND documento_valores_multiples.valor LIKE "%' . $palabra . '%")) ');

            }

            if($palabracondicional != '') {
                if($filtrocondicional == 'titulo' || $filtrocondicional == 'editorial' || $filtrocondicional == 'resumen') {
                    array_push($_SESSION['busqueda'], ' ' . $condicional . ' documentos.' . $filtrocondicional . ' LIKE "%' . $palabracondicional . '%" ');
    
                } else if($filtrocondicional == 'autor' || $filtrocondicional == 'palabras_clave') {
                    array_push($_SESSION['busqueda'], ' ' . $condicional . ' (documento_valores_multiples.tipo = "' . $filtrocondicional . '" AND documento_valores_multiples.valor LIKE "%' . $palabracondicional . '%") ');
    
                } else {
                    array_push($_SESSION['busqueda'], ' ' . $condicional . ' (documentos.titulo LIKE "%' . $palabracondicional . '%" OR documentos.editorial LIKE "%' . $palabracondicional . '%"  OR documentos.resumen LIKE "%' . $palabracondicional . '%" OR (documento_valores_multiples.tipo = "autor" AND documento_valores_multiples.valor LIKE "%' . $palabracondicional . '%") OR (documento_valores_multiples.tipo = "palabra_clave" AND documento_valores_multiples.valor LIKE "%' . $palabracondicional . '%")) ');

                }
            }
        }

        $tipoArray = array();
        $tipocont = isset($this->post['tipocont']) ? $this->post['tipocont'] : 0;
        for($a=1; $a<=$tipocont; $a++) {
            $tipo = isset($this->post['tipo_'.$a]) ? $this->post['tipo_'.$a] : '';
            if($tipo != '') {
                array_push($tipoArray, ' documentos.tipo = "' . $tipo . '" ');
            }
        }
        $cont = 1;
        $tipoSQL = '';
        foreach($tipoArray as $value) {
            $tipoSQL .= ($cont == 1 ? ' ( ' : ' OR ') . '' . $value . '';
            $cont++;
        }
        $tipoSQL .= ($cont > 1 ? ' ) ' : '');
        if($tipoSQL != '') {
            array_push($_SESSION['busqueda'], ' AND ' . $tipoSQL . ' ');
        }

        $coleccionArray = array();
        $coleccioncont = isset($this->post['coleccioncont']) ? $this->post['coleccioncont'] : '';
        for($a=1; $a<=$coleccioncont; $a++) {
            $idcoleccion = isset($this->post['coleccion_'.$a]) ? $this->post['coleccion_'.$a] : 0;
            if($idcoleccion > 0) {
                array_push($coleccionArray, ' documentos.idcoleccion = "' . $idcoleccion . '" ');
            }
        }
        $cont = 1;
        $coleccionSQL = '';
        foreach($coleccionArray as $value) {
            $coleccionSQL .= ($cont == 1 ? ' ( ' : ' OR ') . '' . $value . '';
            $cont++;
        }
        $coleccionSQL .= ($cont > 1 ? ' ) ' : '');
        if($coleccionSQL != '') {
            array_push($_SESSION['busqueda'], ' AND ' . $coleccionSQL . ' ');
        }
        
        $fecha_desde = isset($this->post['fecha_desde']) ? $this->post['fecha_desde'] : '';
        if($fecha_desde != '') {
            array_push($_SESSION['busqueda'], ' AND documentos.year_publicacion >= "' . $fecha_desde . '" ');

        }
        $fecha_hasta = isset($this->post['fecha_hasta']) ? $this->post['fecha_hasta'] : '';
        if($fecha_hasta != '') {
            array_push($_SESSION['busqueda'], ' AND documentos.year_publicacion <= "' . $fecha_hasta . '" ');

        }

        $disponibilidad = isset($this->post['disponibilidad']) ? $this->post['disponibilidad'] : '';
        if($disponibilidad != '') {
            array_push($_SESSION['busqueda'], ' AND documentos.disponibilidad LIKE "%' . $disponibilidad . '%" ');

        }
        
        $this->header('busqueda.php');
    }

    private function sqlBuscador($cont = false, $filtro = '') {
        $groupBy = ' GROUP BY documentos.iddocumento ';
        $offset = isset($this->get['offset']) && $this->get['offset'] > 0 ? (int)$this->registrosPagina : 0;
        $sql = 'SELECT documentos.iddocumento FROM documentos LEFT JOIN documento_valores_multiples ON documento_valores_multiples.iddocumento = documentos.iddocumento LEFT JOIN coleccion ON coleccion.idcoleccion = documentos.idcoleccion WHERE 1 = 1 ';
        
        $filtro = isset($this->get['filtro']) ? $this->get['filtro'] : '';
        $valor = isset($this->get['valor']) ? $this->get['valor'] : '';

        if(isset($this->rol)) {
            if($this->rol == 1) {
                $sql .= ' ';

            } else if($this->rol == 2) {
                $sql .= ' AND documentos.tipo_acceso != "solo_par_adm" ';

            } else {
                $sql .= ' AND documentos.tipo_acceso = "lib" ';

            }
        } else {
            $sql .= ' AND documentos.tipo_acceso = "lib" ';
        }

        if($filtro != '' && $valor != '' ) {
            if($filtro == 'autor' || $filtro == 'autor_corporativo' || $filtro == 'editor' || $filtro == 'palabras_clave') {
                $sql .= ' AND documento_valores_multiples.tipo = "' . $filtro . '" AND documento_valores_multiples.valor = "' . $valor . '" ';

            } else if($filtro == 'coleccion') {
                $sql .= ' AND documentos.idcoleccion = "' . $valor . '" ';

            }

        } 
        
        if(isset($_SESSION['busqueda']) && count($_SESSION['busqueda']) > 0) {
            foreach($_SESSION['busqueda'] as $value) {
                $sql .= ' ' . $value . ' ';
            }

        }

        if(isset($this->session['year_publicacion']) && $this->session['year_publicacion'] != '' && $this->session['year_publicacion'] != '0') {
            $sql .= ' AND documentos.year_publicacion >= "' . $this->session['year_publicacion'] . '" ';

        }

        if(isset($this->session['idioma']) && $this->session['idioma'] != '' && $this->session['idioma'] != '0') {
            $sql .= ' AND documentos.idioma = "' . $this->session['idioma'] . '" ';

        }

        if(isset($this->session['disponibilidad']) && $this->session['disponibilidad'] != '' && $this->session['disponibilidad'] != '0') {
            $sql .= ' AND documentos.disponibilidad = "' . $this->session['disponibilidad'] . '" ';

        }
        
        if(isset($this->session['orden']) && strpos($this->session['orden'], 'ORDER') !== false) {
            $sql .= ' ' . $groupBy . ' ' . $this->session['orden'] . ' ';
            $groupBy = '';

        }

        //$sql .= ($filtro == '' ? '' : ' ' . $groupBy . ' ') . ($cont ? '' : 'LIMIT ' . $this->registrosPagina . ' OFFSET ' . $offset . ' ');
        $sql .= ' ' . $groupBy . ' ' . ($cont ? ' ' : ' LIMIT ' . $this->registrosPagina . ' OFFSET ' . $offset . ' ');
        echo '<div style="display:none;">' . $sql . '<br />'.$this->session['orden'].'</div>';
        return $sql;
    }

    public function busqueda_resultados($cont = false) {
        $return = array();
        
        $sql = $this->sqlBuscador($cont);

        $documentos = 0;

        $consulta = $this->mysqli->query($sql) or exit('Error: ' . $sql . '-');
        while($resultados = $consulta->fetch_array()) {
            $documento = $this->documento_detalle($resultados['iddocumento']);
            if(isset($documento['iddocumento']) && $documento['iddocumento'] > 0) {
                if($cont) {
                    $documentos++;

                } else {
                    array_push($return, $documento);

                }

            }
        }

        
        if($cont) {
            $return = $documentos;

        }

        return $return;
    }
}

$iets = new IETS($_GET, $_POST); ?>
