function loadTipoOfertaDesc(tipo) {
    $.post( 'dynamic/tipoofertadesc.php', { tipo: tipo }, function( data ) {
        $( '#oferta_tipo_explicacion' ).html( data );
    });
}
function loadVerbos(dominio, id) {
    $.post( 'dynamic/verbos.php', { dominio: dominio }, function( data ) {
        $( '#esyllabus_verbo_' + id ).html( data );
        $( '#formas_evaluacion' + id ).html( '' );
    });
}
function loadVerbosDescr(verbo, id) {
    var dominio = document.getElementById('esyllabus_dominio_' + id).value;
    $.post( 'dynamic/verbos.php', { dominio: dominio, verbo: verbo }, function( data ) {
        $( '#formas_evaluacion' + id ).html( data );
    });
}
$(document).ready( function() {
    $('body').on("click", ".toggle", function(){
        var value = $(this).val();
        var div = $(this).attr('data-div');
        var type = $(this).attr('type');
        $('.div' + div).hide();
        if(type == 'radio' || type == 'checkbox') {
            if(value == 'Médico especialista' || value == "Si") {
                $('.div' + div).show();
            } if(value == 'Médico general' || value == "No") {
                $('.div' + div).hide();
            } else if($(this).is(':checked')) {
                $('.div' + div).show();
            }
        }
     })
    $( "#pregrado_universidad, #especialidad_universidad" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "common/universidades.php",
                type: 'post',
                dataType: "json",
                data: {
                search: request.term
                },
                success: function( data ) {
                    response( data );
                }
            });
        },
        select: function (event, ui) {
            $(this).val(ui.item.label);
            
            return false;
        }
    });
    $( "#especialidad" ).autocomplete({
        source: function( request, response ) {
            $.ajax({
                url: "common/programas.php",
                type: 'post',
                dataType: "json",
                data: {
                search: request.term
                },
                success: function( data ) {
                    response( data );
                }
            });
        },
        select: function (event, ui) {
            $(this).val(ui.item.label);
            
            return false;
        }
    });
    $( function() {
        $( "#accordion" ).accordion({
            heightStyle: "content"
        });
    } );
    $( "#oferta_tipo" ).on( "change", function() {
        console.log($( this ).val());
        if($( this ).val() == 'Programa de entrenamiento avanzado') {
            $( '.form-programa-entre-avanzado' ).show();
            $( '.form-generico' ).hide();
        } else {
            $( '.form-programa-entre-avanzado' ).hide();
            $( '.form-generico' ).show();
        }
    });
});