<?php header('Location: index.php'); exit; ?>
<?php require('classes/main.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>

<body>
    <?php require('common/header.php'); ?>
    <?php
    $edit = false;
    $iduser = isset($_GET['iduser']) ? (int) $_GET['iduser'] : 0;
    if($main->loginCheck) {
        if($main->adminCheck) {
            if($iduser > 0) {
                $iduser = (int) $iduser;
            } else {
                $iduser = (int) $_SESSION['iduser'];
            }
        } else {
            $iduser = (int) $_SESSION['iduser'];
        }
        $edit = true;
    } else {
        $iduser = 0;
    }
    $users = $main->users($iduser); ?>
    <?php echo $main->formOpen('?register'); ?>
    <input type="hidden" name="iduser" value="<?php echo $iduser; ?>">
    <div class="input box-radius login-form">
        <h1><?php echo $edit ? 'Editar usuario' : 'Regístrese'; ?></h1>
        <div class="form-grp">
            <div class="form-input">
                <span>Datos de ingreso</span>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="email" type="email" class="input" placeholder="Correo electrónico *"
                    value="<?php echo isset($users[$iduser]['email']) ? $users[$iduser]['email'] : ''; ?>"
                    <?php echo $edit ? ' readonly ' : ''; ?>>
            </div>
            <div class="form-input">
                <input name="emailalt" type="email" class="input" placeholder="Correo electrónico alternativo"
                    value="<?php echo isset($users[$iduser]['emailalt']) ? $users[$iduser]['emailalt'] : ''; ?>">
            </div>
        </div>
        <?php if($edit !== true) { ?>
        <div class="form-grp">
            <div class="form-input">
                <input name="pass" type="password" class="input" placeholder="Contraseña">
            </div>
            <div class="form-input">
                <input name="passver" type="password" class="input" placeholder="Ingrese la contraseña de nuevo">
            </div>
        </div>
        <?php } else if($main->adminCheck) { ?>
        <div class="form-grp">
            <div class="form-input">
                <label><input name="status" type="checkbox" value="1"
                        <?php echo isset($users[$iduser]['status']) && 1 == $users[$iduser]['status'] ? 'checked' : ''; ?>>
                    Habilitar este usuario</label><br />
                <label><input name="admin" type="checkbox" value="1"
                        <?php echo isset($users[$iduser]['admin']) && 1 == $users[$iduser]['admin'] ? 'checked' : ''; ?>>
                    Administrador</label>
                <label><input name="adminver" type="checkbox" value="1"
                        <?php echo isset($users[$iduser]['admin']) && 1 == $users[$iduser]['admin'] ? 'checked' : ''; ?>>
                    Confirmo a este usuario como administrador</label>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                Para cambiar la contraseña utilice este <a href="recover-password.php">enlace</a>.
            </div>
        </div>
        <?php } ?>
        <div class="form-grp">
            <div class="form-input">
                <span>Datos personales</span>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="fname" type="text" class="input" placeholder="Nombres *"
                    value="<?php echo isset($users[$iduser]['fname']) ? $users[$iduser]['fname'] : ''; ?>">
            </div>
            <div class="form-input">
                <input name="lname" type="text" class="input" placeholder="Apellidos *"
                    value="<?php echo isset($users[$iduser]['lname']) ? $users[$iduser]['lname'] : ''; ?>">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <select name="idtype_id">
                    <option value="">--Tipo de identificación *--</option>
                    <?php foreach($main->getvalues('type_id') as $key => $data) { ?>
                    <option value="<?php echo $key; ?>"
                        <?php echo isset($users[$iduser]['idtype_id']) && $key == $users[$iduser]['idtype_id'] ? 'selected' : ''; ?>>
                        <?php echo $data['value']; ?></option>
                    <?php } ?>
                </select>
            </div>
            <div class="form-input">
                <input name="number_id" type="number" class="input"
                    placeholder="Número de identificación (Solo números) *"
                    value="<?php echo isset($users[$iduser]['number_id']) ? $users[$iduser]['number_id'] : ''; ?>">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="institution" type="text" class="input" placeholder="Institución"
                    value="<?php echo isset($users[$iduser]['institution']) ? $users[$iduser]['institution'] : ''; ?>">
            </div>
            <div class="form-input">
                <input name="position" type="text" class="input" placeholder="Cargo"
                    value="<?php echo isset($users[$iduser]['position']) ? $users[$iduser]['position'] : ''; ?>">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="celular" type="number" class="input" placeholder="Celular (Solo números)"
                    value="<?php echo isset($users[$iduser]['celular']) ? $users[$iduser]['celular'] : ''; ?>">
            </div>
            <div class="form-input">
                <input name="telefono" type="text" class="input" placeholder="Telefono"
                    value="<?php echo isset($users[$iduser]['telefono']) ? $users[$iduser]['telefono'] : ''; ?>">
            </div>
        </div>
        <?php if($main->adminCheck) { ?>
        <div class="form-grp">
            <div class="form-input">
                <span>Especialidades asociadas</span>
                <div class="div-overflow">
                    <?php
                    $cont = 0;
                    foreach($main->subjects() as $idsubject => $subjects) {
                        $cont = $cont < $idsubject ? $idsubject : $cont; ?>
                    <label><input type="checkbox" name="idsubject<?php echo $idsubject; ?>"
                            value="<?php echo $idsubject; ?>"
                            <?php echo $main->checkUserSubject($iduser, $idsubject) ? ' checked ' : ''; ?>>
                        <?php echo $subjects['subject']; ?><?php echo $subjects['status'] == 0 ? ' <em>(Deshabilitado)</em>' : ''; ?></label><br />
                    <?php } ?>
                    <input name="idsubjectcont" type="hidden" value="<?php echo $cont; ?>">
                </div>
            </div>
            <div class="form-input">
                <span>Perfiles asociados</span>
                <div class="div-overflow">
                    <?php
                    $cont = 0;
                    foreach($main->profiles() as $idprofile => $profile) {
                        $cont = $cont < $idprofile ? $idprofile : $cont; ?>
                    <label><input type="radio" name="idprofile"
                            value="<?php echo $idprofile; ?>" <?php echo $users[$iduser]['idprofile'] == $idprofile ? 'checked' : ''; ?>>
                        <?php echo $profile['profile']; ?></label><br />
                    <?php } ?>
                    <input name="idprofilecont" type="hidden" value="<?php echo $cont; ?>">
                </div>
            </div>
        </div>
        <?php } ?>
        <div class="form-grp">
            <div class="form-input text-center">
                <img id="captcha_image" src="captcha/captcha.php?rand=<?php rand(); ?>'">
                <br />
                <a href="javascript:refreshCaptcha();" class="label_captcha">Cambiar imagen</a>
                <br />
                <input name="captcha" class="input" type="text" placeholder="Codigo de imagen">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                <p>* Campos obligatorios.</p>
                <input type="submit" class="btn btn-success" value="Enviar">
            </div>
        </div>
    </div>
    <?php echo $main->formClose(); ?>
    <?php require('common/footer.php'); ?>
</body>

</html>