<?php require('classes/main.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>

<body>
    <?php require('common/header.php'); ?>
    <?php $site = $main->site(); ?>
    <div class="input box-radius login-form">
        <div class="form-grp">
            <div class="form-input">
                <h1 style="text-align: center;"><span style="color: #236fa1;">BIENVENIDOS</span></h1>
                <p style="text-align: justify;"><span style="font-family: helvetica, arial, sans-serif;">Este proceso 
                participativo y de consenso tiene como objetivo principal actualizar los lineamientos de formación de 
                las especializaciones médico-quirúrgicas en Colombia. En este proceso participan la academia, los residentes, 
                los servicios de salud, las sociedades científicas y expertos, todos trabajando juntos para garantizar 
                la calidad de la formación de nuestros especialistas.</span><br><br><span
                        style="font-family: helvetica, arial, sans-serif;">El trabajo se basa en el respeto a las opiniones y 
                        contribuciones de todos los participantes. Para llevar a cabo este proceso, se utilizan documentos 
                        institucionales y gremiales, tanto a nivel nacional como internacional, que respaldan la formación de 
                        especialistas médico-quirúrgicos en la actualidad.</span><br><br>
                        <span style="font-family: helvetica, arial, sans-serif;"> </span></p>
                <p><span style="font-family: helvetica, arial, sans-serif;">Durante el proceso, se abordarán las siguientes áreas:</span></p>
                <ul>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Perfil del especialista</span></li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Grupo poblacional objetivo</span>
                    </li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Enfermedades, sistemas y órganos</span>
                    </li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Dominios de acción</span></li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Conocimientos básicos y
                            obligatorios</span></li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Escenarios de desempeño</li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Procedimientos básicos obligatorios
                    </li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Competencias genéricas</li>
                    <li><span style="font-family: helvetica, arial, sans-serif;">Competencias específicas</li>
                </ul>
                </p>
                <p><span style="font-family: helvetica, arial, sans-serif;">Es importante tener en cuenta que este proceso es confidencial. 
                Los datos proporcionados en este formulario se presentarán de manera consolidada en las reuniones de la sala de posgrados 
                del Consejo General de Educación Médica de Ascofame.</span></p>
                <p><span style="font-family: helvetica, arial, sans-serif;">Está a punto de iniciar el proceso. Le sugerimos contar con una conexión de internet estable en un lugar tranquilo. Tenga presente que algunas instituciones limitan el ingreso a esta plataforma, lo que puede generar dificultades al guardar la información. </span></p>
                <p><span style="font-family: helvetica, arial, sans-serif;">Durante el proceso de diligenciamiento encontrará el botón para pre guardar la información (imagen del botón); le sugerimos pre guardar los datos a medida que avanza con el propósito de evitar pérdida de información. Una vez finalice el proceso, guarde la información, verifíquela y envíela. En indispensable enviar la información para que pueda ser analizada por nuestro equipo de expertos</span></p>
                <p><span style="font-family: helvetica, arial, sans-serif;">A continuación, seleccione el perfil:</span>
                </p>
            </div>
        </div>
    </div>
    <?php echo $main->formOpen('step.php?step1'); ?>
    <?php if($main->loginCheck) { ?>
    <div class="input box-radius login-form">
        <div class="form-grp">
            <div class="form-input">
                <select name="idsubject">
                    <option value="">--Seleccione especialidad--</option>
                    <?php
                    $optionsSent = '';
                    $optionsAvailable = '';
                    $optionsUnavailable = '';
                    foreach($main->subjects() as $idsubject => $subjects) {
                        if($main->checkUserSubject($_SESSION['iduser'], $idsubject)) {
                            if($main->checkStepVerification($_SESSION['iduser'], $idsubject)) {
                                $optionsSent .= '<option value="' . $idsubject . '">' . $subjects['subject'] . '</option>';
                            } else if($subjects['status'] == 0) {
                                $optionsUnavailable .= '<option value="" disabled>' . $subjects['subject'] . '</option>';
                            } else {
                                $optionsAvailable .= '<option value="' . $idsubject . '">' . $subjects['subject'] . '</option>';
                            }
                        }
                    }
                    if($optionsAvailable != '') { ?>
                    <optgroup label="Pendiente(s)">
                        <?php echo $optionsAvailable; ?>
                    </optgroup>
                    <?php } 
                    if($optionsSent != '') { ?>
                    <optgroup label="Enviado(s)">
                        <?php echo $optionsSent; ?>
                    </optgroup>
                    <?php }
                    if($optionsUnavailable != '') { ?>
                    <optgroup label="Deshabilitado(s)">
                        <?php echo $optionsUnavailable; ?>
                    </optgroup>
                    <?php } ?>
                </select>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                <input type="submit" class="btn btn-success" value="Siguiente">
            </div>
        </div>
    </div>
    <?php } else {
        $main->header('login.php');
    } ?>
    <?php echo $main->formClose(); ?>
    <?php require('common/footer.php'); ?>
</body>

</html>