<?php require('classes/main.php'); ?>
<?php require('classes/adminCheck.php'); ?>
<?php require('classes/administration.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>

<body>
    <?php require('common/header.php'); ?>
    <h1>Administración - Usuarios</h1>
    <table id="datatable" class="stripe" style="width:100%">
        <thead>
            <tr>
                <th>Id.</th>
                <th>Usuario</th>
                <th>Institución</th>
                <th>Perfil</th>
                <th>Especialidades</th>
                <th>Opciones</th>
                <th>Fecha de registro</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($main->users() as $iduser => $users) { ?>
            <tr>
                <td><?php echo $users['status'] == 0 ? ' <em>(Desactivado)</em>' : $iduser; ?></td>
                <td><?php echo $users['admin'] == 1 ? '<img src="img/star.png" class="icon" title="Administrador"> ' : ''; ?><strong><?php echo $users['fname'] . ' ' . $users['lname']; ?></strong><br />
                    <?php echo $users['email']; ?><br />
                    <?php 
                    $type_arr = $main->getvalues('type_id', $users['idtype_id']);
                    echo $type_arr[$users['idtype_id']]['value'] . ' ' . $users['number_id']; ?></td>
                <td>
                    <?php echo $users['institution']; ?><br />
                    <?php echo $users['position']; ?><br />
                </td>
                <td>
                    <a
                        href="admin-profile.php?profile&idprofile=<?php echo $users['idprofile']; ?>"><?php echo $users['profile']; ?></a>
                </td>
                <td>
                    <ol><?php foreach($users['subject'] as $idsubject => $subject) { ?>
                        <li style="white-space:nowrap;"><a href="admin-subject.php?subject&idsubject=<?php echo $idsubject; ?>"><?php echo $subject; ?><img
                                    src="img/<?php echo $main->checkStepVerification($iduser, $idsubject) ? 'ok.png' : 'warning.png'; ?>"
                                    class="icon" alt="" title="" /></a>
                        </li>
                        <?php } ?>
                    </ol>
                </td>
                <td><a href="register.php?iduser=<?php echo $iduser; ?>">Editar</a></td>
                <td><?php echo $users['created']; ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    <?php require('common/footer.php'); ?>
</body>

</html>