<?php require('classes/main.php'); ?>
<?php require('classes/adminCheck.php'); ?>
<?php require('classes/administration.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>
<body>
    <?php require('common/header.php'); ?>
    <h1>Administración - Especialidades</h1>
    <?php
    if(isset($_GET['subject'])) {
        echo $main->formOpen('?saveSubject');
        $idsubject = isset($_GET['idsubject']) ? (int) $_GET['idsubject'] : 0;
        $subjects = $main->subjects($idsubject); ?>
    <input name="idsubject" type="hidden" class="input" value="<?php echo $idsubject; ?>">
    <div class="input box-radius login-form">
        <div class="form-grp">
            <div class="form-input">
                <span><?php echo $idsubject > 0 ? 'Editar' : 'Crear'; ?> especialidad</span>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="subject" type="text" class="input" placeholder="Especialidad"
                    value="<?php echo isset($subjects[$idsubject]['subject']) ? $subjects[$idsubject]['subject'] : ''; ?>">
            </div>
        </div>
        <div id="accordion">
            <h3>Perfil</h3>
            <div class="input box-radius login-form">
                <div class="form-grp">
                    <div class="form-input">
                        <textarea name="profile"
                            class="richtext"><?php echo $subjects[$idsubject]['profile']; ?></textarea>
                    </div>
                </div>
            </div>

        </div>
        <?php if($idsubject > 0) { ?>
        <div class="form-grp">
            <div class="form-input">
                <label><input name="status" type="checkbox" value="1"
                        <?php echo isset($subjects[$idsubject]['status']) && 1 == $subjects[$idsubject]['status'] ? 'checked' : ''; ?>>
                    Habilitar esta especialidad para recibir respuestas</label>
            </div>
        </div>
        <?php } ?>
        <div class="form-grp">
            <div class="form-input">
                <div class="div-overflow">
                    <?php
                    $cont = 0;
                    foreach($main->users() as $iduser => $subjects) {
                        $cont = $cont < $iduser ? $iduser : $cont; ?>
                    <label><input type="checkbox" name="iduser<?php echo $iduser; ?>" value="<?php echo $iduser; ?>"
                            <?php echo $main->checkUserSubject($iduser, $idsubject) ? ' checked ' : ''; ?>>
                        <?php echo $subjects['fname'] . ' ' . $subjects['lname']; ?></label><br />
                    <?php } ?>
                    <input name="idusercont" type="hidden" value="<?php echo $cont; ?>">
                </div>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                <input type="button" class="btn btn-return" value="Volver a especialidades"
                    onclick="window.location = '<?php echo $_SERVER['PHP_SELF']?>';">
            </div>
            <div class="form-input text-center">
                <input type="submit" class="btn btn-success" value="Guardar">
            </div>
        </div>
    </div>
    <?php echo $main->formClose(); ?>
    <?php } else { ?>
    <div class="form-grp">
        <div class="form-input text-center">
            <a href="?subject" class="">Nueva especialidad</a>
        </div>
    </div>
    <table id="datatable" class="stripe" style="width:100%">
        <thead>
            <tr>
                <th>Id.</th>
                <th>Especialidad</th>
                <th>Usuarios</th>
                <th>Opciones</th>
                <th>Documentos</th>
                <th>Fecha de registro</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($main->subjects() as $idsubject => $subjects) { ?>
            <tr>
                <td><?php echo $subjects['status'] == 0 ? '<em>(Desactivado)</em>' : $idsubject; ?></td>
                <td><?php echo $subjects['subject']; ?></td>
                <td>
                    <ol><?php foreach($main->users() as $iduser => $users) {
                    if($main->checkUserSubject($iduser, $idsubject)) { ?>
                        <li><a
                                href="register.php?iduser=<?php echo $iduser; ?>"><?php echo $users['fname'] . ' ' . $users['lname']; ?></a>
                        </li>
                        <?php }
                } ?></ol>
                </td>
                <td><a href="admin-subject.php?subject&idsubject=<?php echo $idsubject; ?>"><img src="img/edit.png"
                            class="icon" /></a></td>
                <td><a href="admin-subject-documents.php?idsubject=<?php echo $idsubject; ?>"><img
                            src="img/documents.png" class="icon" /></a></td>
                <td><?php echo $subjects['created']; ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    <?php } ?>
    <?php require('common/footer.php'); ?>
</body>
</html>