<?php require('classes/main.php'); ?>
<?php require('classes/adminCheck.php'); ?>
<?php require('classes/administration.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>

<body>
    <?php require('common/header.php'); ?>
    <?php
    $idsubject = isset($_GET['idsubject']) ? (int) $_GET['idsubject'] : 0;
    $idsubjectdocument = isset($_GET['idsubjectdocument']) ? (int) $_GET['idsubjectdocument'] : 0;
    $subjects = $main->subjects($idsubject);
    $subjectsdocuments = $main->subjectsDocuments($idsubject, $idsubjectdocument); ?>
    <h1>Administración - Documentos de <em><?php echo $subjects[$idsubject]['subject']; ?></em></h1>
    <?php if(isset($_GET['document'])) { ?>
    <?php echo $main->formOpen('?saveSubjectDocument'); ?>
    <input name="idsubject" type="hidden" class="input" value="<?php echo $idsubject; ?>">
    <input name="idsubjectdocument" type="hidden" class="input" value="<?php echo $idsubjectdocument; ?>">
    <div class="input box-radius login-form">
        <div class="form-grp">
            <div class="form-input">
                <span><?php echo $idsubjectdocument > 0 ? 'Editar' : 'Crear'; ?> documento</span>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="title" type="text" class="input" placeholder="Titulo"
                    value="<?php echo isset($subjectsdocuments[$idsubjectdocument]['title']) ? $subjectsdocuments[$idsubjectdocument]['title'] : ''; ?>">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <textarea name="description"
                    placeholder="Descripcion"><?php echo isset($subjectsdocuments[$idsubjectdocument]['description']) ? $subjectsdocuments[$idsubjectdocument]['description'] : ''; ?></textarea>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <select name="typepath" id="typepath">
                    <option value="">--Seleccione el tipo de documento--</option>
                    <option value="file"
                        <?php echo isset($subjectsdocuments[$idsubjectdocument]['typepath']) && $subjectsdocuments[$idsubjectdocument]['typepath'] == 'file' ? 'selected' : ''; ?>>
                        Archivo</option>
                    <option value="url"
                        <?php echo isset($subjectsdocuments[$idsubjectdocument]['typepath']) && $subjectsdocuments[$idsubjectdocument]['typepath'] == 'url' ? 'selected' : ''; ?>>
                        Enlace</option>
                </select>
            </div>
            <div class="form-input">
                <input name="pathfile" id="pathfile" type="file" placeholder="Documento"
                    style="display: <?php echo isset($subjectsdocuments[$idsubjectdocument]['typepath']) && $subjectsdocuments[$idsubjectdocument]['typepath'] == 'file' ? 'block' : 'none'; ?>;">
                <input name="pathurl" id="pathurl" type="url" class="input" placeholder="Enlace"
                    style="display: <?php echo isset($subjectsdocuments[$idsubjectdocument]['typepath']) && $subjectsdocuments[$idsubjectdocument]['typepath'] == 'url' ? 'block' : 'none'; ?>;"
                    value="<?php echo isset($subjectsdocuments[$idsubjectdocument]['path']) ? $subjectsdocuments[$idsubjectdocument]['path'] : ''; ?>">
                <?php if(isset($subjectsdocuments[$idsubjectdocument]['path']) && $subjectsdocuments[$idsubjectdocument]['path'] != '') { ?>
                <a href="<?php echo $subjectsdocuments[$idsubjectdocument]['path']; ?>"
                    target="_blank"><?php echo $subjectsdocuments[$idsubjectdocument]['path']; ?></a>
                <?php } ?>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <label><input type="checkbox" name="private" value="1"
                        <?php echo isset($subjectsdocuments[$idsubjectdocument]['private']) && $subjectsdocuments[$idsubjectdocument]['private'] == 1 ? 'checked' : ''; ?>>
                    Este
                    documento solo puede ser consultado por usuarios registrados.</label>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                <input type="button" class="btn btn-return" value="Volver a documentos"
                    onclick="window.location = '<?php echo $_SERVER['PHP_SELF'] . '?idsubject=' . $idsubject; ?>';">
            </div>
            <div class="form-input text-center">
                <input type="submit" class="btn btn-success" value="Guardar">
            </div>
        </div>
    </div>
    <?php echo $main->formClose(); ?>
    <?php } else { ?>
    <div class="form-grp">
        <div class="form-input text-center">
            <a href="?document&idsubject=<?php echo $idsubject; ?>" class="">Nuevo documento</a>
        </div>
    </div>
    <table id="datatable" class="stripe" style="width:100%">
        <thead>
            <tr>
                <th>Id.</th>
                <th>Documento</th>
                <th>Editar</th>
                <th>Fecha de registro</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($main->subjectsDocuments($idsubject) as $idsubjectdocument => $document) { ?>
            <tr>
                <td><?php echo $idsubjectdocument; ?></td>
                <td><a href="<?php echo $document['path'] ?>"
                        target="_blank"><?php echo $document['title']; ?></a><br /><?php echo $document['description']; ?>
                </td>
                <td><a
                        href="?document&idsubject=<?php echo $idsubject; ?>&idsubjectdocument=<?php echo $idsubjectdocument; ?>"><img
                            src="img/edit.png" class="icon" /></a>
                <td><?php echo $document['fname'] . ' ' . $document['lname']; ?><br /><?php echo $document['created']; ?>
                </td>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    <?php } ?>
    <?php require('common/footer.php'); ?>
</body>

</html>