<?php require('classes/main.php'); ?>
<?php require('classes/adminCheck.php'); ?>
<?php require('classes/administration.php'); ?>
<!DOCTYPE html>
<html>
<?php require('common/head.php'); ?>

<body>
    <?php require('common/header.php'); ?>
    <h1>Administración - Perfiles</h1>
    <?php
    if(isset($_GET['profile'])) {
        echo $main->formOpen('?saveProfile');
        $idprofile = isset($_GET['idprofile']) ? (int) $_GET['idprofile'] : 0;
        $profiles = $main->profiles($idprofile); ?>
    <input name="idprofile" type="hidden" class="input" value="<?php echo $idprofile; ?>">
    <div class="input box-radius login-form">
        <div class="form-grp">
            <div class="form-input">
                <span><?php echo $idprofile > 0 ? 'Editar' : 'Crear'; ?> perfil</span>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <input name="profile" type="text" class="input" placeholder="Perfil"
                    value="<?php echo isset($profiles[$idprofile]['profile']) ? $profiles[$idprofile]['profile'] : ''; ?>">
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input">
                <div class="div-overflow">
                    <?php
                    $cont = 0;
                    foreach($main->users() as $iduser => $users) {
                        $cont = $cont < $iduser ? $iduser : $cont; ?>
                    <label><input type="checkbox" name="iduser<?php echo $iduser; ?>" value="<?php echo $iduser; ?>"
                            <?php echo $users['idprofile'] == $idprofile ? 'checked' : ''; ?>>
                        <?php echo $users['fname'] . ' ' . $users['lname']; ?></label><br />
                    <?php } ?>
                    <input name="idusercont" type="hidden" value="<?php echo $cont; ?>">
                </div>
            </div>
        </div>
        <div class="form-grp">
            <div class="form-input text-center">
                <input type="button" class="btn btn-return" value="Volver a perfiles"
                    onclick="window.location = '<?php echo $_SERVER['PHP_SELF']?>';">
            </div>
            <div class="form-input text-center">
                <input type="submit" class="btn btn-success" value="Guardar">
            </div>
        </div>
    </div>
    <?php echo $main->formClose(); ?>
    <?php } else { ?>
    <div class="form-grp">
        <div class="form-input text-center">
            <a href="?profile" class="">Nuevo perfil</a>
        </div>
    </div>
    <table id="datatable" class="stripe" style="width:100%">
        <thead>
            <tr>
                <th>Id.</th>
                <th>Perfil</th>
                <th>Usuarios</th>
                <th>Opciones</th>
                <th>Fecha de registro</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach($main->profiles() as $idprofile => $profiles) { ?>
            <tr>
                <td><?php echo $idprofile; ?></td>
                <td><?php echo $profiles['profile']; ?></td>
                <td>
                    <ol><?php foreach($main->users() as $iduser => $users) {
                    if($users['idprofile'] == $idprofile) { ?>
                        <li><a
                                href="register.php?iduser=<?php echo $iduser; ?>"><?php echo $users['fname'] . ' ' . $users['lname']; ?></a>
                        </li>
                        <?php }
                } ?></ol>
                </td>
                <td><a href="admin-profile.php?profile&idprofile=<?php echo $idprofile; ?>">Editar</a></td>
                <td><?php echo $profiles['created']; ?></td>
            </tr>
            <?php } ?>
        </tbody>
    </table>
    <?php } ?>
    <?php require('common/footer.php'); ?>
</body>

</html>