<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The one column layout.
 *
 * @package   theme_clean
 * @copyright 2013 Moodle, moodle.org
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Get the HTML for the settings bits.
$html = theme_clean_get_html_for_settings($OUTPUT, $PAGE);

echo $OUTPUT->doctype() ?>
<html <?php echo $OUTPUT->htmlattributes(); ?>>
<head>
    <title><?php echo $OUTPUT->page_title(); ?></title>
    <link rel="shortcut icon" href="<?php echo $OUTPUT->favicon(); ?>" />
    <?php echo $OUTPUT->standard_head_html() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>

<body <?php echo $OUTPUT->body_attributes(); ?>>

<?php echo $OUTPUT->standard_top_of_body_html() ?>
<div class="navbar navbar-fixed-top<?php echo $html->navbarclass ?> moodle-has-zindex">
            <table class="header-table-custom">
                <tr id="logos-aula">
                    <td class="header-table-custom-td-1"></td>
                    <td class="header-table-custom-td-2">
                        <a href="https://www.facebook.com/Corazones-que-cuidan-110128641764493" target="new"><img src="http://corazonesquecuidan.org/aula/custom/ico_face_over.png" onmouseover="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_face_over.png';" onmouseout="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_face.png';"></img></a>
                        <a href="https://twitter.com/ASCOFAME_" target="new"><img src="http://corazonesquecuidan.org/aula/custom/ico_twitter.png" onmouseover="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_twitter_over.png';" onmouseout="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_twitter.png';"></img></a>
                        <a href="https://www.youtube.com/channel/UC_9JIASyseDJHiQWrYiB7Dg" target="new"><img src="http://corazonesquecuidan.org/aula/custom/ico_youtube.png" onmouseover="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_youtube_over.png';" onmouseout="this.src = 'http://corazonesquecuidan.org/aula/custom/ico_youtube.png';"></img></a></td>
                </tr>
                <tr id="custom-nav-banner">
                    <td><?php echo $OUTPUT->full_header(); ?></td>
                    
                    <td><?php echo $OUTPUT->user_menu(); ?></td>
                </tr>
            </table>
        </div>

<div id="page" class="container-fluid">

    <div id="page-content" class="row-fluid">
        <section id="region-main" class="span12">
            <?php
            echo $OUTPUT->course_content_header();
            echo $OUTPUT->main_content();
            echo $OUTPUT->course_content_footer();
            ?>
        </section>
    </div>

    <footer id="page-footer">
        <div id="course-footer"><?php echo $OUTPUT->course_footer(); ?></div>
        <p class="helplink"><?php echo $OUTPUT->page_doc_link(); ?></p>
        <?php
        echo $html->footnote;
        echo $OUTPUT->login_info();
        echo $OUTPUT->home_link();
        echo $OUTPUT->standard_footer_html();
        ?>
    </footer>

    <?php echo $OUTPUT->standard_end_of_body_html() ?>

</div>
<script>
            var myButton = document.getElementsByClassName("servicioalestudiante")[0];
            myButton.onclick = function(e) {
                window.open("http://corazonesquecuidan.org/aula/custom/servicio-al-estudiante.php", "_blank", "toolbar=yes,scrollbars=yes,resizable=yes,top=100,left=100,width=500,height=500");
            }
</script>
</body>
</html>
